/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.Messages;

public class ActionCopyMarker
extends SelectionProviderAction {
    private IWorkbenchPart part;
    private Clipboard clipboard;
    private IField[] properties;

    public ActionCopyMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, Messages.getString("copyAction.title"));
        this.part = part;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_HOVER"));
        this.setEnabled(false);
    }

    void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    void setProperties(IField[] properties) {
        this.properties = properties;
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty() || this.clipboard == null) {
            return;
        }
        List list = selection.toList();
        IMarker[] markers = new IMarker[list.size()];
        list.toArray(markers);
        this.setClipboard(markers, this.createMarkerReport(markers));
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private void setClipboard(IMarker[] markers, String markerReport) {
        block5: {
            try {
                Transfer[] transferTypes;
                Object[] data;
                if (markerReport == null) {
                    data = new Object[]{markers};
                    transferTypes = new Transfer[]{MarkerTransfer.getInstance()};
                } else {
                    data = new Object[]{markers, markerReport};
                    transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
                }
                this.clipboard.setContents(data, transferTypes);
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.part.getSite().getShell(), (String)Messages.getString("CopyToClipboardProblemDialog.title"), (String)Messages.getString("CopyToClipboardProblemDialog.message"))) break block5;
                this.setClipboard(markers, markerReport);
            }
        }
    }

    String createMarkerReport(IMarker[] markers) {
        String report = "";
        String NEWLINE = System.getProperty("line.separator");
        if (this.properties == null) {
            return null;
        }
        int i = 0;
        while (i < this.properties.length) {
            report = String.valueOf(report) + this.properties[i].getDescription();
            report = i == this.properties.length - 1 ? String.valueOf(report) + NEWLINE : String.valueOf(report) + '\t';
            ++i;
        }
        i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            int j = 0;
            while (j < this.properties.length) {
                report = String.valueOf(report) + this.properties[j].getValue(marker);
                report = j == this.properties.length - 1 ? String.valueOf(report) + NEWLINE : String.valueOf(report) + '\t';
                ++j;
            }
            ++i;
        }
        return report;
    }
}

