/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.markers.internal.ActionAddGlobalTask;
import org.eclipse.ui.views.markers.internal.ActionDeleteCompleted;
import org.eclipse.ui.views.markers.internal.ActionMarkCompleted;
import org.eclipse.ui.views.markers.internal.ActionTaskProperties;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.DialogTaskFilter;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldDone;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldMessage;
import org.eclipse.ui.views.markers.internal.FieldPriority;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.TaskFilter;
import org.eclipse.ui.views.markers.internal.Util;

public class TaskView
extends MarkerView {
    private static final String COMPLETION = "completion";
    private static final ColumnLayoutData[] DEFAULT_COLUMN_LAYOUTS = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnPixelData(19, false), new ColumnWeightData(200), new ColumnWeightData(75), new ColumnWeightData(150), new ColumnWeightData(60)};
    private static final IField[] HIDDEN_FIELDS = new IField[]{new FieldCreationTime()};
    private static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.taskmarker"};
    private static final String[] TABLE_COLUMN_PROPERTIES = new String[]{"completion", "priority", "message", "", "", ""};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.task";
    private static final IField[] VISIBLE_FIELDS = new IField[]{new FieldDone(), new FieldPriority(), new FieldMessage(), new FieldResource(), new FieldFolder(), new FieldLineNumber()};
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object element, String property) {
            if (element instanceof ConcreteMarker) {
                IMarker marker = ((ConcreteMarker)element).getMarker();
                if (TaskView.COMPLETION.equals(property)) {
                    return new Boolean(marker.getAttribute("done", false));
                }
                if ("priority".equals(property)) {
                    return new Integer(2 - marker.getAttribute("priority", 1));
                }
                if ("message".equals(property)) {
                    return marker.getAttribute("message", "");
                }
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return Util.isEditable(((ConcreteMarker)element).getMarker());
        }

        public void modify(Object element, String property, Object value) {
            Item item;
            Object data;
            if (element instanceof Item && (data = (item = (Item)element).getData()) instanceof ConcreteMarker) {
                IMarker marker = ((ConcreteMarker)data).getMarker();
                try {
                    Object oldValue = this.getValue(data, property);
                    if (oldValue != null && !oldValue.equals(value)) {
                        if (TaskView.COMPLETION.equals(property)) {
                            marker.setAttribute("done", value);
                        } else if ("priority".equals(property)) {
                            marker.setAttribute("priority", 2 - (Integer)value);
                        } else if ("message".equals(property)) {
                            marker.setAttribute("message", value);
                        }
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)TaskView.this.getSite().getShell(), (String)Messages.getString("errorModifyingTask"), null, (IStatus)e.getStatus());
                }
            }
        }
    };
    private CellEditorActionHandler cellEditorActionHandler;
    private TaskFilter taskFilter;
    private ActionAddGlobalTask addGlobalTaskAction;
    private ActionDeleteCompleted deleteCompletedAction;
    private ActionMarkCompleted markCompletedAction;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TableViewer tableViewer = this.getViewer();
        CellEditor[] cellEditors = new CellEditor[tableViewer.getTable().getColumnCount()];
        cellEditors[0] = new CheckboxCellEditor((Composite)tableViewer.getTable());
        String[] priorities = new String[]{Messages.getString("priority.high"), Messages.getString("priority.normal"), Messages.getString("priority.low")};
        cellEditors[1] = new ComboBoxCellEditor((Composite)tableViewer.getTable(), priorities, 8);
        TextCellEditor descriptionCellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        cellEditors[2] = descriptionCellEditor;
        tableViewer.setCellEditors(cellEditors);
        tableViewer.setCellModifier(this.cellModifier);
        tableViewer.setColumnProperties(TABLE_COLUMN_PROPERTIES);
        this.cellEditorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.cellEditorActionHandler.addCellEditor((CellEditor)descriptionCellEditor);
        this.cellEditorActionHandler.setCopyAction((IAction)this.copyAction);
        this.cellEditorActionHandler.setPasteAction((IAction)this.pasteAction);
        this.cellEditorActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.cellEditorActionHandler.setSelectAllAction((IAction)this.selectAllAction);
    }

    public void dispose() {
        if (this.cellEditorActionHandler != null) {
            this.cellEditorActionHandler.dispose();
        }
        if (this.markCompletedAction != null) {
            this.markCompletedAction.dispose();
        }
        super.dispose();
    }

    public void init(IViewSite viewSite, IMemento memento) throws PartInitException {
        super.init(viewSite, memento);
        this.taskFilter = new TaskFilter();
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (this.taskFilter != null) {
            this.taskFilter.restoreState(dialogSettings);
        }
    }

    public void saveState(IMemento memento) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (this.taskFilter != null) {
            this.taskFilter.saveState(dialogSettings);
        }
        super.saveState(memento);
    }

    protected ColumnLayoutData[] getDefaultColumnLayouts() {
        return DEFAULT_COLUMN_LAYOUTS;
    }

    protected IDialogSettings getDialogSettings() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return settings;
    }

    protected void createActions() {
        super.createActions();
        ISelectionProvider selProvider = this.getSelectionProvider();
        this.addGlobalTaskAction = new ActionAddGlobalTask((IWorkbenchPart)this);
        this.deleteCompletedAction = new ActionDeleteCompleted(this, selProvider);
        this.markCompletedAction = new ActionMarkCompleted(selProvider);
        this.propertiesAction = new ActionTaskProperties((IWorkbenchPart)this, selProvider);
    }

    protected void createColumns(Table table) {
        super.createColumns(table);
        TableColumn[] columns = table.getColumns();
        if (columns != null && columns.length >= 1) {
            columns[0].setResizable(false);
            if (columns.length >= 2) {
                columns[1].setResizable(false);
            }
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addGlobalTaskAction);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    protected void fillContextMenuAdditions(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.markCompletedAction);
        manager.add((IAction)this.deleteCompletedAction);
    }

    protected DialogMarkerFilter getFiltersDialog() {
        return new DialogTaskFilter(this.getSite().getShell(), this.taskFilter);
    }

    protected IField[] getHiddenFields() {
        return HIDDEN_FIELDS;
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    protected Object getViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IField[] getVisibleFields() {
        return VISIBLE_FIELDS;
    }

    protected void initToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.addGlobalTaskAction);
        super.initToolBar(toolBarManager);
    }

    public void setSelection(IStructuredSelection structuredSelection, boolean reveal) {
        super.setSelection(structuredSelection, reveal);
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.taskmarker"};
    }

    protected MarkerFilter getFilter() {
        return this.taskFilter;
    }

    public void openFiltersDialog() {
        DialogTaskFilter dialog = new DialogTaskFilter(this.getSite().getShell(), this.taskFilter);
        if (dialog.open() == 0) {
            this.taskFilter = (TaskFilter)dialog.getFilter();
            this.taskFilter.saveState(this.getDialogSettings());
            this.refresh();
        }
    }

    protected void updateFilterSelection(IResource[] resources) {
        this.taskFilter.setFocusResource(resources);
        this.refresh();
    }
}

