/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.FrameListMessages;

public class UpAction
extends FrameAction {
    public UpAction(FrameList frameList) {
        super(frameList);
        this.setText(FrameListMessages.getString("Up.text"));
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_UP_HOVER"));
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_UP"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_UP_DISABLED"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.up_action_context");
        this.update();
    }

    Frame getParentFrame(int flags) {
        return this.getFrameList().getSource().getFrame(3, flags);
    }

    String getToolTipText(Frame parentFrame) {
        String text;
        if (parentFrame != null && (text = parentFrame.getToolTipText()) != null && text.length() > 0) {
            return FrameListMessages.format("Up.toolTipOneArg", new Object[]{text});
        }
        return FrameListMessages.getString("Up.toolTip");
    }

    public void run() {
        Frame parentFrame = this.getParentFrame(1);
        if (parentFrame != null) {
            this.getFrameList().gotoFrame(parentFrame);
        }
    }

    public void update() {
        super.update();
        Frame parentFrame = this.getParentFrame(0);
        this.setEnabled(parentFrame != null);
        this.setToolTipText(this.getToolTipText(parentFrame));
    }
}

