/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IResourceActionFilter;
import org.eclipse.ui.actions.SimpleWildcardTester;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.model.PropertyParser;
import org.eclipse.ui.model.WorkbenchAdapter;

public abstract class WorkbenchResource
extends WorkbenchAdapter
implements IResourceActionFilter {
    public static final String XML_LAST_MOD = "xmlLastMod";
    static /* synthetic */ Class class$0;

    protected abstract ImageDescriptor getBaseImage(IResource var1);

    public ImageDescriptor getImageDescriptor(Object o) {
        IResource resource = this.getResource(o);
        return resource == null ? null : this.getBaseImage(resource);
    }

    public String getLabel(Object o) {
        IResource resource = this.getResource(o);
        return resource == null ? null : resource.getName();
    }

    public Object getParent(Object o) {
        IResource resource = this.getResource(o);
        return resource == null ? null : resource.getParent();
    }

    protected IResource getResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (!(target instanceof IResource)) {
            return false;
        }
        IResource res = (IResource)target;
        if (name.equals("name")) {
            return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)res.getName());
        }
        if (name.equals("path")) {
            return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)res.getFullPath().toString());
        }
        if (name.equals("extension")) {
            return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)res.getFileExtension());
        }
        if (name.equals("readOnly")) {
            return res.isReadOnly() == value.equalsIgnoreCase("true");
        }
        if (name.equals("projectNature")) {
            try {
                IProject proj = res.getProject();
                return proj.isAccessible() && proj.hasNature(value);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (name.equals("persistentProperty")) {
            return this.testProperty(res, true, false, value);
        }
        if (name.equals("projectPersistentProperty")) {
            return this.testProperty(res, true, true, value);
        }
        if (name.equals("sessionProperty")) {
            return this.testProperty(res, false, false, value);
        }
        if (name.equals("projectSessionProperty")) {
            return this.testProperty(res, false, true, value);
        }
        if (name.equals("xmlFirstTag")) {
            return this.testXMLProperty(res, name, value);
        }
        if (name.equals("xmlDTDName")) {
            return this.testXMLProperty(res, name, value);
        }
        return false;
    }

    private boolean testProperty(IResource resource, boolean persistentFlag, boolean projectFlag, String value) {
        String expectedVal;
        String propertyName;
        int i = value.indexOf(61);
        if (i != -1) {
            propertyName = value.substring(0, i).trim();
            expectedVal = value.substring(i + 1).trim();
        } else {
            propertyName = value.trim();
            expectedVal = null;
        }
        try {
            IResource resToCheck;
            int dot = propertyName.lastIndexOf(46);
            QualifiedName key = dot != -1 ? new QualifiedName(propertyName.substring(0, dot), propertyName.substring(dot + 1)) : new QualifiedName(null, propertyName);
            Object object = resToCheck = projectFlag ? resource.getProject() : resource;
            if (resToCheck == null) {
                return false;
            }
            if (persistentFlag) {
                String actualVal = resToCheck.getPersistentProperty(key);
                if (actualVal == null) {
                    return false;
                }
                return expectedVal == null || expectedVal.equals(actualVal);
            }
            Object actualVal = resToCheck.getSessionProperty(key);
            if (actualVal == null) {
                return false;
            }
            return expectedVal == null || expectedVal.equals(actualVal.toString());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean testXMLProperty(IResource resource, String propertyName, String value) {
        String expectedVal = value.trim();
        try {
            QualifiedName key = new QualifiedName("org.eclipse.ui.ide", propertyName);
            IResource resToCheck = resource;
            if (resToCheck == null) {
                return false;
            }
            long modTime = resToCheck.getModificationStamp();
            QualifiedName modKey = new QualifiedName("org.eclipse.ui.ide", XML_LAST_MOD);
            String lastPropMod = resToCheck.getPersistentProperty(modKey);
            long realLastPropMod = 0L;
            if (lastPropMod != null) {
                try {
                    realLastPropMod = new Long(lastPropMod);
                }
                catch (NumberFormatException nfe) {
                    IDEWorkbenchPlugin.log("Problem converting last mod to long in testXMLProperty", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, "Problem converting last mod to long in testXMLProperty", (Throwable)nfe));
                }
            }
            String actualVal = null;
            if (modTime != -1L && realLastPropMod == modTime) {
                actualVal = resToCheck.getPersistentProperty(key);
            } else if (realLastPropMod > 0L) {
                QualifiedName qname1 = new QualifiedName("org.eclipse.ui.ide", "xmlDTDName");
                QualifiedName qname2 = new QualifiedName("org.eclipse.ui.ide", "xmlFirstTag");
                try {
                    resToCheck.setPersistentProperty(qname1, null);
                    resToCheck.setPersistentProperty(qname2, null);
                }
                catch (CoreException c) {
                    IDEWorkbenchPlugin.log("Problem clearing stale xml properties", c.getStatus());
                }
            }
            if (actualVal == null) {
                try {
                    new PropertyParser().parseResource(resToCheck);
                }
                catch (Exception e) {
                    IDEWorkbenchPlugin.log("Problem parsing for xml properties", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, "Problem parsing for xml properties", (Throwable)e));
                }
                actualVal = resToCheck.getPersistentProperty(key);
                if (actualVal == null) {
                    return false;
                }
            }
            return expectedVal == null || expectedVal.equals(actualVal);
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log("Problem testing xml property", e.getStatus());
            return false;
        }
    }
}

