/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.SiteManager;

public final class SystemSummaryDialog
extends Dialog {
    SystemSummaryDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(68720);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(IDEWorkbenchMessages.getString("SystemSummary.title"));
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.ui.ide.system_summary_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        Text text = new Text(outer, 527114);
        text.setBackground(parent.getDisplay().getSystemColor(25));
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels(300);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        text.setLayoutData((Object)gridData);
        text.setText(this.getSystemSummary());
        return outer;
    }

    private String getSystemSummary() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        this.appendTimestamp(writer);
        this.appendProperties(writer);
        this.appendFeatures(writer);
        this.appendRegistry(writer);
        this.appendUserPreferences(writer);
        this.appendUpdateManagerLog(writer);
        this.appendLog(writer);
        writer.close();
        return out.toString();
    }

    private void appendTimestamp(PrintWriter writer) {
        writer.println(IDEWorkbenchMessages.format("SystemSummary.timeStamp", new Object[]{new Date()}));
    }

    private void appendProperties(PrintWriter writer) {
        writer.println();
        writer.println(IDEWorkbenchMessages.getString("SystemSummary.systemProperties"));
        Properties properties = System.getProperties();
        TreeSet<Object> set = new TreeSet<Object>(new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareTo(s2);
            }
        });
        set.addAll(properties.keySet());
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            writer.print(key);
            writer.print('=');
            writer.println(properties.get(key));
        }
    }

    private void appendFeatures(PrintWriter writer) {
        writer.println();
        writer.println(IDEWorkbenchMessages.getString("SystemSummary.features"));
        IPlatformConfiguration platformConfiguration = BootLoader.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] featuresArray = platformConfiguration.getConfiguredFeatureEntries();
        Arrays.sort(featuresArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((IPlatformConfiguration.IFeatureEntry)o1).getFeatureIdentifier();
                String s2 = ((IPlatformConfiguration.IFeatureEntry)o2).getFeatureIdentifier();
                return s1.compareTo(s2);
            }
        });
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        int i = 0;
        while (i < featuresArray.length) {
            IPlatformConfiguration.IFeatureEntry info = featuresArray[i];
            String pluginID = info.getFeaturePluginIdentifier();
            if (pluginID != null) {
                IPluginDescriptor descriptor = pluginRegistry.getPluginDescriptor(pluginID);
                if (descriptor != null) {
                    pluginID = descriptor.getLabel();
                }
                if ("".equals(pluginID)) {
                    pluginID = IDEWorkbenchMessages.getString("SystemSummary.notSpecified");
                }
            } else {
                pluginID = IDEWorkbenchMessages.getString("SystemSummary.notSpecified");
            }
            Object[] args = new String[]{info.getFeatureIdentifier(), info.getFeatureVersion(), pluginID};
            writer.println(IDEWorkbenchMessages.format("SystemSummary.featureVersion", args));
            ++i;
        }
    }

    private void appendRegistry(PrintWriter writer) {
        writer.println();
        writer.println(IDEWorkbenchMessages.getString("SystemSummary.pluginRegistry"));
        IPluginDescriptor[] descriptors = Platform.getPluginRegistry().getPluginDescriptors();
        TreeSet<IPluginDescriptor> set = new TreeSet<IPluginDescriptor>(new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((IPluginDescriptor)o1).getUniqueIdentifier();
                String s2 = ((IPluginDescriptor)o2).getUniqueIdentifier();
                return s1.compareTo(s2);
            }
        });
        int i = 0;
        int length = descriptors.length;
        while (i < length) {
            set.add(descriptors[i]);
            ++i;
        }
        Iterator i2 = set.iterator();
        while (i2.hasNext()) {
            PluginDescriptor descriptor = (PluginDescriptor)i2.next();
            Object[] args = new String[]{descriptor.getUniqueIdentifier(), descriptor.getVersionIdentifier().toString(), descriptor.getLabel()};
            writer.println(IDEWorkbenchMessages.format("SystemSummary.descriptorIdVersion", args));
        }
    }

    private void appendUserPreferences(PrintWriter writer) {
        String tmpFile = ".tmpPrefFile";
        IPath path = Platform.getPluginStateLocation((Plugin)IDEWorkbenchPlugin.getDefault()).append(tmpFile);
        File file = path.toFile();
        file.delete();
        try {
            Preferences.exportPreferences((IPath)path);
        }
        catch (CoreException e) {
            writer.println("Error exporting user preferences " + e.toString());
        }
        writer.println();
        writer.println(IDEWorkbenchMessages.getString("SystemSummary.userPreferences"));
        BufferedReader reader = null;
        try {
            FileInputStream in = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)in, "8859_1"));
            char[] chars = new char[8192];
            int read = reader.read(chars);
            while (read > 0) {
                writer.write(chars, 0, read);
                read = reader.read(chars);
            }
            reader.close();
            reader = null;
        }
        catch (IOException e) {
            writer.println("Error reading user preference file " + e.toString());
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                writer.println("Error closing user preference file " + e.toString());
            }
        }
        file.delete();
    }

    private void appendUpdateManagerLog(PrintWriter writer) {
        ILocalSite site;
        writer.println();
        writer.println(IDEWorkbenchMessages.getString("SystemSummary.updateManagerLog"));
        try {
            site = SiteManager.getLocalSite();
        }
        catch (CoreException e) {
            e.printStackTrace(writer);
            return;
        }
        IInstallConfiguration[] configurations = site.getConfigurationHistory();
        int i = 0;
        while (i < configurations.length) {
            writer.println();
            if (i > 0) {
                writer.println("----------------------------------------------------");
            }
            writer.println(IDEWorkbenchMessages.format("SystemSummary.configuration", new Object[]{configurations[i].getLabel()}));
            writer.println(IDEWorkbenchMessages.format("SystemSummary.isCurrentConfiguration", new Object[]{new Boolean(configurations[i].isCurrent())}));
            IActivity[] activities = configurations[i].getActivities();
            int j = 0;
            while (j < activities.length) {
                writer.println();
                writer.println(IDEWorkbenchMessages.format("SystemSummary.date", new Object[]{activities[j].getDate()}));
                writer.println(IDEWorkbenchMessages.format("SystemSummary.target", new Object[]{activities[j].getLabel()}));
                writer.println(IDEWorkbenchMessages.format("SystemSummary.action", new Object[]{this.getActionLabel(activities[j])}));
                writer.println(IDEWorkbenchMessages.format("SystemSummary.status", new Object[]{this.getStatusLabel(activities[j])}));
                ++j;
            }
            ++i;
        }
    }

    private void appendLog(PrintWriter writer) {
        File log = new File(Platform.getLogFileLocation().toOSString());
        if (log.exists()) {
            writer.println();
            writer.println(IDEWorkbenchMessages.getString("SystemSummary.errorLog"));
            BufferedReader reader = null;
            try {
                FileInputStream in = new FileInputStream(log);
                reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                char[] chars = new char[8192];
                int read = reader.read(chars);
                while (read > 0) {
                    writer.write(chars, 0, read);
                    read = reader.read(chars);
                }
                reader.close();
                reader = null;
            }
            catch (IOException iOException) {
                writer.println("Error reading .log file");
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    writer.println("Error reading .log file");
                }
            }
        }
    }

    private String getActionLabel(IActivity activity) {
        int action = activity.getAction();
        switch (action) {
            case 6: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.enabled");
            }
            case 1: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.featureInstalled");
            }
            case 2: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.featureRemoved");
            }
            case 3: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.siteInstalled");
            }
            case 4: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.siteRemoved");
            }
            case 5: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.disabled");
            }
            case 7: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.revert");
            }
            case 8: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.reconcile");
            }
            case 9: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.preserved");
            }
        }
        return IDEWorkbenchMessages.getString("SystemSummary.activity.unknown");
    }

    private String getStatusLabel(IActivity activity) {
        switch (activity.getStatus()) {
            case 0: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.status.success");
            }
            case 1: {
                return IDEWorkbenchMessages.getString("SystemSummary.activity.status.failure");
            }
        }
        return IDEWorkbenchMessages.getString("SystemSummary.activity.status.unknown");
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.close();
        }
        super.buttonPressed(buttonId);
    }
}

