/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferencePage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class IDEWorkbenchPreferencePage
extends WorkbenchPreferencePage
implements IWorkbenchPreferencePage {
    private Button autoBuildButton;
    private Button autoSaveAllButton;
    private Button refreshButton;
    private Button showTasks;
    private Button exitPromptButton;
    private IntegerFieldEditor saveInterval;

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.ui.ide.workbench_preference_page_context");
        Composite composite = this.createComposite(parent);
        this.createAutoBuildPref(composite);
        this.createSaveAllBeforeBuildPref(composite);
        this.createRefreshWorkspaceOnStartupPref(composite);
        this.createExitPromptPref(composite);
        this.createShowTasksOnAutoBuildPref(composite);
        this.createStickyCyclePref(composite);
        WorkbenchPreferencePage.createSpace((Composite)composite);
        this.createSaveIntervalGroup(composite);
        WorkbenchPreferencePage.createSpace((Composite)composite);
        this.createOpenModeGroup(composite);
        return composite;
    }

    protected void createShowTasksOnAutoBuildPref(Composite composite) {
        this.showTasks = new Button(composite, 32);
        this.showTasks.setText(IDEWorkbenchMessages.getString("WorkbenchPreference.showTasks"));
        this.showTasks.setFont(composite.getFont());
        this.showTasks.setSelection(this.getIDEPreferenceStore().getBoolean("SHOW_TASKS_ON_BUILD"));
    }

    protected void createExitPromptPref(Composite composite) {
        this.exitPromptButton = new Button(composite, 32);
        this.exitPromptButton.setText(IDEWorkbenchMessages.getString("WorkbenchPreference.exitPromptButton"));
        this.exitPromptButton.setFont(composite.getFont());
        this.exitPromptButton.setSelection(this.getIDEPreferenceStore().getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW"));
    }

    protected void createRefreshWorkspaceOnStartupPref(Composite composite) {
        this.refreshButton = new Button(composite, 32);
        this.refreshButton.setText(IDEWorkbenchMessages.getString("WorkbenchPreference.refreshButton"));
        this.refreshButton.setFont(composite.getFont());
        this.refreshButton.setSelection(this.getIDEPreferenceStore().getBoolean("REFRESH_WORKSPACE_ON_STARTUP"));
    }

    protected void createSaveAllBeforeBuildPref(Composite composite) {
        this.autoSaveAllButton = new Button(composite, 32);
        this.autoSaveAllButton.setText(IDEWorkbenchMessages.getString("WorkbenchPreference.savePriorToBuilding"));
        this.autoSaveAllButton.setFont(composite.getFont());
        this.autoSaveAllButton.setSelection(this.getIDEPreferenceStore().getBoolean("SAVE_ALL_BEFORE_BUILD"));
    }

    private void createAutoBuildPref(Composite composite) {
        this.autoBuildButton = new Button(composite, 32);
        this.autoBuildButton.setText(IDEWorkbenchMessages.getString("WorkbenchPreference.autobuild"));
        this.autoBuildButton.setFont(composite.getFont());
        this.autoBuildButton.setSelection(ResourcesPlugin.getWorkspace().isAutoBuilding());
    }

    private void createSaveIntervalGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        groupComposite.setFont(composite.getFont());
        this.saveInterval = new IntegerFieldEditor("saveInterval", IDEWorkbenchMessages.getString("WorkbenchPreference.saveInterval"), groupComposite);
        this.saveInterval.setPreferenceStore(this.getIDEPreferenceStore());
        this.saveInterval.setPreferencePage((PreferencePage)this);
        this.saveInterval.setTextLimit(Integer.toString(9999).length());
        this.saveInterval.setErrorMessage(IDEWorkbenchMessages.format("WorkbenchPreference.saveIntervalError", new Object[]{new Integer(9999)}));
        this.saveInterval.setValidateStrategy(0);
        this.saveInterval.setValidRange(1, 9999);
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        long interval = description.getSnapshotInterval() / 60000L;
        this.saveInterval.setStringValue(Long.toString(interval));
        this.saveInterval.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    IDEWorkbenchPreferencePage.this.setValid(IDEWorkbenchPreferencePage.this.saveInterval.isValid());
                }
            }
        });
    }

    protected IPreferenceStore getIDEPreferenceStore() {
        return IDEWorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        boolean autoBuild = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("description.autobuilding");
        this.autoBuildButton.setSelection(autoBuild);
        IPreferenceStore store = this.getIDEPreferenceStore();
        this.autoSaveAllButton.setSelection(store.getDefaultBoolean("SAVE_ALL_BEFORE_BUILD"));
        this.refreshButton.setSelection(store.getDefaultBoolean("REFRESH_WORKSPACE_ON_STARTUP"));
        this.exitPromptButton.setSelection(store.getDefaultBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW"));
        this.showTasks.setSelection(store.getBoolean("SHOW_TASKS_ON_BUILD"));
        this.saveInterval.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        if (this.autoBuildButton.getSelection() != ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            try {
                description.setAutoBuilding(this.autoBuildButton.getSelection());
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error changing auto build workspace setting.", e.getStatus());
            }
        }
        IPreferenceStore store = this.getIDEPreferenceStore();
        store.setValue("SAVE_ALL_BEFORE_BUILD", this.autoSaveAllButton.getSelection());
        store.setValue("REFRESH_WORKSPACE_ON_STARTUP", this.refreshButton.getSelection());
        store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", this.exitPromptButton.getSelection());
        store.setValue("SHOW_TASKS_ON_BUILD", this.showTasks.getSelection());
        long oldSaveInterval = description.getSnapshotInterval() / 60000L;
        long newSaveInterval = new Long(this.saveInterval.getStringValue());
        if (oldSaveInterval != newSaveInterval) {
            try {
                description.setSnapshotInterval(newSaveInterval * 60000L);
                ResourcesPlugin.getWorkspace().setDescription(description);
                store.firePropertyChangeEvent("saveInterval", (Object)new Integer((int)oldSaveInterval), (Object)new Integer((int)newSaveInterval));
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error changing save interval preference", e.getStatus());
            }
        }
        return super.performOk();
    }
}

