/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.AboutPluginsDialog;
import org.eclipse.ui.internal.ide.dialogs.ProductInfoDialog;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;

public class AboutFeaturesDialog
extends ProductInfoDialog {
    private static final int TABLE_HEIGHT = 150;
    private static final int INFO_HEIGHT = 100;
    private static final int MORE_ID = 1025;
    private static final int PLUGINS_ID = 1026;
    private Table table;
    private Label imageLabel;
    private StyledText text;
    private Composite infoArea;
    private Map cachedImages = new HashMap();
    private String[] columnTitles = new String[]{IDEWorkbenchMessages.getString("AboutFeaturesDialog.provider"), IDEWorkbenchMessages.getString("AboutFeaturesDialog.featureName"), IDEWorkbenchMessages.getString("AboutFeaturesDialog.version"), IDEWorkbenchMessages.getString("AboutFeaturesDialog.featureId")};
    private AboutInfo[] featureInfos;
    private AboutInfo primaryInfo;
    private int lastColumnChosen = 0;
    private boolean reverseSort = false;
    private AboutInfo lastSelection = null;
    private Button moreButton;
    private Button pluginsButton;
    private static Map featuresMap;

    public AboutFeaturesDialog(Shell parentShell, AboutInfo primaryInfo, AboutInfo[] featureInfos) {
        super(parentShell);
        this.setShellStyle(68720);
        this.primaryInfo = primaryInfo;
        this.featureInfos = featureInfos;
        this.sortByProvider();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                TableItem[] items = this.table.getSelection();
                if (items.length > 0) {
                    IURLEntry entry;
                    AboutInfo info = (AboutInfo)items[0].getData();
                    IFeature feature = this.getFeatureFor(info);
                    if (feature != null && (entry = feature.getLicense()) != null) {
                        this.openLink(entry.getURL().toString());
                        return;
                    }
                    MessageDialog.openInformation((Shell)this.getShell(), (String)IDEWorkbenchMessages.getString("AboutFeaturesDialog.noInfoTitle"), (String)IDEWorkbenchMessages.getString("AboutFeaturesDialog.noInformation"));
                }
                return;
            }
            case 1026: {
                TableItem[] items = this.table.getSelection();
                if (items.length > 0) {
                    AboutInfo info = (AboutInfo)items[0].getData();
                    IFeature feature = this.getFeatureFor(info);
                    IPluginDescriptor[] descriptors = feature == null ? new IPluginDescriptor[]{} : this.getPluginsFor(feature);
                    AboutPluginsDialog d = new AboutPluginsDialog(this.getShell(), this.primaryInfo, descriptors, IDEWorkbenchMessages.getString("AboutFeaturesDialog.pluginInfoTitle"), IDEWorkbenchMessages.format("AboutFeaturesDialog.pluginInfoMessage", new Object[]{info.getFeatureLabel()}), "org.eclipse.ui.ide.about_features_plugins_dialog_context");
                    d.open();
                }
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = null;
        if (this.primaryInfo != null) {
            title = this.primaryInfo.getProductName();
        }
        if (title != null) {
            newShell.setText(IDEWorkbenchMessages.format("AboutFeaturesDialog.shellTitle", new Object[]{title}));
        }
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.ui.ide.about_features_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.moreButton = this.createButton(parent, 1025, IDEWorkbenchMessages.getString("AboutFeaturesDialog.moreInfo"), false);
        this.pluginsButton = this.createButton(parent, 1026, IDEWorkbenchMessages.getString("AboutFeaturesDialog.pluginsInfo"), false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        b.setFocus();
        TableItem[] items = this.table.getSelection();
        if (items.length > 0) {
            this.updateButtons((AboutInfo)items[0].getData());
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setHandCursor(new Cursor((Device)parent.getDisplay(), 21));
        this.setBusyCursor(new Cursor((Device)parent.getDisplay(), 1));
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AboutFeaturesDialog.this.getHandCursor() != null) {
                    AboutFeaturesDialog.this.getHandCursor().dispose();
                }
                if (AboutFeaturesDialog.this.getBusyCursor() != null) {
                    AboutFeaturesDialog.this.getBusyCursor().dispose();
                }
            }
        });
        Composite outer = (Composite)super.createDialogArea(parent);
        this.createTable(outer);
        this.createColumns();
        this.createInfoArea(outer);
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels(150);
        this.table.setLayoutData((Object)gridData);
        return outer;
    }

    protected void createInfoArea(Composite parent) {
        int infoAreaHeight;
        Font font = parent.getFont();
        this.infoArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.infoArea.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = infoAreaHeight = this.convertVerticalDLUsToPixels(100);
        this.infoArea.setLayoutData((Object)data);
        this.imageLabel = new Label(this.infoArea, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.heightHint = 32;
        data.widthHint = 32;
        this.imageLabel.setLayoutData((Object)data);
        this.imageLabel.setFont(font);
        this.text = new StyledText(this.infoArea, 10);
        this.text.setCaret(null);
        this.text.setFont(parent.getFont());
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = infoAreaHeight;
        this.text.setLayoutData((Object)data);
        this.text.setFont(font);
        this.text.setCursor(null);
        this.text.setBackground(this.infoArea.getBackground());
        this.addListeners(this.text);
        TableItem[] items = this.table.getSelection();
        if (items.length > 0) {
            this.updateInfoArea((AboutInfo)items[0].getData());
        }
    }

    protected void createTable(Composite parent) {
        this.table = new Table(parent, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(parent.getFont());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AboutInfo info = (AboutInfo)e.item.getData();
                AboutFeaturesDialog.this.updateInfoArea(info);
                AboutFeaturesDialog.this.updateButtons(info);
            }
        };
        this.table.addSelectionListener((SelectionListener)listener);
    }

    public boolean close() {
        Collection values = this.cachedImages.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        return super.close();
    }

    private Map getFeaturesMap() {
        if (featuresMap != null) {
            return featuresMap;
        }
        featuresMap = new HashMap();
        IPluginRegistry reg = Platform.getPluginRegistry();
        if (reg == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.getString("AboutFeaturesDialog.errorTitle"), (String)IDEWorkbenchMessages.getString("AboutFeaturesDialog.unableToObtainFeatureInfo"));
            return featuresMap;
        }
        final ILocalSite[] localSiteArray = new ILocalSite[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    localSiteArray[0] = SiteManager.getLocalSite();
                }
                catch (CoreException coreException) {
                    MessageDialog.openError((Shell)AboutFeaturesDialog.this.getShell(), (String)IDEWorkbenchMessages.getString("AboutFeaturesDialog.errorTitle"), (String)IDEWorkbenchMessages.getString("AboutFeaturesDialog.unableToObtainFeatureInfo"));
                }
            }
        });
        if (localSiteArray[0] == null) {
            return featuresMap;
        }
        IInstallConfiguration installConfiguration = localSiteArray[0].getCurrentConfiguration();
        IConfiguredSite[] configuredSites = installConfiguration.getConfiguredSites();
        int i = 0;
        while (i < configuredSites.length) {
            IFeatureReference[] featureReferences = configuredSites[i].getConfiguredFeatures();
            int j = 0;
            while (j < featureReferences.length) {
                IFeature feature;
                try {
                    feature = featureReferences[j].getFeature((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    break;
                }
                String key = feature.getVersionedIdentifier().toString();
                featuresMap.put(key, feature);
                ++j;
            }
            ++i;
        }
        return featuresMap;
    }

    private IFeature getFeatureFor(AboutInfo info) {
        Map map = this.getFeaturesMap();
        if (map == null) {
            return null;
        }
        String key = String.valueOf(info.getFeatureId()) + "_" + info.getVersionId();
        return (IFeature)map.get(key);
    }

    private IPluginDescriptor[] getPluginsFor(IFeature feature) {
        IPluginRegistry reg = Platform.getPluginRegistry();
        if (reg == null) {
            return new IPluginDescriptor[0];
        }
        IPluginEntry[] pluginEntries = feature.getPluginEntries();
        ArrayList<IPluginDescriptor> plugins = new ArrayList<IPluginDescriptor>();
        int k = 0;
        while (k < pluginEntries.length) {
            VersionedIdentifier id = pluginEntries[k].getVersionedIdentifier();
            IPluginDescriptor desc = reg.getPluginDescriptor(id.getIdentifier(), id.getVersion());
            if (desc != null) {
                plugins.add(desc);
            }
            ++k;
        }
        return plugins.toArray(new IPluginDescriptor[plugins.size()]);
    }

    private void updateButtons(AboutInfo info) {
        IFeature feature;
        if (info == null) {
            this.moreButton.setEnabled(false);
            this.pluginsButton.setEnabled(false);
            return;
        }
        boolean shouldEnable = true;
        if (featuresMap != null) {
            feature = this.getFeatureFor(info);
            shouldEnable = feature != null && feature.getLicense() != null;
        }
        this.moreButton.setEnabled(shouldEnable);
        shouldEnable = true;
        if (featuresMap != null) {
            feature = this.getFeatureFor(info);
            shouldEnable = feature != null;
        }
        this.pluginsButton.setEnabled(shouldEnable);
    }

    private void updateInfoArea(AboutInfo info) {
        if (info == null) {
            this.imageLabel.setImage(null);
            this.text.setText("");
            return;
        }
        ImageDescriptor desc = info.getFeatureImage();
        Image image = (Image)this.cachedImages.get(desc);
        if (image == null && desc != null) {
            image = desc.createImage();
            this.cachedImages.put(desc, image);
        }
        this.imageLabel.setImage(image);
        String aboutText = info.getAboutText();
        this.setItem(null);
        if (aboutText != null) {
            this.setItem(this.scan(aboutText));
        }
        if (this.getItem() == null) {
            this.text.setText(IDEWorkbenchMessages.getString("AboutFeaturesDialog.noInformation"));
        } else {
            this.text.setText(this.getItem().getText());
            this.text.setCursor(null);
            this.setLinkRanges(this.text, this.getItem().getLinkRanges());
        }
    }

    public void setInitialSelection(AboutInfo info) {
        this.lastSelection = info;
    }

    protected void createColumns() {
        int[] columnWidths = new int[]{this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(180), this.convertHorizontalDLUsToPixels(70), this.convertHorizontalDLUsToPixels(70)};
        int i = 0;
        while (i < this.columnTitles.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.setText(this.columnTitles[i]);
            final int columnIndex = i++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AboutFeaturesDialog.this.sort(columnIndex);
                }
            });
        }
        int initialSelectionIndex = 0;
        int i2 = 0;
        while (i2 < this.featureInfos.length) {
            if (this.featureInfos[i2] == this.lastSelection) {
                initialSelectionIndex = i2;
            }
            String provider = this.featureInfos[i2].getProviderName();
            String featureName = this.featureInfos[i2].getFeatureLabel();
            String versionId = this.featureInfos[i2].getVersionId();
            String featureId = this.featureInfos[i2].getFeatureId();
            if (provider == null) {
                provider = "";
            }
            if (featureName == null) {
                featureName = "";
            }
            if (versionId == null) {
                versionId = "";
            }
            if (featureId == null) {
                featureId = "";
            }
            String[] row = new String[]{provider, featureName, versionId, featureId};
            TableItem item = new TableItem(this.table, 0);
            item.setText(row);
            item.setData((Object)this.featureInfos[i2]);
            ++i2;
        }
        if (this.featureInfos.length > 0) {
            this.table.setSelection(initialSelectionIndex);
        }
    }

    private void sort(int column) {
        if (this.lastColumnChosen == column) {
            this.reverseSort = !this.reverseSort;
        } else {
            this.reverseSort = false;
            this.lastColumnChosen = column;
        }
        if (this.table.getItemCount() <= 1) {
            return;
        }
        int idx = this.table.getSelectionIndex();
        if (idx != -1) {
            this.lastSelection = this.featureInfos[idx];
        }
        switch (column) {
            case 0: {
                this.sortByProvider();
                break;
            }
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByVersion();
                break;
            }
            case 3: {
                this.sortByFeatureId();
            }
        }
        this.refreshTable(column);
    }

    private void refreshTable(int col) {
        TableItem[] items = this.table.getItems();
        int idx = -1;
        int i = 0;
        while (i < items.length) {
            String provider = this.featureInfos[i].getProviderName();
            String featureName = this.featureInfos[i].getFeatureLabel();
            String versionId = this.featureInfos[i].getVersionId();
            String featureId = this.featureInfos[i].getFeatureId();
            if (provider == null) {
                provider = "";
            }
            if (featureName == null) {
                featureName = "";
            }
            if (versionId == null) {
                versionId = "";
            }
            if (featureId == null) {
                featureId = "";
            }
            String[] row = new String[]{provider, featureName, versionId, featureId};
            items[i].setText(row);
            items[i].setData((Object)this.featureInfos[i]);
            ++i;
        }
        if (this.lastSelection != null) {
            int k = 0;
            while (k < this.featureInfos.length) {
                if (this.lastSelection == this.featureInfos[k]) {
                    idx = k;
                }
                ++k;
            }
            this.table.setSelection(idx);
            this.table.showSelection();
        }
        this.updateInfoArea(this.lastSelection);
    }

    private void sortByProvider() {
        if (this.reverseSort) {
            List<AboutInfo> infoList = Arrays.asList(this.featureInfos);
            Collections.reverse(infoList);
            int i = 0;
            while (i < this.featureInfos.length) {
                this.featureInfos[i] = infoList.get(i);
                ++i;
            }
        } else {
            Arrays.sort(this.featureInfos, new Comparator(){
                Collator coll = Collator.getInstance(Locale.getDefault());

                public int compare(Object a, Object b) {
                    AboutInfo i1 = (AboutInfo)a;
                    String provider1 = i1.getProviderName();
                    String name1 = i1.getFeatureLabel();
                    if (provider1 == null) {
                        provider1 = "";
                    }
                    if (name1 == null) {
                        name1 = "";
                    }
                    AboutInfo i2 = (AboutInfo)b;
                    String provider2 = i2.getProviderName();
                    String name2 = i2.getFeatureLabel();
                    if (provider2 == null) {
                        provider2 = "";
                    }
                    if (name2 == null) {
                        name2 = "";
                    }
                    if (provider1.equals(provider2)) {
                        return this.coll.compare(name1, name2);
                    }
                    return this.coll.compare(provider1, provider2);
                }
            });
        }
    }

    private void sortByName() {
        if (this.reverseSort) {
            List<AboutInfo> infoList = Arrays.asList(this.featureInfos);
            Collections.reverse(infoList);
            int i = 0;
            while (i < this.featureInfos.length) {
                this.featureInfos[i] = infoList.get(i);
                ++i;
            }
        } else {
            Arrays.sort(this.featureInfos, new Comparator(){
                Collator coll = Collator.getInstance(Locale.getDefault());

                public int compare(Object a, Object b) {
                    AboutInfo i1 = (AboutInfo)a;
                    String name1 = i1.getFeatureLabel();
                    AboutInfo i2 = (AboutInfo)b;
                    String name2 = i2.getFeatureLabel();
                    if (name1 == null) {
                        name1 = "";
                    }
                    if (name2 == null) {
                        name2 = "";
                    }
                    return this.coll.compare(name1, name2);
                }
            });
        }
    }

    private void sortByVersion() {
        if (this.reverseSort) {
            List<AboutInfo> infoList = Arrays.asList(this.featureInfos);
            Collections.reverse(infoList);
            int i = 0;
            while (i < this.featureInfos.length) {
                this.featureInfos[i] = infoList.get(i);
                ++i;
            }
        } else {
            Arrays.sort(this.featureInfos, new Comparator(){
                Collator coll = Collator.getInstance(Locale.getDefault());

                public int compare(Object a, Object b) {
                    AboutInfo i1 = (AboutInfo)a;
                    String version1 = i1.getVersionId();
                    String name1 = i1.getFeatureLabel();
                    if (version1 == null) {
                        version1 = "";
                    }
                    if (name1 == null) {
                        name1 = "";
                    }
                    AboutInfo i2 = (AboutInfo)b;
                    String version2 = i2.getVersionId();
                    String name2 = i2.getFeatureLabel();
                    if (version2 == null) {
                        version2 = "";
                    }
                    if (name2 == null) {
                        name2 = "";
                    }
                    if (version1.equals(version2)) {
                        return this.coll.compare(name1, name2);
                    }
                    return this.coll.compare(version1, version2);
                }
            });
        }
    }

    private void sortByFeatureId() {
        if (this.reverseSort) {
            List<AboutInfo> infoList = Arrays.asList(this.featureInfos);
            Collections.reverse(infoList);
            int i = 0;
            while (i < this.featureInfos.length) {
                this.featureInfos[i] = infoList.get(i);
                ++i;
            }
        } else {
            Arrays.sort(this.featureInfos, new Comparator(){
                Collator coll = Collator.getInstance(Locale.getDefault());

                public int compare(Object a, Object b) {
                    AboutInfo i1 = (AboutInfo)a;
                    String featureId1 = i1.getFeatureId();
                    String name1 = i1.getFeatureLabel();
                    if (featureId1 == null) {
                        featureId1 = "";
                    }
                    if (name1 == null) {
                        name1 = "";
                    }
                    AboutInfo i2 = (AboutInfo)b;
                    String featureId2 = i2.getFeatureId();
                    String name2 = i2.getFeatureLabel();
                    if (featureId2 == null) {
                        featureId2 = "";
                    }
                    if (name2 == null) {
                        name2 = "";
                    }
                    if (featureId1.equals(featureId2)) {
                        return this.coll.compare(name1, name2);
                    }
                    return this.coll.compare(featureId1, featureId2);
                }
            });
        }
    }
}

