/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.AboutFeaturesDialog;
import org.eclipse.ui.internal.ide.dialogs.AboutPluginsDialog;
import org.eclipse.ui.internal.ide.dialogs.ProductInfoDialog;
import org.eclipse.ui.internal.ide.dialogs.SystemSummaryDialog;

public class AboutDialog
extends ProductInfoDialog {
    private static final int MAX_IMAGE_WIDTH_FOR_TEXT = 250;
    private static final int FEATURES_ID = 1025;
    private static final int PLUGINS_ID = 1026;
    private static final int INFO_ID = 1027;
    AboutInfo primaryInfo;
    AboutInfo[] featureInfos;
    private Image image;
    private ArrayList images = new ArrayList();
    private StyledText text;

    public AboutDialog(IWorkbenchWindow window, AboutInfo primaryInfo, AboutInfo[] featureInfos) {
        super(window.getShell());
        this.primaryInfo = primaryInfo;
        this.featureInfos = featureInfos;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                new AboutFeaturesDialog(this.getShell(), this.primaryInfo, this.featureInfos).open();
                return;
            }
            case 1026: {
                new AboutPluginsDialog(this.getShell(), this.primaryInfo).open();
                return;
            }
            case 1027: {
                new SystemSummaryDialog(this.getShell()).open();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        if (this.image != null) {
            this.image.dispose();
        }
        int i = 0;
        while (i < this.images.size()) {
            ((Image)this.images.get(i)).dispose();
            ++i;
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String name = null;
        if (this.primaryInfo != null) {
            name = this.primaryInfo.getProductName();
        }
        if (name != null) {
            newShell.setText(IDEWorkbenchMessages.format("AboutDialog.shellTitle", new Object[]{name}));
        }
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.ui.ide.about_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1025, IDEWorkbenchMessages.getString("AboutDialog.featureInfo"), false);
        this.createButton(parent, 1026, IDEWorkbenchMessages.getString("AboutDialog.pluginInfo"), false);
        this.createButton(parent, 1027, IDEWorkbenchMessages.getString("AboutDialog.systemInfo"), false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        b.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        this.setHandCursor(new Cursor((Device)parent.getDisplay(), 21));
        this.setBusyCursor(new Cursor((Device)parent.getDisplay(), 1));
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AboutDialog.this.getHandCursor() != null) {
                    AboutDialog.this.getHandCursor().dispose();
                }
                if (AboutDialog.this.getBusyCursor() != null) {
                    AboutDialog.this.getBusyCursor().dispose();
                }
            }
        });
        ImageDescriptor imageDescriptor = null;
        if (this.primaryInfo != null) {
            imageDescriptor = this.primaryInfo.getAboutImage();
        }
        if (imageDescriptor != null) {
            this.image = imageDescriptor.createImage();
        }
        if (this.image == null || this.image.getBounds().width <= 250) {
            String aboutText = null;
            if (this.primaryInfo != null) {
                aboutText = this.primaryInfo.getAboutText();
            }
            if (aboutText != null) {
                this.setItem(this.scan(aboutText));
            }
        }
        Composite outer = (Composite)super.createDialogArea(parent);
        outer.setSize(outer.computeSize(-1, -1));
        GridLayout layout = new GridLayout();
        outer.setLayout((Layout)layout);
        outer.setLayoutData((Object)new GridData(1808));
        Composite topContainer = new Composite(outer, 0);
        layout = new GridLayout();
        layout.numColumns = this.image == null || this.getItem() == null ? 1 : 2;
        layout.marginWidth = 0;
        topContainer.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        topContainer.setLayoutData((Object)data);
        if (this.image != null) {
            Label imageLabel = new Label(topContainer, 0);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = false;
            imageLabel.setLayoutData((Object)data);
            imageLabel.setImage(this.image);
        }
        if (this.getItem() != null) {
            this.text = new StyledText(topContainer, 10);
            this.text.setCaret(null);
            this.text.setFont(parent.getFont());
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = true;
            this.text.setText(this.getItem().getText());
            this.text.setLayoutData((Object)data);
            this.text.setCursor(null);
            this.text.setBackground(topContainer.getBackground());
            this.setLinkRanges(this.text, this.getItem().getLinkRanges());
            this.addListeners(this.text);
        }
        Label bar = new Label(outer, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        Composite featureContainer = new Composite(outer, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        featureContainer.setLayout((Layout)rowLayout);
        data = new GridData();
        data.horizontalAlignment = 4;
        featureContainer.setLayoutData((Object)data);
        AboutInfo[] infoArray = this.getFeaturesWithImages();
        int i = 0;
        while (i < infoArray.length) {
            ImageDescriptor desc = infoArray[i].getFeatureImage();
            Image featureImage = null;
            if (desc != null) {
                Button button = new Button(featureContainer, 0x800008);
                button.setData((Object)infoArray[i]);
                featureImage = desc.createImage();
                this.images.add(featureImage);
                button.setImage(featureImage);
                String name = infoArray[i].getProviderName();
                if (name == null) {
                    name = "";
                }
                button.setToolTipText(name);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        AboutFeaturesDialog d = new AboutFeaturesDialog(AboutDialog.this.getShell(), AboutDialog.this.primaryInfo, AboutDialog.this.featureInfos);
                        d.setInitialSelection((AboutInfo)event.widget.getData());
                        d.open();
                    }
                });
            }
            ++i;
        }
        bar = new Label(outer, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        return outer;
    }

    private AboutInfo[] getFeaturesWithImages() {
        ArrayList<AboutInfo> infoList = new ArrayList<AboutInfo>(this.featureInfos.length);
        int i = 0;
        while (i < this.featureInfos.length) {
            if (this.featureInfos[i].getProviderName() != null && this.featureInfos[i].getFeatureImageName() != null) {
                infoList.add(this.featureInfos[i]);
            }
            ++i;
        }
        ArrayList<AboutInfo> keepers = new ArrayList<AboutInfo>(this.featureInfos.length);
        if (this.primaryInfo != null) {
            keepers.add(this.primaryInfo);
        }
        long[] featureImageCRCs = new long[infoList.size()];
        int i2 = 0;
        while (i2 < infoList.size()) {
            AboutInfo info = (AboutInfo)infoList.get(i2);
            featureImageCRCs[i2] = info.getFeatureImageCRC();
            ++i2;
        }
        i2 = 0;
        while (i2 < infoList.size()) {
            AboutInfo outer = (AboutInfo)infoList.get(i2);
            boolean found = false;
            int j = 0;
            while (j < keepers.size()) {
                AboutInfo k = (AboutInfo)keepers.get(j);
                if (k.getProviderName().equals(outer.getProviderName()) && featureImageCRCs[j] == featureImageCRCs[i2]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                keepers.add(outer);
            }
            ++i2;
        }
        if (this.primaryInfo != null) {
            keepers.remove(this.primaryInfo);
        }
        return keepers.toArray(new AboutInfo[keepers.size()]);
    }
}

