/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.AboutDialog;

public class AboutAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public AboutAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        AboutInfo primaryInfo = IDEWorkbenchPlugin.getDefault().getPrimaryInfo();
        String productName = null;
        if (primaryInfo != null) {
            productName = primaryInfo.getProductName();
        }
        if (productName == null) {
            productName = "";
        }
        this.setText(IDEWorkbenchMessages.format("AboutAction.text", new Object[]{productName}));
        this.setToolTipText(IDEWorkbenchMessages.format("AboutAction.toolTip", new Object[]{productName}));
        this.setId("about");
        this.setActionDefinitionId("org.eclipse.ui.help.aboutAction");
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.about_action_context");
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        AboutInfo primaryInfo = IDEWorkbenchPlugin.getDefault().getPrimaryInfo();
        AboutInfo[] featureInfos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        new AboutDialog(this.workbenchWindow, primaryInfo, featureInfos).open();
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }
}

