/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.EditorsDropDownAction;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.StatusLineContributionItem;

public final class WorkbenchActionBuilder {
    private IWorkbenchWindow window;
    private IActionBarConfigurer actionBarConfigurer;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction closeAllSavedAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction hideShowEditorAction;
    private ActionFactory.IWorkbenchAction savePerspectiveAction;
    private ActionFactory.IWorkbenchAction resetPerspectiveAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;
    private ActionFactory.IWorkbenchAction closePerspAction;
    private ActionFactory.IWorkbenchAction lockToolBarAction;
    private ActionFactory.IWorkbenchAction closeAllPerspsAction;
    private ActionFactory.IWorkbenchAction showViewMenuAction;
    private ActionFactory.IWorkbenchAction showPartPaneMenuAction;
    private ActionFactory.IWorkbenchAction nextPartAction;
    private ActionFactory.IWorkbenchAction prevPartAction;
    private ActionFactory.IWorkbenchAction nextEditorAction;
    private ActionFactory.IWorkbenchAction prevEditorAction;
    private ActionFactory.IWorkbenchAction nextPerspectiveAction;
    private ActionFactory.IWorkbenchAction prevPerspectiveAction;
    private ActionFactory.IWorkbenchAction activateEditorAction;
    private ActionFactory.IWorkbenchAction maximizePartAction;
    private ActionFactory.IWorkbenchAction workbenchEditorsAction;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction findAction;
    private ActionFactory.IWorkbenchAction printAction;
    private ActionFactory.IWorkbenchAction revertAction;
    private ActionFactory.IWorkbenchAction refreshAction;
    private ActionFactory.IWorkbenchAction propertiesAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction moveAction;
    private ActionFactory.IWorkbenchAction renameAction;
    private ActionFactory.IWorkbenchAction goIntoAction;
    private ActionFactory.IWorkbenchAction backAction;
    private ActionFactory.IWorkbenchAction forwardAction;
    private ActionFactory.IWorkbenchAction upAction;
    private ActionFactory.IWorkbenchAction nextAction;
    private ActionFactory.IWorkbenchAction previousAction;
    private ActionFactory.IWorkbenchAction categoryAction;
    private EditorsDropDownAction editorsDropDownAction;
    private ActionFactory.IWorkbenchAction projectPropertyDialogAction;
    private ActionFactory.IWorkbenchAction newWizardAction;
    private ActionFactory.IWorkbenchAction newWizardDropDownAction;
    private ActionFactory.IWorkbenchAction importResourcesAction;
    private ActionFactory.IWorkbenchAction exportResourcesAction;
    private ActionFactory.IWorkbenchAction rebuildAllAction;
    private ActionFactory.IWorkbenchAction buildAllAction;
    private ActionFactory.IWorkbenchAction quickStartAction;
    private ActionFactory.IWorkbenchAction tipsAndTricksAction;
    private ActionFactory.IWorkbenchAction addBookmarkAction;
    private ActionFactory.IWorkbenchAction addTaskAction;
    private ActionFactory.IWorkbenchAction buildProjectAction;
    private ActionFactory.IWorkbenchAction rebuildProjectAction;
    private ActionFactory.IWorkbenchAction openProjectAction;
    private ActionFactory.IWorkbenchAction closeProjectAction;
    private NewWizardMenu newWizardMenu;
    private StatusLineContributionItem statusLineItem;
    private Preferences.IPropertyChangeListener prefListener;
    static /* synthetic */ Class class$0;

    public WorkbenchActionBuilder(IWorkbenchWindow window) {
        this.window = window;
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    private void hookListeners() {
        this.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                WorkbenchActionBuilder.this.enableActions(page.getPerspective() != null);
            }

            public void pageClosed(IWorkbenchPage page) {
                IWorkbenchPage pg = WorkbenchActionBuilder.this.getWindow().getActivePage();
                WorkbenchActionBuilder.this.enableActions(pg != null && pg.getPerspective() != null);
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        this.getWindow().addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                WorkbenchActionBuilder.this.enableActions(true);
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        });
        this.prefListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if (event.getProperty().equals("description.autobuilding")) {
                    boolean autoBuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
                    if (WorkbenchActionBuilder.this.window.getShell() != null && !WorkbenchActionBuilder.this.window.getShell().isDisposed()) {
                        WorkbenchActionBuilder.this.window.getShell().getDisplay().syncExec(new Runnable(this, autoBuild){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ boolean val$autoBuild;
                            {
                                this.this$1 = var1_1;
                                this.val$autoBuild = bl;
                            }

                            public void run() {
                                if (this.val$autoBuild) {
                                    WorkbenchActionBuilder.access$3(3.access$0(this.this$1));
                                } else {
                                    WorkbenchActionBuilder.access$4(3.access$0(this.this$1));
                                }
                            }
                        });
                    }
                }
            }

            static /* synthetic */ WorkbenchActionBuilder access$0(3 var0) {
                return var0.WorkbenchActionBuilder.this;
            }
        };
        ResourcesPlugin.getPlugin().getPluginPreferences().addPropertyChangeListener(this.prefListener);
    }

    private void enableActions(boolean value) {
        this.hideShowEditorAction.setEnabled(value);
        this.savePerspectiveAction.setEnabled(value);
        this.lockToolBarAction.setEnabled(value);
        this.resetPerspectiveAction.setEnabled(value);
        this.editActionSetAction.setEnabled(value);
        this.closePerspAction.setEnabled(value);
        this.closeAllPerspsAction.setEnabled(value);
        this.newWizardMenu.setEnabled(value);
        this.newWizardDropDownAction.setEnabled(value);
        this.importResourcesAction.setEnabled(value);
        this.exportResourcesAction.setEnabled(value);
    }

    public void makeAndPopulateActions(IWorkbenchConfigurer windowConfigurer, IActionBarConfigurer actionBarConfigurer) {
        this.makeActions(windowConfigurer, actionBarConfigurer);
        this.populateMenuBar(actionBarConfigurer);
        this.populateCoolBar(actionBarConfigurer);
        boolean autoBuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
        if (!autoBuild) {
            this.addManualIncrementalBuildAction();
        }
        this.populateStatusLine(actionBarConfigurer);
        this.hookListeners();
    }

    public void populateCoolBar(IActionBarConfigurer configurer) {
        ICoolBarManager cbManager = configurer.getCoolBarManager();
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.add((IContributionItem)new ActionContributionItem((IAction)this.lockToolBarAction));
        popUpMenu.add((IContributionItem)new ActionContributionItem((IAction)this.editActionSetAction));
        cbManager.setContextMenuManager((IMenuManager)popUpMenu);
        cbManager.add((IContributionItem)new GroupMarker("group.file"));
        ToolBarManager fileToolBar = new ToolBarManager(cbManager.getStyle());
        fileToolBar.add((IContributionItem)new Separator("new.group"));
        fileToolBar.add((IAction)this.newWizardDropDownAction);
        fileToolBar.add((IContributionItem)new GroupMarker("new.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("save.group"));
        fileToolBar.add((IAction)this.saveAction);
        fileToolBar.add((IContributionItem)new GroupMarker("save.ext"));
        fileToolBar.add((IAction)this.printAction);
        fileToolBar.add((IContributionItem)new GroupMarker("print.ext"));
        fileToolBar.add((IContributionItem)new Separator("build.group"));
        fileToolBar.add((IContributionItem)new GroupMarker("build.ext"));
        fileToolBar.add((IContributionItem)new Separator("additions"));
        cbManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)fileToolBar, "org.eclipse.ui.workbench.file"));
        cbManager.add((IContributionItem)new GroupMarker("additions"));
        cbManager.add((IContributionItem)new GroupMarker("group.nav"));
        ToolBarManager navToolBar = new ToolBarManager(cbManager.getStyle());
        navToolBar.add((IContributionItem)new Separator("history.group"));
        navToolBar.add((IContributionItem)new GroupMarker("group.application"));
        navToolBar.add((IAction)this.backwardHistoryAction);
        navToolBar.add((IAction)this.forwardHistoryAction);
        navToolBar.add((IContributionItem)new Separator("pin.group"));
        navToolBar.add(ContributionItemFactory.PIN_EDITOR.create(this.getWindow()));
        cbManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)navToolBar, "org.eclipse.ui.workbench.navigate"));
        cbManager.add((IContributionItem)new GroupMarker("group.editor"));
    }

    public void populateMenuBar(IActionBarConfigurer configurer) {
        IMenuManager menubar = configurer.getMenuManager();
        menubar.add((IContributionItem)this.createFileMenu());
        menubar.add((IContributionItem)this.createEditMenu());
        menubar.add((IContributionItem)this.createNavigateMenu());
        menubar.add((IContributionItem)this.createProjectMenu());
        menubar.add((IContributionItem)new GroupMarker("additions"));
        menubar.add((IContributionItem)this.createWindowMenu());
        menubar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.file"), "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        this.newWizardMenu = new NewWizardMenu(this.getWindow());
        MenuManager newMenu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.new"));
        newMenu.add((IContributionItem)this.newWizardMenu);
        menu.add((IContributionItem)newMenu);
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.closeAction);
        menu.add((IAction)this.closeAllAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.saveAction);
        menu.add((IAction)this.saveAsAction);
        menu.add((IAction)this.saveAllAction);
        menu.add((IAction)this.revertAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.moveAction);
        menu.add((IAction)this.renameAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.refreshAction);
        menu.add((IContributionItem)new GroupMarker("save.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.printAction);
        menu.add((IContributionItem)new GroupMarker("print.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.importResourcesAction);
        menu.add((IAction)this.exportResourcesAction);
        menu.add((IContributionItem)new GroupMarker("import.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.propertiesAction);
        menu.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getWindow()));
        menu.add((IContributionItem)new GroupMarker("mru"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.quitAction);
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.edit"), "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.cutAction);
        menu.add((IAction)this.copyAction);
        menu.add((IAction)this.pasteAction);
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.deleteAction);
        menu.add((IAction)this.selectAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.findAction);
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.addBookmarkAction);
        menu.add((IAction)this.addTaskAction);
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }

    private MenuManager createNavigateMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.navigate"), "navigate");
        menu.add((IContributionItem)new GroupMarker("navStart"));
        menu.add((IAction)this.goIntoAction);
        MenuManager goToSubMenu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.goTo"), "goTo");
        menu.add((IContributionItem)goToSubMenu);
        goToSubMenu.add((IAction)this.backAction);
        goToSubMenu.add((IAction)this.forwardAction);
        goToSubMenu.add((IAction)this.upAction);
        goToSubMenu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("open.ext"));
        int i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("open.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator("show.ext"));
        MenuManager showInSubMenu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.showIn"));
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getWindow()));
        menu.add((IContributionItem)showInSubMenu);
        i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("show.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.nextAction);
        menu.add((IAction)this.previousAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("navEnd"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.backwardHistoryAction);
        menu.add((IAction)this.forwardHistoryAction);
        return menu;
    }

    private MenuManager createProjectMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.project"), "project");
        menu.add((IContributionItem)new Separator("projStart"));
        menu.add((IAction)this.openProjectAction);
        menu.add((IAction)this.closeProjectAction);
        menu.add((IContributionItem)new GroupMarker("open.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.rebuildProjectAction);
        menu.add((IAction)this.rebuildAllAction);
        menu.add((IContributionItem)new GroupMarker("build.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("projEnd"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.projectPropertyDialogAction);
        return menu;
    }

    private MenuManager createWindowMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.window"), "window");
        ActionFactory.IWorkbenchAction action = ActionFactory.OPEN_NEW_WINDOW.create(this.getWindow());
        action.setText(IDEWorkbenchMessages.getString("Workbench.openNewWindow"));
        menu.add((IAction)action);
        menu.add((IContributionItem)new Separator());
        this.addPerspectiveActions(menu);
        menu.add((IContributionItem)new Separator());
        this.addKeyboardShortcuts(menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.workbenchEditorsAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additionsend"));
        if (this.categoryAction != null) {
            menu.add((IAction)this.categoryAction);
        }
        menu.add((IAction)this.openPreferencesAction);
        menu.add(ContributionItemFactory.OPEN_WINDOWS.create(this.getWindow()));
        return menu;
    }

    private void addPerspectiveActions(MenuManager menu) {
        String openText = IDEWorkbenchMessages.getString("Workbench.openPerspective");
        MenuManager changePerspMenuMgr = new MenuManager(openText);
        IContributionItem changePerspMenuItem = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.getWindow());
        changePerspMenuMgr.add(changePerspMenuItem);
        menu.add((IContributionItem)changePerspMenuMgr);
        MenuManager showViewMenuMgr = new MenuManager(IDEWorkbenchMessages.getString("Workbench.showView"));
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        showViewMenuMgr.add(showViewMenu);
        menu.add((IContributionItem)showViewMenuMgr);
        menu.add((IAction)this.hideShowEditorAction);
        menu.add((IAction)this.lockToolBarAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editActionSetAction);
        menu.add((IAction)this.savePerspectiveAction);
        menu.add((IAction)this.resetPerspectiveAction);
        menu.add((IAction)this.closePerspAction);
        menu.add((IAction)this.closeAllPerspsAction);
    }

    private void addKeyboardShortcuts(MenuManager menu) {
        MenuManager subMenu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.shortcuts"));
        menu.add((IContributionItem)subMenu);
        subMenu.add((IAction)this.showPartPaneMenuAction);
        subMenu.add((IAction)this.showViewMenuAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.maximizePartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.activateEditorAction);
        if (this.editorsDropDownAction != null) {
            subMenu.add((IAction)this.editorsDropDownAction);
        }
        subMenu.add((IAction)this.nextEditorAction);
        subMenu.add((IAction)this.prevEditorAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPartAction);
        subMenu.add((IAction)this.prevPartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPerspectiveAction);
        subMenu.add((IAction)this.prevPerspectiveAction);
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.getString("Workbench.help"), "help");
        if (this.quickStartAction != null) {
            menu.add((IAction)this.quickStartAction);
        }
        if (this.tipsAndTricksAction != null) {
            menu.add((IAction)this.tipsAndTricksAction);
        }
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.aboutAction);
        return menu;
    }

    public void dispose() {
        this.actionBarConfigurer.getStatusLineManager().remove((IContributionItem)this.statusLineItem);
        if (this.prefListener != null) {
            ResourcesPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this.prefListener);
        }
        this.closeAction.dispose();
        this.closeAllAction.dispose();
        this.closeAllSavedAction.dispose();
        this.saveAction.dispose();
        this.saveAllAction.dispose();
        this.aboutAction.dispose();
        this.openPreferencesAction.dispose();
        this.saveAsAction.dispose();
        this.hideShowEditorAction.dispose();
        this.savePerspectiveAction.dispose();
        this.resetPerspectiveAction.dispose();
        this.editActionSetAction.dispose();
        this.closePerspAction.dispose();
        this.lockToolBarAction.dispose();
        this.closeAllPerspsAction.dispose();
        this.showViewMenuAction.dispose();
        this.showPartPaneMenuAction.dispose();
        this.nextPartAction.dispose();
        this.prevPartAction.dispose();
        this.nextEditorAction.dispose();
        this.prevEditorAction.dispose();
        this.nextPerspectiveAction.dispose();
        this.prevPerspectiveAction.dispose();
        this.activateEditorAction.dispose();
        this.maximizePartAction.dispose();
        this.workbenchEditorsAction.dispose();
        this.backwardHistoryAction.dispose();
        this.forwardHistoryAction.dispose();
        this.undoAction.dispose();
        this.redoAction.dispose();
        this.cutAction.dispose();
        this.copyAction.dispose();
        this.pasteAction.dispose();
        this.deleteAction.dispose();
        this.selectAllAction.dispose();
        this.findAction.dispose();
        this.printAction.dispose();
        this.revertAction.dispose();
        this.refreshAction.dispose();
        this.propertiesAction.dispose();
        this.quitAction.dispose();
        this.moveAction.dispose();
        this.renameAction.dispose();
        this.goIntoAction.dispose();
        this.backAction.dispose();
        this.forwardAction.dispose();
        this.upAction.dispose();
        this.nextAction.dispose();
        this.previousAction.dispose();
        if (this.categoryAction != null) {
            this.categoryAction.dispose();
        }
        this.projectPropertyDialogAction.dispose();
        this.newWizardAction.dispose();
        this.newWizardDropDownAction.dispose();
        this.importResourcesAction.dispose();
        this.exportResourcesAction.dispose();
        this.rebuildAllAction.dispose();
        this.buildAllAction.dispose();
        if (this.quickStartAction != null) {
            this.quickStartAction.dispose();
        }
        if (this.tipsAndTricksAction != null) {
            this.tipsAndTricksAction.dispose();
        }
        this.addBookmarkAction.dispose();
        this.addTaskAction.dispose();
        this.buildProjectAction.dispose();
        this.rebuildProjectAction.dispose();
        this.openProjectAction.dispose();
        this.closeProjectAction.dispose();
    }

    void updateModeLine(String text) {
        this.statusLineItem.setText(text);
    }

    public boolean isContainerMenu(String menuId) {
        if (menuId.equals("file")) {
            return true;
        }
        if (menuId.equals("view")) {
            return true;
        }
        if (menuId.equals("workbench")) {
            return true;
        }
        return menuId.equals("window");
    }

    public boolean isWorkbenchCoolItemId(String id) {
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(id)) {
            return true;
        }
        return "org.eclipse.ui.workbench.navigate".equalsIgnoreCase(id);
    }

    public void populateStatusLine(IActionBarConfigurer configurer) {
        IStatusLineManager statusLine = configurer.getStatusLineManager();
        statusLine.add((IContributionItem)this.statusLineItem);
    }

    private void makeActions(IWorkbenchConfigurer workbenchConfigurer, IActionBarConfigurer actionBarConfigurer) {
        IActivityManager activityManager;
        IWorkbenchActivitySupport workbenchActivitySupport;
        this.setCurrentActionBarConfigurer(actionBarConfigurer);
        this.statusLineItem = new StatusLineContributionItem("ModeContributionItem");
        this.newWizardAction = ActionFactory.NEW.create(this.getWindow());
        this.registerGlobalAction((IAction)this.newWizardAction);
        this.newWizardDropDownAction = IDEActionFactory.NEW_WIZARD_DROP_DOWN.create(this.getWindow());
        this.importResourcesAction = ActionFactory.IMPORT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.importResourcesAction);
        this.exportResourcesAction = ActionFactory.EXPORT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.exportResourcesAction);
        this.rebuildAllAction = IDEActionFactory.REBUILD_ALL.create(this.getWindow());
        this.registerGlobalAction((IAction)this.rebuildAllAction);
        this.buildAllAction = IDEActionFactory.BUILD.create(this.getWindow());
        this.registerGlobalAction((IAction)this.buildAllAction);
        this.saveAction = ActionFactory.SAVE.create(this.getWindow());
        this.registerGlobalAction((IAction)this.saveAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(this.getWindow());
        this.registerGlobalAction((IAction)this.saveAsAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(this.getWindow());
        this.registerGlobalAction((IAction)this.saveAllAction);
        this.undoAction = ActionFactory.UNDO.create(this.getWindow());
        this.registerGlobalAction((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(this.getWindow());
        this.registerGlobalAction((IAction)this.redoAction);
        this.cutAction = ActionFactory.CUT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.cutAction);
        this.copyAction = ActionFactory.COPY.create(this.getWindow());
        this.registerGlobalAction((IAction)this.copyAction);
        this.pasteAction = ActionFactory.PASTE.create(this.getWindow());
        this.registerGlobalAction((IAction)this.pasteAction);
        this.printAction = ActionFactory.PRINT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.printAction);
        this.selectAllAction = ActionFactory.SELECT_ALL.create(this.getWindow());
        this.registerGlobalAction((IAction)this.selectAllAction);
        this.findAction = ActionFactory.FIND.create(this.getWindow());
        this.registerGlobalAction((IAction)this.findAction);
        this.closeAction = ActionFactory.CLOSE.create(this.getWindow());
        this.registerGlobalAction((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(this.getWindow());
        this.registerGlobalAction((IAction)this.closeAllAction);
        this.closeAllSavedAction = ActionFactory.CLOSE_ALL_SAVED.create(this.getWindow());
        this.registerGlobalAction((IAction)this.closeAllSavedAction);
        this.aboutAction = IDEActionFactory.ABOUT.create(this.getWindow());
        AboutInfo aboutInfo = IDEWorkbenchPlugin.getDefault().getPrimaryInfo();
        String productName = null;
        if (aboutInfo != null) {
            productName = aboutInfo.getProductName();
        }
        if (productName == null) {
            productName = "";
        }
        this.aboutAction.setText(IDEWorkbenchMessages.format("AboutAction.text", new Object[]{productName}));
        this.aboutAction.setToolTipText(IDEWorkbenchMessages.format("AboutAction.toolTip", new Object[]{productName}));
        this.aboutAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_OBJS_DEFAULT_PROD"));
        this.registerGlobalAction((IAction)this.aboutAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(this.getWindow());
        this.registerGlobalAction((IAction)this.openPreferencesAction);
        this.addBookmarkAction = IDEActionFactory.BOOKMARK.create(this.getWindow());
        this.registerGlobalAction((IAction)this.addBookmarkAction);
        this.addTaskAction = IDEActionFactory.ADD_TASK.create(this.getWindow());
        this.registerGlobalAction((IAction)this.addTaskAction);
        this.deleteAction = ActionFactory.DELETE.create(this.getWindow());
        AboutInfo[] infos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getWelcomePageURL() != null) {
                this.quickStartAction = IDEActionFactory.QUICK_START.create(this.getWindow());
                this.registerGlobalAction((IAction)this.quickStartAction);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < infos.length) {
            if (infos[i].getTipsAndTricksHref() != null) {
                this.tipsAndTricksAction = IDEActionFactory.TIPS_AND_TRICKS.create(this.getWindow());
                this.registerGlobalAction((IAction)this.tipsAndTricksAction);
                break;
            }
            ++i;
        }
        this.showViewMenuAction = ActionFactory.SHOW_VIEW_MENU.create(this.getWindow());
        this.registerGlobalAction((IAction)this.showViewMenuAction);
        this.showPartPaneMenuAction = ActionFactory.SHOW_PART_PANE_MENU.create(this.getWindow());
        this.registerGlobalAction((IAction)this.showPartPaneMenuAction);
        this.nextEditorAction = ActionFactory.NEXT_EDITOR.create(this.getWindow());
        this.prevEditorAction = ActionFactory.PREVIOUS_EDITOR.create(this.getWindow());
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextEditorAction, (ActionFactory.IWorkbenchAction)this.prevEditorAction);
        this.registerGlobalAction((IAction)this.nextEditorAction);
        this.registerGlobalAction((IAction)this.prevEditorAction);
        this.nextPartAction = ActionFactory.NEXT_PART.create(this.getWindow());
        this.prevPartAction = ActionFactory.PREVIOUS_PART.create(this.getWindow());
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPartAction, (ActionFactory.IWorkbenchAction)this.prevPartAction);
        this.registerGlobalAction((IAction)this.nextPartAction);
        this.registerGlobalAction((IAction)this.prevPartAction);
        this.nextPerspectiveAction = ActionFactory.NEXT_PERSPECTIVE.create(this.getWindow());
        this.prevPerspectiveAction = ActionFactory.PREVIOUS_PERSPECTIVE.create(this.getWindow());
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPerspectiveAction, (ActionFactory.IWorkbenchAction)this.prevPerspectiveAction);
        this.registerGlobalAction((IAction)this.nextPerspectiveAction);
        this.registerGlobalAction((IAction)this.prevPerspectiveAction);
        this.activateEditorAction = ActionFactory.ACTIVATE_EDITOR.create(this.getWindow());
        this.registerGlobalAction((IAction)this.activateEditorAction);
        this.maximizePartAction = ActionFactory.MAXIMIZE.create(this.getWindow());
        this.registerGlobalAction((IAction)this.maximizePartAction);
        this.workbenchEditorsAction = ActionFactory.SHOW_OPEN_EDITORS.create(this.getWindow());
        this.registerGlobalAction((IAction)this.workbenchEditorsAction);
        this.hideShowEditorAction = ActionFactory.SHOW_EDITOR.create(this.getWindow());
        this.registerGlobalAction((IAction)this.hideShowEditorAction);
        this.savePerspectiveAction = ActionFactory.SAVE_PERSPECTIVE.create(this.getWindow());
        this.registerGlobalAction((IAction)this.savePerspectiveAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(this.getWindow());
        this.registerGlobalAction((IAction)this.editActionSetAction);
        this.lockToolBarAction = ActionFactory.LOCK_TOOL_BAR.create(this.getWindow());
        this.registerGlobalAction((IAction)this.lockToolBarAction);
        this.resetPerspectiveAction = ActionFactory.RESET_PERSPECTIVE.create(this.getWindow());
        this.registerGlobalAction((IAction)this.resetPerspectiveAction);
        this.closePerspAction = ActionFactory.CLOSE_PERSPECTIVE.create(this.getWindow());
        this.registerGlobalAction((IAction)this.closePerspAction);
        this.closeAllPerspsAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(this.getWindow());
        this.registerGlobalAction((IAction)this.closeAllPerspsAction);
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(this.getWindow());
        this.registerGlobalAction((IAction)this.forwardHistoryAction);
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(this.getWindow());
        this.registerGlobalAction((IAction)this.backwardHistoryAction);
        this.revertAction = ActionFactory.REVERT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.revertAction);
        this.refreshAction = ActionFactory.REFRESH.create(this.getWindow());
        this.registerGlobalAction((IAction)this.refreshAction);
        this.propertiesAction = ActionFactory.PROPERTIES.create(this.getWindow());
        this.registerGlobalAction((IAction)this.propertiesAction);
        this.quitAction = ActionFactory.QUIT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.quitAction);
        this.moveAction = ActionFactory.MOVE.create(this.getWindow());
        this.registerGlobalAction((IAction)this.moveAction);
        this.renameAction = ActionFactory.RENAME.create(this.getWindow());
        this.registerGlobalAction((IAction)this.renameAction);
        this.goIntoAction = ActionFactory.GO_INTO.create(this.getWindow());
        this.registerGlobalAction((IAction)this.goIntoAction);
        this.backAction = ActionFactory.BACK.create(this.getWindow());
        this.registerGlobalAction((IAction)this.backAction);
        this.forwardAction = ActionFactory.FORWARD.create(this.getWindow());
        this.registerGlobalAction((IAction)this.forwardAction);
        this.upAction = ActionFactory.UP.create(this.getWindow());
        this.registerGlobalAction((IAction)this.upAction);
        this.nextAction = ActionFactory.NEXT.create(this.getWindow());
        this.nextAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_CTOOL_NEXT_NAV"));
        this.registerGlobalAction((IAction)this.nextAction);
        this.previousAction = ActionFactory.PREVIOUS.create(this.getWindow());
        this.previousAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_CTOOL_PREVIOUS_NAV"));
        this.registerGlobalAction((IAction)this.previousAction);
        this.buildProjectAction = IDEActionFactory.BUILD_PROJECT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.buildProjectAction);
        this.rebuildProjectAction = IDEActionFactory.REBUILD_PROJECT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.rebuildProjectAction);
        this.openProjectAction = IDEActionFactory.OPEN_PROJECT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.openProjectAction);
        this.closeProjectAction = IDEActionFactory.CLOSE_PROJECT.create(this.getWindow());
        this.registerGlobalAction((IAction)this.closeProjectAction);
        this.projectPropertyDialogAction = IDEActionFactory.OPEN_PROJECT_PROPERTIES.create(this.getWindow());
        this.registerGlobalAction((IAction)this.projectPropertyDialogAction);
        IWorkbench iWorkbench = this.getWindow().getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.activities.IWorkbenchActivitySupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((workbenchActivitySupport = (IWorkbenchActivitySupport)iWorkbench.getAdapter((Class)clazz)) != null && !(activityManager = workbenchActivitySupport.getActivityManager()).getDefinedCategoryIds().isEmpty()) {
            this.categoryAction = ActionFactory.CONFIGURE_ACTIVITIES.create(this.getWindow());
            this.registerGlobalAction((IAction)this.categoryAction);
        }
        if (EditorWorkbook.usingNewDropDown()) {
            this.editorsDropDownAction = new EditorsDropDownAction(this.window);
            this.registerGlobalAction((IAction)this.editorsDropDownAction);
        }
    }

    private void setCurrentActionBarConfigurer(IActionBarConfigurer actionBarConfigurer) {
        this.actionBarConfigurer = actionBarConfigurer;
    }

    private void registerGlobalAction(IAction action) {
        this.actionBarConfigurer.registerGlobalAction(action);
    }

    private void addManualIncrementalBuildAction() {
        ICoolBarManager coolBarManager;
        IContributionItem cbItem;
        IMenuManager menubar = this.actionBarConfigurer.getMenuManager();
        IMenuManager manager = menubar.findMenuUsingPath("project");
        if (manager != null) {
            try {
                manager.insertBefore(IDEActionFactory.REBUILD_PROJECT.getId(), (IAction)this.buildProjectAction);
                manager.insertBefore(IDEActionFactory.REBUILD_ALL.getId(), (IAction)this.buildAllAction);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            manager.update(false);
        }
        if (!((cbItem = (coolBarManager = this.actionBarConfigurer.getCoolBarManager()).find("org.eclipse.ui.workbench.file")) instanceof ToolBarContributionItem)) {
            IDEWorkbenchPlugin.log("File toolbar contribution item is missing");
            return;
        }
        ToolBarContributionItem toolBarItem = (ToolBarContributionItem)cbItem;
        IToolBarManager toolBarManager = toolBarItem.getToolBarManager();
        if (toolBarManager == null) {
            IDEWorkbenchPlugin.log("File toolbar is missing");
            return;
        }
        toolBarManager.appendToGroup("build.group", (IAction)this.buildAllAction);
        toolBarManager.update(false);
        toolBarItem.update("size");
    }

    private void removeManualIncrementalBuildAction() {
        ICoolBarManager coolBarManager;
        IContributionItem cbItem;
        IMenuManager menubar = this.actionBarConfigurer.getMenuManager();
        IMenuManager manager = menubar.findMenuUsingPath("project");
        if (manager != null) {
            try {
                manager.remove(IDEActionFactory.BUILD.getId());
                manager.remove(IDEActionFactory.BUILD_PROJECT.getId());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            manager.update(false);
        }
        if (!((cbItem = (coolBarManager = this.actionBarConfigurer.getCoolBarManager()).find("org.eclipse.ui.workbench.file")) instanceof ToolBarContributionItem)) {
            IDEWorkbenchPlugin.log("File toolbar contribution item is missing");
            return;
        }
        ToolBarContributionItem toolBarItem = (ToolBarContributionItem)cbItem;
        IToolBarManager toolBarManager = toolBarItem.getToolBarManager();
        if (toolBarManager == null) {
            IDEWorkbenchPlugin.log("File toolbar is missing");
            return;
        }
        if (this.buildAllAction != null) {
            toolBarManager.remove(this.buildAllAction.getId());
            toolBarManager.update(false);
            toolBarItem.update("size");
        }
    }

    static /* synthetic */ void access$3(WorkbenchActionBuilder workbenchActionBuilder) {
        workbenchActionBuilder.removeManualIncrementalBuildAction();
    }

    static /* synthetic */ void access$4(WorkbenchActionBuilder workbenchActionBuilder) {
        workbenchActionBuilder.addManualIncrementalBuildAction();
    }
}

