/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;
import org.eclipse.ui.internal.ide.registry.MarkerImageProviderRegistry;
import org.eclipse.ui.internal.ide.registry.ProjectImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class IDEWorkbenchPlugin
extends AbstractUIPlugin {
    private static IDEWorkbenchPlugin inst;
    public static boolean DEBUG;
    public static final String IDE_WORKBENCH = "org.eclipse.ui.ide";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String PL_MARKER_IMAGE_PROVIDER = "markerImageProviders";
    public static final String PL_MARKER_HELP = "markerHelp";
    public static final String PL_MARKER_RESOLUTION = "markerResolution";
    public static final String PL_CAPABILITIES = "capabilities";
    public static final String PL_PROJECT_NATURE_IMAGES = "projectNatureImages";
    private ProjectImageRegistry projectImageRegistry = null;
    private MarkerImageProviderRegistry markerImageProviderRegistry = null;
    private CapabilityRegistry capabilityRegistry;
    private AboutInfo[] cachedAboutInfos = null;

    static {
        DEBUG = false;
    }

    public IDEWorkbenchPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        inst = this;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        IPluginDescriptor plugin = element.getDeclaringExtension().getDeclaringPluginDescriptor();
        if (plugin.isPluginActivated()) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IDEWorkbenchPlugin getDefault() {
        return inst;
    }

    public static IWorkspace getPluginWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(String message) {
        IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        System.err.println(message);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
            System.err.println(String.valueOf(message) + "\nReason:");
        }
        IDEWorkbenchPlugin.getDefault().getLog().log(status);
        System.err.println(status.getMessage());
    }

    protected void refreshPluginActions() {
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("SAVE_ALL_BEFORE_BUILD", false);
        store.setDefault("saveInterval", 5);
        store.setDefault("WELCOME_DIALOG", true);
        store.setDefault("REFRESH_WORKSPACE_ON_STARTUP", false);
        store.setDefault("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", true);
        store.setDefault("SHOW_TASKS_ON_BUILD", true);
        store.setDefault("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION", "prompt");
        store.setDefault("PROJECT_OPEN_NEW_PERSPECTIVE", "OPEN_PERSPECTIVE_REPLACE");
    }

    public ProjectImageRegistry getProjectImageRegistry() {
        if (this.projectImageRegistry == null) {
            this.projectImageRegistry = new ProjectImageRegistry();
            this.projectImageRegistry.load();
        }
        return this.projectImageRegistry;
    }

    public MarkerImageProviderRegistry getMarkerImageProviderRegistry() {
        if (this.markerImageProviderRegistry == null) {
            this.markerImageProviderRegistry = new MarkerImageProviderRegistry();
        }
        return this.markerImageProviderRegistry;
    }

    public CapabilityRegistry getCapabilityRegistry() {
        if (this.capabilityRegistry == null) {
            this.capabilityRegistry = new CapabilityRegistry();
            this.capabilityRegistry.load();
        }
        return this.capabilityRegistry;
    }

    private AboutInfo[] readFeatureInfos() {
        IPlatformConfiguration conf = BootLoader.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] entries = conf.getConfiguredFeatureEntries();
        ArrayList<AboutInfo> infos = new ArrayList<AboutInfo>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String featureId = entries[i].getFeatureIdentifier();
            String versionId = entries[i].getFeatureVersion();
            String pluginId = entries[i].getFeaturePluginIdentifier();
            AboutInfo info = null;
            if (versionId != null && pluginId != null) {
                info = AboutInfo.readFeatureInfo((String)featureId, (String)versionId, (String)pluginId);
            }
            if (info != null) {
                infos.add(info);
            }
            ++i;
        }
        AboutInfo[] result = new AboutInfo[infos.size()];
        infos.toArray(result);
        return result;
    }

    public AboutInfo[] getFeatureInfos() {
        if (this.cachedAboutInfos == null) {
            this.cachedAboutInfos = this.readFeatureInfos();
        }
        return this.cachedAboutInfos;
    }

    public AboutInfo getPrimaryInfo() {
        IPlatformConfiguration conf = BootLoader.getCurrentPlatformConfiguration();
        String featureId = conf.getPrimaryFeatureIdentifier();
        if (featureId == null) {
            return null;
        }
        if (this.cachedAboutInfos == null) {
            this.cachedAboutInfos = this.readFeatureInfos();
        }
        int i = 0;
        while (i < this.cachedAboutInfos.length) {
            if (featureId.equals(this.cachedAboutInfos[i].getFeatureId())) {
                return this.cachedAboutInfos[i];
            }
            ++i;
        }
        return null;
    }
}

