/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.ide.EditorAreaDropAdapter;
import org.eclipse.ui.internal.ide.IDEExceptionHandler;
import org.eclipse.ui.internal.ide.IDEWorkbenchActivityHelper;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.WorkbenchActionBuilder;
import org.eclipse.ui.internal.ide.dialogs.MessageDialogWithToggle;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterBuilder;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.update.core.SiteManager;

public class IDEWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String ACTION_BUILDER = "ActionBuilder";
    private static final String WELCOME_EDITOR_ID = "org.eclipse.ui.internal.ide.dialogs.WelcomeEditor";
    private static final String WORKBENCH_PREFERENCE_CATEGORY_ID = "org.eclipse.ui.preferencePages.Workbench";
    private static final String INSTALLED_FEATURES = "installedFeatures";
    private static IDEWorkbenchAdvisor workbenchAdvisor = null;
    private IWorkbenchConfigurer configurer;
    private IDEExceptionHandler exceptionHandler = null;
    private boolean autoBuild;
    private String workspaceLocation = null;
    private Set previousFeatures = null;
    private Set currentFeatures = null;
    private Set newlyAddedFeatures = null;
    private ArrayList welcomePerspectiveInfos = null;
    private IDEWorkbenchActivityHelper activityHelper = null;

    protected IDEWorkbenchAdvisor() {
        if (workbenchAdvisor != null) {
            throw new IllegalStateException();
        }
        workbenchAdvisor = this;
    }

    static final IDEWorkbenchAdvisor getAdvisor() {
        return workbenchAdvisor;
    }

    IWorkbenchConfigurer getWorkbenchConfigurer() {
        return this.configurer;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        this.configurer = configurer;
        configurer.setSaveAndRestore(true);
        this.exceptionHandler = new IDEExceptionHandler(configurer);
        WorkbenchAdapterBuilder.registerAdapters();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.getShowTasksChangeListener(), 1);
        String[] cmdLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < cmdLineArgs.length) {
            if ("-showlocation".equalsIgnoreCase(cmdLineArgs[i])) {
                this.workspaceLocation = Platform.getLocation().toOSString();
                break;
            }
            ++i;
        }
        this.declareWorkbenchImages();
        this.activityHelper = IDEWorkbenchActivityHelper.getInstance();
    }

    public void preStartup() {
        this.disableAutoBuild();
        this.initializeFeatureSets();
        Set s = this.getNewlyAddedFeatures();
        this.welcomePerspectiveInfos = new ArrayList(s.size());
        Iterator it = s.iterator();
        while (it.hasNext()) {
            String featureVersionId;
            String versionedId = (String)it.next();
            String featureId = versionedId.substring(0, versionedId.indexOf(58));
            AboutInfo info = AboutInfo.readFeatureInfo((String)featureId, (String)(featureVersionId = versionedId.substring(versionedId.indexOf(58) + 1)), (String)featureId);
            if (info == null || info.getWelcomePerspectiveId() == null || info.getWelcomePageURL() == null) continue;
            this.welcomePerspectiveInfos.add(info);
        }
    }

    public void postStartup() {
        this.refreshFromLocal();
        this.enableAutoBuild();
        try {
            this.openWelcomeEditors();
        }
        catch (WorkbenchException e) {
            IDEWorkbenchPlugin.log("Fail to open remaining welcome editors.", e.getStatus());
        }
        this.checkUpdates();
    }

    public void postShutdown() {
        if (this.activityHelper != null) {
            this.activityHelper.shutdown();
            this.activityHelper = null;
        }
        if (IDEWorkbenchPlugin.getPluginWorkspace() != null) {
            this.disconnectFromWorkspace();
        }
    }

    public void eventLoopException(Throwable exception) {
        super.eventLoopException(exception);
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handleException(exception);
        } else if (this.configurer != null) {
            this.configurer.emergencyClose();
        }
    }

    public boolean preWindowShellClose(IWorkbenchWindowConfigurer windowConfigurer) {
        if (this.configurer.getWorkbench().getWorkbenchWindowCount() > 1) {
            return true;
        }
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW");
        if (promptOnExit) {
            String productName = null;
            AboutInfo about = IDEWorkbenchPlugin.getDefault().getPrimaryInfo();
            if (about != null) {
                productName = about.getProductName();
            }
            String message = productName == null ? IDEWorkbenchMessages.getString("PromptOnExitDialog.message0") : IDEWorkbenchMessages.format("PromptOnExitDialog.message1", new Object[]{productName});
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openConfirm(windowConfigurer.getWindow().getShell(), IDEWorkbenchMessages.getString("PromptOnExitDialog.shellTitle"), message, IDEWorkbenchMessages.getString("PromptOnExitDialog.choice"), false);
            if (dlg.getReturnCode() == 0) {
                store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", !dlg.getToggleState());
                return true;
            }
            return false;
        }
        return true;
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer windowConfigurer) {
        windowConfigurer.addEditorAreaTransfer((Transfer)EditorInputTransfer.getInstance());
        windowConfigurer.addEditorAreaTransfer((Transfer)ResourceTransfer.getInstance());
        windowConfigurer.addEditorAreaTransfer((Transfer)MarkerTransfer.getInstance());
        windowConfigurer.configureEditorAreaDropListener((DropTargetListener)new EditorAreaDropAdapter(windowConfigurer.getWindow()));
        windowConfigurer.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
                IDEWorkbenchAdvisor.this.updateTitle(page.getWorkbenchWindow());
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        windowConfigurer.getWindow().addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IDEWorkbenchAdvisor.this.updateTitle(page.getWorkbenchWindow());
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        });
        windowConfigurer.getWindow().getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference || ref.getPage().getActiveEditor() == null) {
                    IDEWorkbenchAdvisor.this.updateTitle(ref.getPage().getWorkbenchWindow());
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference || ref.getPage().getActiveEditor() == null) {
                    IDEWorkbenchAdvisor.this.updateTitle(ref.getPage().getWorkbenchWindow());
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }

            public void partHidden(IWorkbenchPartReference ref) {
            }

            public void partVisible(IWorkbenchPartReference ref) {
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
            }
        });
    }

    public void postWindowRestore(IWorkbenchWindowConfigurer windowConfigurer) throws WorkbenchException {
        int index = PlatformUI.getWorkbench().getWorkbenchWindowCount() - 1;
        if (index >= 0 && this.welcomePerspectiveInfos != null && index < this.welcomePerspectiveInfos.size()) {
            IWorkbenchPage[] pages;
            IWorkbenchPage page = windowConfigurer.getWindow().getActivePage();
            if (page == null && (pages = windowConfigurer.getWindow().getPages()) != null && pages.length > 0) {
                page = pages[0];
            }
            String perspectiveId = ((AboutInfo)this.welcomePerspectiveInfos.get(index)).getWelcomePerspectiveId();
            if (page == null) {
                IAdaptable root = this.getDefaultPageInput();
                page = windowConfigurer.getWindow().openPage(perspectiveId, root);
            } else {
                IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
                IPerspectiveDescriptor desc = reg.findPerspectiveWithId(perspectiveId);
                if (desc != null) {
                    page.setPerspective(desc);
                }
            }
            windowConfigurer.getWindow().setActivePage(page);
            page.openEditor((IEditorInput)new WelcomeEditorInput((AboutInfo)this.welcomePerspectiveInfos.get(index)), WELCOME_EDITOR_ID, true);
        }
    }

    public void postWindowClose(IWorkbenchWindowConfigurer windowConfigurer) {
        WorkbenchActionBuilder a = (WorkbenchActionBuilder)windowConfigurer.getData(ACTION_BUILDER);
        if (a != null) {
            windowConfigurer.setData(ACTION_BUILDER, null);
            a.dispose();
        }
    }

    private IResourceChangeListener getShowTasksChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarker error;
                IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
                if (store.getBoolean("SHOW_TASKS_ON_BUILD") && (error = IDEWorkbenchAdvisor.this.findProblemToShow(event)) != null) {
                    Display.getDefault().asyncExec(new Runnable(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            try {
                                IWorkbenchPage page;
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                if (window != null && !window.getShell().isDisposed() && (page = window.getActivePage()) != null) {
                                    IViewPart tasksView = page.findView("org.eclipse.ui.views.ProblemView");
                                    if (tasksView == null) {
                                        IWorkbenchPart activePart = page.getActivePart();
                                        page.showView("org.eclipse.ui.views.ProblemView");
                                        page.activate(activePart);
                                    } else {
                                        page.bringToTop((IWorkbenchPart)tasksView);
                                    }
                                }
                            }
                            catch (PartInitException e) {
                                IDEWorkbenchPlugin.log("Error bringing problem view to front", e.getStatus());
                            }
                        }
                    });
                }
            }
        };
    }

    private IMarker findProblemToShow(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
        int i = 0;
        while (i < markerDeltas.length) {
            int sev;
            IMarkerDelta markerDelta = markerDeltas[i];
            if (markerDelta.getKind() == 1 && ((sev = markerDelta.getAttribute("severity", -1)) == 2 || sev == 1)) {
                return markerDelta.getMarker();
            }
            ++i;
        }
        return null;
    }

    private void disableAutoBuild() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        this.autoBuild = description.isAutoBuilding();
        if (this.autoBuild) {
            description.setAutoBuilding(false);
            try {
                workspace.setDescription(description);
            }
            catch (CoreException coreException) {
                MessageDialog.openError(null, (String)IDEWorkbenchMessages.getString("Workspace.problemsTitle"), (String)IDEWorkbenchMessages.getString("Restoring_Problem"));
            }
        }
    }

    private void enableAutoBuild() {
        if (this.autoBuild) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            Shell shell = windows[windows.length - 1].getShell();
            try {
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        monitor.setTaskName(IDEWorkbenchMessages.getString("Workbench.autoBuild"));
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IWorkspaceDescription description = workspace.getDescription();
                        description.setAutoBuilding(true);
                        workspace.setDescription(description);
                    }
                };
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    window.run(true, true, (IRunnableWithProgress)op);
                } else {
                    new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("Workspace.problemsTitle"), (String)IDEWorkbenchMessages.getString("Workspace.problemAutoBuild"));
            }
        }
    }

    private void refreshFromLocal() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean refresh = store.getBoolean("REFRESH_WORKSPACE_ON_STARTUP");
        if (!refresh) {
            return;
        }
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-refresh")) {
                return;
            }
            ++i;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        Shell shell = windows[windows.length - 1].getShell();
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(shell);
        final CoreException[] ex = new CoreException[1];
        try {
            dlg.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        root.refreshLocal(2, monitor);
                    }
                    catch (CoreException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                ErrorDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("Workspace.problemsTitle"), (String)IDEWorkbenchMessages.getString("Workspace.problemMessage"), (IStatus)ex[0].getStatus());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String msg = "InvocationTargetException refreshing from local on startup";
            IDEWorkbenchPlugin.log(msg, (IStatus)new Status(4, "org.eclipse.ui.ide", 0, msg, e.getTargetException()));
        }
    }

    private void disconnectFromWorkspace() {
        final MultiStatus status = new MultiStatus("org.eclipse.ui.ide", 1, IDEWorkbenchMessages.getString("ProblemSavingWorkbench"), null);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    status.merge(ResourcesPlugin.getWorkspace().save(true, monitor));
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            }
        };
        try {
            new ProgressMonitorDialog(null).run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.getString("InternalError"), e.getTargetException()));
        }
        catch (InterruptedException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.getString("InternalError"), (Throwable)e));
        }
        ErrorDialog.openError(null, (String)IDEWorkbenchMessages.getString("ProblemsSavingWorkspace"), null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            IDEWorkbenchPlugin.log(IDEWorkbenchMessages.getString("ProblemsSavingWorkspace"), (IStatus)status);
        }
    }

    private void checkUpdates() {
        boolean newUpdates = false;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-newUpdates")) {
                newUpdates = true;
                break;
            }
            ++i;
        }
        if (newUpdates) {
            try {
                SiteManager.handleNewChanges();
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Problem opening update manager", e.getStatus());
            }
        }
    }

    public boolean isApplicationMenu(IWorkbenchWindowConfigurer windowConfigurer, String menuID) {
        WorkbenchActionBuilder a = (WorkbenchActionBuilder)windowConfigurer.getData(ACTION_BUILDER);
        return a.isContainerMenu(menuID);
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getInitialWindowPerspectiveId() {
        int index = PlatformUI.getWorkbench().getWorkbenchWindowCount() - 1;
        String perspectiveId = null;
        if (index >= 0 && this.welcomePerspectiveInfos != null && index < this.welcomePerspectiveInfos.size()) {
            perspectiveId = ((AboutInfo)this.welcomePerspectiveInfos.get(index)).getWelcomePerspectiveId();
        }
        if (perspectiveId == null) {
            perspectiveId = "org.eclipse.ui.resourcePerspective";
        }
        return perspectiveId;
    }

    private void openWelcomeEditors() throws WorkbenchException {
        IWorkbenchWindow window = this.configurer.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            if (this.configurer.getWorkbench().getWorkbenchWindowCount() > 0) {
                window = this.configurer.getWorkbench().getWorkbenchWindows()[0];
            } else {
                return;
            }
        }
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("WELCOME_DIALOG")) {
            AboutInfo primaryInfo = IDEWorkbenchPlugin.getDefault().getPrimaryInfo();
            if (primaryInfo == null) {
                return;
            }
            URL url = primaryInfo.getWelcomePageURL();
            if (url == null) {
                return;
            }
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("WELCOME_DIALOG", false);
            this.openWelcomeEditor(window, new WelcomeEditorInput(primaryInfo), null);
        } else {
            ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
            Iterator it = this.getNewlyAddedFeatures().iterator();
            while (it.hasNext()) {
                String pi;
                String versionedId = (String)it.next();
                String featureId = versionedId.substring(0, versionedId.indexOf(58));
                AboutInfo info = null;
                AboutInfo[] infos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
                int i = 0;
                while (i < infos.length) {
                    if (featureId.equals(infos[i].getFeatureId())) {
                        info = infos[i];
                        break;
                    }
                    ++i;
                }
                if (info == null || info.getWelcomePageURL() == null) continue;
                welcomeFeatures.add(info);
                IPlatformConfiguration platformConfiguration = BootLoader.getCurrentPlatformConfiguration();
                IPlatformConfiguration.IFeatureEntry feature = platformConfiguration.findConfiguredFeatureEntry(featureId);
                if (feature == null || (pi = feature.getFeaturePluginIdentifier()) == null) continue;
                Platform.getPlugin((String)pi);
            }
            int wCount = this.configurer.getWorkbench().getWorkbenchWindowCount();
            int i = 0;
            while (i < welcomeFeatures.size()) {
                AboutInfo newInfo = (AboutInfo)welcomeFeatures.get(i);
                String id = newInfo.getWelcomePerspectiveId();
                if (id == null || i >= wCount) {
                    this.openWelcomeEditor(window, new WelcomeEditorInput(newInfo), id);
                }
                ++i;
            }
        }
    }

    private Set computeFeatureSet() {
        IPlatformConfiguration platformConfiguration = BootLoader.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] features = platformConfiguration.getConfiguredFeatureEntries();
        HashSet<String> ids = new HashSet<String>(features.length);
        int i = 0;
        while (i < features.length) {
            IPlatformConfiguration.IFeatureEntry feature = features[i];
            String pluginId = feature.getFeaturePluginIdentifier();
            if (pluginId != null) {
                String id = feature.getFeatureIdentifier();
                String version = feature.getFeatureVersion();
                String normalizedVersion = "0.0.0";
                if (version != null) {
                    PluginVersionIdentifier vid = new PluginVersionIdentifier(version);
                    normalizedVersion = vid.toString();
                }
                String versionedId = String.valueOf(id) + ":" + normalizedVersion;
                ids.add(versionedId);
            }
            ++i;
        }
        return ids;
    }

    private Set getPreviousFeatures() {
        Assert.isNotNull((Object)this.previousFeatures);
        return this.previousFeatures;
    }

    private Set getCurrentFeatures() {
        Assert.isNotNull((Object)this.currentFeatures);
        return this.currentFeatures;
    }

    private Set getNewlyAddedFeatures() {
        Assert.isNotNull((Object)this.newlyAddedFeatures);
        return this.newlyAddedFeatures;
    }

    private void initializeFeatureSets() {
        Assert.isTrue((this.currentFeatures == null ? 1 : 0) != 0);
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        String[] previousFeaturesArray = settings.getArray(INSTALLED_FEATURES);
        this.previousFeatures = null;
        this.previousFeatures = previousFeaturesArray != null ? new HashSet<String>(Arrays.asList(previousFeaturesArray)) : new HashSet(0);
        this.currentFeatures = this.computeFeatureSet();
        String[] currentFeaturesArray = new String[this.currentFeatures.size()];
        this.currentFeatures.toArray(currentFeaturesArray);
        settings.put(INSTALLED_FEATURES, currentFeaturesArray);
        this.newlyAddedFeatures = new TreeSet(this.currentFeatures);
        this.newlyAddedFeatures.removeAll(this.previousFeatures);
    }

    private void openWelcomeEditor(IWorkbenchWindow window, WelcomeEditorInput input, String perspectiveId) {
        if (this.configurer.getWorkbench().getWorkbenchWindowCount() == 0) {
            return;
        }
        IWorkbenchWindow win = window;
        if (perspectiveId != null) {
            try {
                win = this.configurer.getWorkbench().openWorkbenchWindow(perspectiveId, this.getDefaultPageInput());
                if (win == null) {
                    win = window;
                }
            }
            catch (WorkbenchException e) {
                IDEWorkbenchPlugin.log("Error opening window with welcome perspective.", e.getStatus());
                return;
            }
        }
        if (win == null) {
            win = this.configurer.getWorkbench().getWorkbenchWindows()[0];
        }
        IWorkbenchPage page = win.getActivePage();
        String id = perspectiveId;
        if (id == null) {
            id = this.configurer.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (page == null) {
            try {
                page = win.openPage(id, this.getDefaultPageInput());
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.getString("Problems_Opening_Page"), (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            try {
                page = this.configurer.getWorkbench().showPerspective(id, win);
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.getString("Workbench.openEditorErrorDialogTitle"), (String)IDEWorkbenchMessages.getString("Workbench.openEditorErrorDialogMessage"), (IStatus)e.getStatus());
                return;
            }
        }
        page.setEditorAreaVisible(true);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.activate((IWorkbenchPart)editor);
            return;
        }
        try {
            page.openEditor((IEditorInput)input, WELCOME_EDITOR_ID);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.getString("Workbench.openEditorErrorDialogTitle"), (String)IDEWorkbenchMessages.getString("Workbench.openEditorErrorDialogMessage"), (IStatus)e.getStatus());
        }
    }

    private void updateTitle(IWorkbenchWindow window) {
        IWorkbenchPage currentPage;
        IWorkbenchWindowConfigurer windowConfigurer = this.configurer.getWindowConfigurer(window);
        String title = null;
        AboutInfo about = IDEWorkbenchPlugin.getDefault().getPrimaryInfo();
        if (about != null) {
            title = about.getProductName();
        }
        if (title == null) {
            title = "";
        }
        if (this.workspaceLocation != null) {
            title = IDEWorkbenchMessages.format("WorkbenchWindow.shellTitle", new Object[]{this.workspaceLocation, title});
        }
        if ((currentPage = window.getActivePage()) != null) {
            IAdaptable input;
            IEditorPart editor = currentPage.getActiveEditor();
            if (editor != null) {
                String editorTitle = editor.getTitle();
                title = IDEWorkbenchMessages.format("WorkbenchWindow.shellTitle", new Object[]{editorTitle, title});
            }
            IPerspectiveDescriptor persp = currentPage.getPerspective();
            String label = "";
            if (persp != null) {
                label = persp.getLabel();
            }
            if ((input = currentPage.getInput()) != null && !input.equals(this.getDefaultPageInput())) {
                label = currentPage.getLabel();
            }
            if (label != null && !label.equals("")) {
                title = IDEWorkbenchMessages.format("WorkbenchWindow.shellTitle", new Object[]{label, title});
            }
        }
        windowConfigurer.setTitle(title);
    }

    private void declareWorkbenchImages() {
        this.declareWorkbenchImage("IMG_TOOL_NEW_WIZARD", "icons/full/etool16/new_wiz.gif", true);
        this.declareWorkbenchImage("IMG_TOOL_NEW_WIZARD_HOVER", "icons/full/ctool16/new_wiz.gif", true);
        this.declareWorkbenchImage("IMG_TOOL_NEW_WIZARD_DISABLED", "icons/full/dtool16/new_wiz.gif", true);
        this.declareWorkbenchImage("IMG_CTOOL_IMPORT_WIZ", "icons/full/ctool16/import_wiz.gif", false);
        this.declareWorkbenchImage("IMG_CTOOL_EXPORT_WIZ", "icons/full/ctool16/export_wiz.gif", false);
        this.declareWorkbenchImage("IMG_CTOOL_BUILD_EXEC", "icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage("IMG_CTOOL_BUILD_EXEC_HOVER", "icons/full/ctool16/build_exec.gif", false);
        this.declareWorkbenchImage("IMG_CTOOL_BUILD_EXEC_DISABLED", "icons/full/dtool16/build_exec.gif", false);
        this.declareWorkbenchImage("IMG_CTOOL_SEARCH_SRC", "icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage("IMG_CTOOL_SEARCH_SRC_HOVER", "icons/full/ctool16/search_src.gif", false);
        this.declareWorkbenchImage("IMG_CTOOL_SEARCH_SRC_DISABLED", "icons/full/dtool16/search_src.gif", false);
        this.declareWorkbenchImage("IMG_CTOOL_NEXT_NAV", "icons/full/ctool16/next_nav.gif", false);
        this.declareWorkbenchImage("IMG_CTOOL_PREVIOUS_NAV", "icons/full/ctool16/prev_nav.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_NEW_WIZ", "icons/full/wizban/new_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_NEWPRJ_WIZ", "icons/full/wizban/newprj_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_NEWFOLDER_WIZ", "icons/full/wizban/newfolder_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_NEWFILE_WIZ", "icons/full/wizban/newfile_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_IMPORT_WIZ", "icons/full/wizban/import_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_IMPORTDIR_WIZ", "icons/full/wizban/importdir_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_IMPORTZIP_WIZ", "icons/full/wizban/importzip_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_EXPORT_WIZ", "icons/full/wizban/export_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_EXPORTDIR_WIZ", "icons/full/wizban/exportdir_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_EXPORTZIP_WIZ", "icons/full/wizban/exportzip_wiz.gif", false);
        this.declareWorkbenchImage("IMG_WIZBAN_EXPORTZIP_WIZ", "icons/full/wizban/res_workset_wiz.gif", false);
        this.declareWorkbenchImage("IMG_OBJ_PROJECT", "icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage("IMG_OBJ_PROJECT_CLOSED", "icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage("IMG_OPEN_MARKER", "icons/full/clcl16/gotoobj_tsk.gif", true);
        this.declareWorkbenchImage("IMG_OBJS_TASK_TSK", "icons/full/obj16/taskmrk_tsk.gif", true);
        this.declareWorkbenchImage("IMG_OBJS_BKMRK_TSK", "icons/full/obj16/bkmrk_tsk.gif", true);
        this.declareWorkbenchImage("IMG_OBJS_COMPLETE_TSK", "icons/full/obj16/complete_tsk.gif", true);
        this.declareWorkbenchImage("IMG_OBJS_INCOMPLETE_TSK", "icons/full/obj16/incomplete_tsk.gif", true);
        this.declareWorkbenchImage("IMG_OBJS_WELCOME_ITEM", "icons/full/obj16/welcome_item.gif", true);
        this.declareWorkbenchImage("IMG_OBJS_WELCOME_BANNER", "icons/full/obj16/welcome_banner.gif", true);
    }

    private void declareWorkbenchImage(String symbolicName, String path, boolean shared) {
        URL url = null;
        try {
            URL URL_BASIC = Platform.getPlugin((String)"org.eclipse.ui.ide").getDescriptor().getInstallURL();
            url = new URL(URL_BASIC, path);
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.configurer.declareImage(symbolicName, desc, shared);
    }

    public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer actionConfigurer, int flags) {
        WorkbenchActionBuilder actionBuilder = null;
        IWorkbenchWindowConfigurer windowConfigurer = this.configurer.getWindowConfigurer(window);
        actionBuilder = (WorkbenchActionBuilder)windowConfigurer.getData(ACTION_BUILDER);
        if (actionBuilder == null) {
            actionBuilder = new WorkbenchActionBuilder(window);
        }
        if ((flags & 1) != 0) {
            if ((flags & 2) != 0) {
                actionBuilder.populateMenuBar(actionConfigurer);
            }
            if ((flags & 4) != 0) {
                actionBuilder.populateCoolBar(actionConfigurer);
            }
        } else {
            windowConfigurer.setData(ACTION_BUILDER, (Object)actionBuilder);
            actionBuilder.makeAndPopulateActions(this.configurer, actionConfigurer);
        }
    }

    public String getMainPreferencePageId() {
        return WORKBENCH_PREFERENCE_CATEGORY_ID;
    }
}

