/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class IDEWorkbenchActivityHelper {
    private IResourceChangeListener listener = this.getChangeListener();
    private static IDEWorkbenchActivityHelper singleton;
    static /* synthetic */ Class class$0;

    public static IDEWorkbenchActivityHelper getInstance() {
        if (singleton == null) {
            singleton = new IDEWorkbenchActivityHelper();
        }
        return singleton;
    }

    private IDEWorkbenchActivityHelper() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
    }

    private IResourceChangeListener getChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta mainDelta = event.getDelta();
                if (mainDelta == null) {
                    return;
                }
                if (mainDelta.getKind() == 4 && mainDelta.getResource().getType() == 8) {
                    try {
                        IWorkbenchActivitySupport workbenchActivitySupport;
                        IResourceDelta[] children = mainDelta.getAffectedChildren();
                        IWorkbench iWorkbench = PlatformUI.getWorkbench();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.activities.IWorkbenchActivitySupport;").getComponentType();
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((workbenchActivitySupport = (IWorkbenchActivitySupport)iWorkbench.getAdapter((Class)clazz)) != null) {
                            IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
                            int i = 0;
                            while (i < children.length) {
                                IResourceDelta delta = children[i];
                                if (delta.getResource().getType() == 4) {
                                    IProject project = (IProject)delta.getResource();
                                    String[] ids = project.getDescription().getNatureIds();
                                    int j = 0;
                                    while (j < ids.length) {
                                        IIdentifier identifier = activityManager.getIdentifier(ids[j]);
                                        HashSet activities = new HashSet(activityManager.getEnabledActivityIds());
                                        if (activities.addAll(identifier.getActivityIds())) {
                                            workbenchActivitySupport.setEnabledActivityIds(activities);
                                        }
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
        };
    }

    public void shutdown() {
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
    }
}

