/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class DeleteResourceAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.DeleteResourceAction";
    private Shell shell;
    private boolean deleteContent = false;
    private boolean forceOutOfSyncDelete = false;

    public DeleteResourceAction(Shell shell) {
        super(IDEWorkbenchMessages.getString("DeleteResourceAction.text"));
        this.setToolTipText(IDEWorkbenchMessages.getString("DeleteResourceAction.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.delete_resource_action_context");
        this.setId(ID);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.shell = shell;
    }

    boolean canDelete() {
        if (!this.containsOnlyProjects() && !this.containsOnlyNonProjects()) {
            return false;
        }
        List resources = this.getSelectedResources();
        if (resources.size() == 0) {
            return false;
        }
        Iterator e = resources.iterator();
        while (e.hasNext()) {
            IResource next = (IResource)e.next();
            if (!next.isPhantom()) continue;
            return false;
        }
        return true;
    }

    boolean containsLinkedResource() {
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IResource resource = (IResource)iterator.next();
            if (!resource.isLinked()) continue;
            return true;
        }
        return false;
    }

    boolean containsOnlyNonProjects() {
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        int types = this.getSelectedResourceTypes();
        if (types == 0) {
            return false;
        }
        return (types & 4) == 0;
    }

    boolean containsOnlyProjects() {
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        int types = this.getSelectedResourceTypes();
        return types == 4;
    }

    boolean confirmDelete() {
        if (this.containsOnlyProjects()) {
            return this.confirmDeleteProjects();
        }
        return this.confirmDeleteNonProjects();
    }

    boolean confirmDeleteNonProjects() {
        String msg;
        String title;
        List resources = this.getSelectedResources();
        if (resources.size() == 1) {
            title = IDEWorkbenchMessages.getString("DeleteResourceAction.title1");
            IResource resource = (IResource)resources.get(0);
            msg = resource.isLinked() ? IDEWorkbenchMessages.format("DeleteResourceAction.confirmLinkedResource1", new Object[]{resource.getName()}) : IDEWorkbenchMessages.format("DeleteResourceAction.confirm1", new Object[]{resource.getName()});
        } else {
            title = IDEWorkbenchMessages.getString("DeleteResourceAction.titleN");
            msg = this.containsLinkedResource() ? IDEWorkbenchMessages.format("DeleteResourceAction.confirmLinkedResourceN", new Object[]{new Integer(resources.size())}) : IDEWorkbenchMessages.format("DeleteResourceAction.confirmN", new Object[]{new Integer(resources.size())});
        }
        return MessageDialog.openQuestion((Shell)this.shell, (String)title, (String)msg);
    }

    boolean confirmDeleteProjects() {
        List resources = this.getSelectedResources();
        DeleteProjectDialog dialog = new DeleteProjectDialog(this.shell, resources);
        int code = dialog.open();
        this.deleteContent = dialog.getDeleteContent();
        return code == 0;
    }

    void delete(IResource[] resourcesToDelete, IProgressMonitor monitor) throws CoreException {
        this.forceOutOfSyncDelete = false;
        monitor.beginTask("", resourcesToDelete.length);
        int i = 0;
        while (i < resourcesToDelete.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.delete(resourcesToDelete[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
            ++i;
        }
        monitor.done();
    }

    void delete(IResource resourceToDelete, IProgressMonitor monitor) throws CoreException {
        boolean force = false;
        try {
            if (resourceToDelete.getType() == 4) {
                IProject project = (IProject)resourceToDelete;
                project.delete(this.deleteContent, force, monitor);
            } else {
                resourceToDelete.delete(2, monitor);
            }
        }
        catch (CoreException exception) {
            if (resourceToDelete.getType() == 1) {
                IStatus[] children = exception.getStatus().getChildren();
                if (children.length == 1 && children[0].getCode() == 274) {
                    if (this.forceOutOfSyncDelete) {
                        resourceToDelete.delete(3, monitor);
                    } else {
                        int result = this.queryDeleteOutOfSync(resourceToDelete);
                        if (result == 2) {
                            resourceToDelete.delete(3, monitor);
                        } else if (result == 4) {
                            this.forceOutOfSyncDelete = true;
                            resourceToDelete.delete(3, monitor);
                        } else if (result == 1) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                throw exception;
            }
            throw exception;
        }
    }

    IResource[] getSelectedResourcesArray() {
        List selection = this.getSelectedResources();
        IResource[] resources = new IResource[selection.size()];
        int i = 0;
        Iterator e = selection.iterator();
        while (e.hasNext()) {
            resources[i++] = (IResource)e.next();
        }
        return resources;
    }

    int getSelectedResourceTypes() {
        int types = 0;
        Iterator i = this.getSelectedResources().iterator();
        while (i.hasNext()) {
            IResource r = (IResource)i.next();
            types |= r.getType();
        }
        return types;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block9: {
            block10: {
                if (!this.confirmDelete()) {
                    return;
                }
                resourcesToDelete = this.getResourcesToDelete();
                if (resourcesToDelete.length == 0) {
                    return;
                }
                try {
                    op = new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor monitor) throws CoreException {
                            DeleteResourceAction.this.delete(resourcesToDelete, monitor);
                        }
                    };
                    new ProgressMonitorDialog(this.shell).run(true, true, (IRunnableWithProgress)op);
                    break block9;
                }
                catch (InvocationTargetException e) {
                    t = e.getTargetException();
                    if (!(t instanceof CoreException)) break block10;
                    exception = (CoreException)t;
                    status = exception.getStatus();
                    children = status.getChildren();
                    outOfSyncError = false;
                    i = 0;
                    ** while (i < children.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (children[i].getCode() == 274) {
                        outOfSyncError = true;
                        break;
                    }
                    ++i;
                    continue;
                }
lbl24:
                // 2 sources

                IDEWorkbenchPlugin.log(MessageFormat.format("Exception in {0}.run: {1}", new Object[]{this.getClass().getName(), t}), status);
                if (outOfSyncError) {
                    ErrorDialog.openError((Shell)this.shell, (String)IDEWorkbenchMessages.getString("DeleteResourceAction.errorTitle"), (String)IDEWorkbenchMessages.getString("DeleteResourceAction.outOfSyncError"), (IStatus)status);
                } else {
                    ErrorDialog.openError((Shell)this.shell, (String)IDEWorkbenchMessages.getString("DeleteResourceAction.errorTitle"), null, (IStatus)status);
                }
                break block9;
            }
            IDEWorkbenchPlugin.log(MessageFormat.format("Exception in {0}.run: {1}", new Object[]{this.getClass().getName(), t}));
            MessageDialog.openError((Shell)this.shell, (String)IDEWorkbenchMessages.getString("DeleteResourceAction.messageTitle"), (String)IDEWorkbenchMessages.format("DeleteResourceAction.internalError", new Object[]{t.getMessage()}));
            break block9;
            catch (InterruptedException v0) {}
        }
    }

    IResource[] getResourcesToDelete() {
        IResource[] selectedResources = this.getSelectedResourcesArray();
        if (this.containsOnlyProjects() && !this.deleteContent) {
            return selectedResources;
        }
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.shell, IDEWorkbenchMessages.getString("DeleteResourceAction.title1"), IDEWorkbenchMessages.getString("DeleteResourceAction.readOnlyQuestion"));
        return checker.checkReadOnlyResources(selectedResources);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canDelete();
    }

    private int queryDeleteOutOfSync(IResource resource) {
        final MessageDialog dialog = new MessageDialog(this.shell, IDEWorkbenchMessages.getString("DeleteResourceAction.messageTitle"), null, IDEWorkbenchMessages.format("DeleteResourceAction.outOfSyncQuestion", new Object[]{resource.getName()}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        int result = dialog.getReturnCode();
        if (result == 0) {
            return 2;
        }
        if (result == 1) {
            return 4;
        }
        if (result == 2) {
            return 3;
        }
        return 1;
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        private List projects;
        private boolean deleteContent = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            final /* synthetic */ DeleteProjectDialog this$1;
            {
                this.this$1 = deleteProjectDialog;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DeleteProjectDialog.access$1(this.this$1, button == DeleteProjectDialog.access$0(this.this$1));
                }
            }
        };

        DeleteProjectDialog(Shell parentShell, List projects) {
            super(parentShell, DeleteProjectDialog.getTitle(projects), null, DeleteProjectDialog.getMessage(projects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.projects = projects;
        }

        static String getTitle(List projects) {
            if (projects.size() == 1) {
                return IDEWorkbenchMessages.getString("DeleteResourceAction.titleProject1");
            }
            return IDEWorkbenchMessages.getString("DeleteResourceAction.titleProjectN");
        }

        static String getMessage(List projects) {
            if (projects.size() == 1) {
                IProject project = (IProject)projects.get(0);
                return IDEWorkbenchMessages.format("DeleteResourceAction.confirmProject1", new Object[]{project.getName()});
            }
            return IDEWorkbenchMessages.format("DeleteResourceAction.confirmProjectN", new Object[]{new Integer(projects.size())});
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.ui.ide.delete_project_dialog_context");
        }

        protected Control createCustomArea(Composite parent) {
            IProject project;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = this.projects.size() == 1 ? ((project = (IProject)this.projects.get(0)) == null || project.getLocation() == null ? IDEWorkbenchMessages.getString("DeleteResourceAction.deleteContentsN") : IDEWorkbenchMessages.format("DeleteResourceAction.deleteContents1", new Object[]{project.getLocation().toOSString()})) : IDEWorkbenchMessages.getString("DeleteResourceAction.deleteContentsN");
            this.radio1.setText(text1);
            this.radio1.setFont(parent.getFont());
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = IDEWorkbenchMessages.getString("DeleteResourceAction.doNotDeleteContents");
            this.radio2.setText(text2);
            this.radio2.setFont(parent.getFont());
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }

        static /* synthetic */ Button access$0(DeleteProjectDialog deleteProjectDialog) {
            return deleteProjectDialog.radio1;
        }

        static /* synthetic */ void access$1(DeleteProjectDialog deleteProjectDialog, boolean bl) {
            deleteProjectDialog.deleteContent = bl;
        }
    }
}

