/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class BuildAction
extends WorkspaceAction {
    public static final String ID_BUILD = "org.eclipse.ui.BuildAction";
    public static final String ID_REBUILD_ALL = "org.eclipse.ui.RebuildAllAction";
    private int buildType;
    private List projectsToBuild = null;

    public BuildAction(Shell shell, int type) {
        super(shell, "");
        if (type == 10) {
            this.setText(IDEWorkbenchMessages.getString("BuildAction.text"));
            this.setToolTipText(IDEWorkbenchMessages.getString("BuildAction.toolTip"));
            this.setId(ID_BUILD);
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.incremental_build_action_context");
        } else {
            this.setText(IDEWorkbenchMessages.getString("RebuildAction.text"));
            this.setToolTipText(IDEWorkbenchMessages.getString("RebuildAction.tooltip"));
            this.setId(ID_REBUILD_ALL);
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.full_build_action_context");
        }
        this.buildType = type;
    }

    protected List getActionResources() {
        return this.getProjectsToBuild();
    }

    String getOperationMessage() {
        return IDEWorkbenchMessages.getString("BuildAction.operationMessage");
    }

    String getProblemsMessage() {
        return IDEWorkbenchMessages.getString("BuildAction.problemMessage");
    }

    String getProblemsTitle() {
        return IDEWorkbenchMessages.getString("BuildAction.problemTitle");
    }

    List getProjectsToBuild() {
        if (this.projectsToBuild == null) {
            this.projectsToBuild = new ArrayList(3);
            Iterator i = this.getSelectedResources().iterator();
            while (i.hasNext()) {
                IResource resource = (IResource)i.next();
                IProject project = resource.getProject();
                if (project == null || this.projectsToBuild.contains(project) || !this.hasBuilder(project)) continue;
                this.projectsToBuild.add(project);
            }
        }
        return this.projectsToBuild;
    }

    boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).build(this.buildType, monitor);
    }

    public static boolean isSaveAllSet() {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("SAVE_ALL_BEFORE_BUILD");
    }

    List pruneResources(List resourceCollection) {
        if (resourceCollection.size() < 2) {
            return resourceCollection;
        }
        String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (orderedNames != null) {
            ArrayList<Object> orderedProjects = new ArrayList<Object>(resourceCollection.size());
            ArrayList unorderedProjects = new ArrayList(resourceCollection.size());
            unorderedProjects.addAll(resourceCollection);
            int i = 0;
            while (i < orderedNames.length) {
                String projectName = orderedNames[i];
                int j = 0;
                while (j < resourceCollection.size()) {
                    IProject project = (IProject)resourceCollection.get(j);
                    if (project.getName().equals(projectName)) {
                        orderedProjects.add(project);
                        unorderedProjects.remove(project);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            orderedProjects.addAll(unorderedProjects);
            return orderedProjects;
        }
        IProject[] projects = new IProject[resourceCollection.size()];
        projects = resourceCollection.toArray(projects);
        IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
        ArrayList<IProject> orderedProjects = new ArrayList<IProject>();
        orderedProjects.addAll(Arrays.asList(po.projects));
        return orderedProjects;
    }

    public void run() {
        this.saveAllResources();
        super.run();
    }

    void saveAllResources() {
        List projects = this.getSelectedResources();
        if (projects == null || projects.isEmpty()) {
            return;
        }
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] editors = page.getDirtyEditors();
                int k = 0;
                while (k < editors.length) {
                    IFile inputFile;
                    IEditorPart editor = editors[k];
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IFileEditorInput && projects.contains((inputFile = ((IFileEditorInput)input).getFile()).getProject())) {
                        page.saveEditor(editor, false);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    boolean shouldPerformResourcePruning() {
        return true;
    }

    protected boolean updateSelection(IStructuredSelection s) {
        this.projectsToBuild = null;
        return super.updateSelection(s) && this.getProjectsToBuild().size() > 0;
    }
}

