/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileLock;
import org.eclipse.help.internal.standalone.Eclipse;
import org.eclipse.help.internal.standalone.EclipseConnection;
import org.eclipse.help.internal.standalone.EclipseLifeCycleListener;
import org.eclipse.help.internal.standalone.Options;

public class EclipseController
implements EclipseLifeCycleListener {
    private static final String CONTROL_SERVLET_PATH = "/helpControl/control.html";
    protected String applicationId;
    protected EclipseConnection connection;
    public Eclipse eclipse = null;
    private FileLock lock;
    private boolean eclipseEnded = false;

    public EclipseController(String applicationId, String[] args) {
        this.applicationId = applicationId;
        Options.init(applicationId, args);
        this.connection = new EclipseConnection();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void shutdown() throws Exception {
        try {
            try {
                this.obtainLock();
                this.sendHelpCommandInternal("shutdown", new String[0]);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.releaseLock();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.releaseLock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void start() throws Exception {
        try {
            this.obtainLock();
            this.startEclipse();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.releaseLock();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.releaseLock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void sendHelpCommand(String command, String[] parameters) throws Exception {
        try {
            this.obtainLock();
            this.sendHelpCommandInternal(command, parameters);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.releaseLock();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.releaseLock();
            return;
        }
    }

    private void startEclipse() throws Exception {
        boolean fullyRunning = this.isApplicationRunning();
        if (fullyRunning) {
            return;
        }
        if (Options.isDebug()) {
            System.out.println("Using workspace " + Options.getWorkspace().getAbsolutePath());
        }
        Options.getConnectionFile().delete();
        this.connection.reset();
        if (Options.isDebug()) {
            System.out.println("Ensured old .connection file is deleted.  Launching Eclipse.");
        }
        this.eclipseEnded = false;
        this.eclipse = new Eclipse(this);
        this.eclipse.start();
        fullyRunning = this.isApplicationRunning();
        while (!this.eclipseEnded && !fullyRunning) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            fullyRunning = this.isApplicationRunning();
        }
        if (this.eclipseEnded) {
            if (this.eclipse.getStatus() == 2) {
                throw this.eclipse.getException();
            }
            return;
        }
        if (Options.isDebug()) {
            System.out.println("Eclipse launched");
        }
        Runtime.getRuntime().addShutdownHook(new EclipseCleaner());
    }

    private void sendHelpCommandInternal(String command, String[] parameters) throws Exception {
        block8: {
            if (!"shutdown".equalsIgnoreCase(command)) {
                this.startEclipse();
            }
            if (!this.isApplicationRunning()) {
                return;
            }
            if (!this.connection.isValid()) {
                this.connection.renew();
            }
            try {
                URL url = this.createCommandURL(command, parameters);
                if ("shutdown".equalsIgnoreCase(command) && Options.getConnectionFile().exists()) {
                    this.connection.connect(url);
                    long timeLimit = System.currentTimeMillis() + 60000L;
                    while (Options.getConnectionFile().exists()) {
                        Thread.sleep(200L);
                        if (System.currentTimeMillis() <= timeLimit) continue;
                        System.out.println("Shutting down is taking too long.  Will not wait.");
                        break block8;
                    }
                    break block8;
                }
                this.connection.connect(url);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private URL createCommandURL(String command, String[] parameters) throws MalformedURLException {
        StringBuffer urlStr = new StringBuffer();
        urlStr.append("http://");
        urlStr.append(this.connection.getHost());
        urlStr.append(":");
        urlStr.append(this.connection.getPort());
        urlStr.append(CONTROL_SERVLET_PATH);
        urlStr.append("?command=");
        urlStr.append(command);
        int i = 0;
        while (i < parameters.length) {
            urlStr.append("&");
            urlStr.append(parameters[i]);
            ++i;
        }
        if (Options.isDebug()) {
            System.out.println("Control servlet URL=" + urlStr.toString());
        }
        return new URL(urlStr.toString());
    }

    public void eclipseEnded() {
        this.connection.reset();
    }

    private void obtainLock() throws IOException {
        if (this.lock != null) {
            return;
        }
        if (!Options.getLockFile().exists()) {
            Options.getLockFile().getParentFile().mkdirs();
        }
        RandomAccessFile raf = new RandomAccessFile(Options.getLockFile(), "rw");
        this.lock = raf.getChannel().lock();
        if (Options.isDebug()) {
            System.out.println("Lock obtained.");
        }
    }

    private void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
                if (Options.isDebug()) {
                    System.out.println("Lock released.");
                }
                this.lock = null;
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isApplicationRunning() {
        FileLock applicationLock;
        RandomAccessFile randomAccessFile;
        block18: {
            File applicationLockFile = new File(Options.getLockFile().getParentFile(), ".applicationlock");
            randomAccessFile = null;
            applicationLock = null;
            try {
                try {
                    randomAccessFile = new RandomAccessFile(applicationLockFile, "rw");
                    applicationLock = randomAccessFile.getChannel().tryLock();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (applicationLock != null) {
                    try {
                        applicationLock.release();
                    }
                    catch (IOException iOException) {}
                }
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                }
                if (Options.isDebug()) {
                    System.out.println("isApplicationRunning? " + (applicationLock == null));
                }
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (applicationLock == null) break block18;
            }
            try {}
            catch (IOException iOException) {}
            applicationLock.release();
        }
        if (randomAccessFile != null) {
            try {}
            catch (IOException iOException) {}
            randomAccessFile.close();
        }
        if (Options.isDebug()) {
            System.out.println("isApplicationRunning? " + (applicationLock == null));
        }
        return applicationLock == null;
    }

    public class EclipseCleaner
    extends Thread {
        public void run() {
            if (EclipseController.this.eclipse != null) {
                EclipseController.this.eclipse.killProcess();
            }
        }
    }
}

