/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Hits;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;

public class SearchProgressMonitor
implements IProgressMonitor {
    protected static Map progressMonitors = new HashMap();
    protected static ISearchHitCollector dummy_collector = new ISearchHitCollector(){

        public void addHits(Hits h, String s) {
        }
    };
    private boolean started = false;
    private boolean done = false;
    private boolean canceled = false;
    private int totalWork = -1;
    private int currWork;

    public void beginTask(String name, int totalWork) {
        this.totalWork = totalWork;
        this.started = true;
    }

    public void done() {
        this.currWork = this.totalWork;
        this.done = true;
        this.started = true;
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
    }

    public void worked(int work) {
        this.currWork += work;
        if (this.currWork > this.totalWork) {
            this.currWork = this.totalWork;
        } else if (this.currWork < 0) {
            this.currWork = 0;
        }
    }

    public void internalWorked(double work) {
    }

    public int getPercentage() {
        if (this.done) {
            return 100;
        }
        if (this.totalWork == -1) {
            return 0;
        }
        if (this.currWork >= this.totalWork) {
            return 100;
        }
        return 100 * this.currWork / this.totalWork;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCancelled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public static synchronized SearchProgressMonitor getProgressMonitor(final String locale) {
        if (progressMonitors.get(locale) != null) {
            return (SearchProgressMonitor)progressMonitors.get(locale);
        }
        final SearchProgressMonitor pm = new SearchProgressMonitor();
        progressMonitors.put(locale, pm);
        Thread indexer = new Thread(new Runnable(){

            public void run() {
                block3: {
                    try {
                        BaseHelpSystem.getSearchManager().search(new DummySearchQuery(locale), dummy_collector, pm);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        progressMonitors.remove(locale);
                    }
                    catch (Exception e) {
                        progressMonitors.remove(locale);
                        if (!BootLoader.isRunning()) break block3;
                        HelpBasePlugin.logError(HelpBaseResources.getString("search_index_update_error"), e);
                    }
                }
            }
        });
        indexer.setName("HelpSearchIndexer");
        indexer.start();
        while (!pm.isStarted()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            if (progressMonitors.get(locale) == null) break;
        }
        return pm;
    }

    static class DummySearchQuery
    implements ISearchQuery {
        private String l;

        DummySearchQuery(String loc) {
            this.l = loc;
        }

        public Collection getFieldNames() {
            return new ArrayList();
        }

        public String getSearchWord() {
            return "dummy";
        }

        public boolean isFieldSearch() {
            return false;
        }

        public String getLocale() {
            return this.l;
        }
    }
}

