/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.IndexingOperation;
import org.eclipse.help.internal.search.ProgressDistributor;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchIndex;

public class SearchManager {
    private Map indexes = new HashMap();
    private Map analyzerDescriptors = new HashMap();
    private Map progressDistibutors = new HashMap();

    public SearchIndex getIndex(String locale) {
        Map map = this.indexes;
        synchronized (map) {
            Object index = this.indexes.get(locale);
            if (index == null) {
                index = new SearchIndex(locale, this.getAnalyzer(locale));
                this.indexes.put(locale, index);
            }
            return (SearchIndex)index;
        }
    }

    private ProgressDistributor getProgressDistributor(SearchIndex index) {
        Map map = this.progressDistibutors;
        synchronized (map) {
            Object distributor = this.progressDistibutors.get(index);
            if (distributor == null) {
                distributor = new ProgressDistributor();
                this.progressDistibutors.put(index, distributor);
            }
            return (ProgressDistributor)distributor;
        }
    }

    private AnalyzerDescriptor getAnalyzer(String locale) {
        AnalyzerDescriptor analyzerDesc = (AnalyzerDescriptor)this.analyzerDescriptors.get(locale);
        if (analyzerDesc != null) {
            return analyzerDesc;
        }
        analyzerDesc = new AnalyzerDescriptor(locale);
        this.analyzerDescriptors.put(locale, analyzerDesc);
        String lang = analyzerDesc.getLang();
        if (locale != null && !locale.equals(lang)) {
            this.analyzerDescriptors.put(lang, analyzerDesc);
        }
        return analyzerDesc;
    }

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        SearchIndex index;
        block3: {
            index = this.getIndex(searchQuery.getLocale());
            try {
                this.updateIndex(pm, index);
                if (!index.exists()) {
                    return;
                }
            }
            catch (IndexingOperation.IndexingException indexingException) {
                if (!HelpBasePlugin.DEBUG_SEARCH) break block3;
                System.out.println(String.valueOf(this.getClass().getName()) + " IndexUpdateException occured.");
            }
        }
        index.search(searchQuery, collector);
    }

    private boolean isIndexingNeeded(SearchIndex index) {
        if (!index.exists()) {
            return true;
        }
        return index.getDocPlugins().detectChange();
    }

    /*
     * Exception decompiling
     */
    public void updateIndex(IProgressMonitor pm, SearchIndex index) throws OperationCanceledException, IndexingOperation.IndexingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [7 : 200->204)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() {
        Iterator it = this.indexes.values().iterator();
        while (it.hasNext()) {
            ((SearchIndex)it.next()).close();
        }
    }
}

