/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.util.HelpProperties;

public class PluginVersionInfo
extends HelpProperties {
    static final String SEPARATOR = "\n";
    Plugin basePlugin = HelpBasePlugin.getDefault();
    boolean doComparison = true;
    boolean hasChanged = false;
    boolean ignoreSavedVersions;
    Collection added = new ArrayList<E>();
    Collection removed = new ArrayList<E>();

    /*
     * Unable to fully structure code
     */
    public PluginVersionInfo(String name, Iterator it, Plugin basePlugin, boolean ignoreSavedVersions) {
        super(name, basePlugin);
        this.basePlugin = basePlugin;
        this.ignoreSavedVersions = ignoreSavedVersions;
        if (it != null) ** GOTO lbl34
        return;
lbl-1000:
        // 1 sources

        {
            plugin = (IPluginDescriptor)it.next();
            pluginVersionAndFragments = new StringBuffer();
            pluginVersionAndFragments.append(plugin.getUniqueIdentifier());
            pluginVersionAndFragments.append("\n");
            pluginVersionAndFragments.append(plugin.getVersionIdentifier().toString());
            if (plugin instanceof PluginDescriptorModel && (fragmentModels = ((PluginDescriptorModel)plugin).getFragments()) != null) {
                f = 0;
                while (f < fragmentModels.length) {
                    pluginVersionAndFragments.append("\n");
                    pluginVersionAndFragments.append(fragmentModels[f].getId());
                    pluginVersionAndFragments.append("\n");
                    pluginVersionAndFragments.append(fragmentModels[f].getVersion());
                    ++f;
                }
            }
            this.put(plugin.getUniqueIdentifier(), pluginVersionAndFragments.toString());
lbl34:
            // 2 sources

            ** while (it.hasNext())
        }
lbl35:
        // 1 sources

    }

    public boolean detectChange() {
        String oldVersions;
        String versions;
        String oneContr;
        if (!this.doComparison) {
            return this.hasChanged;
        }
        HelpProperties oldContrs = new HelpProperties(this.name, this.basePlugin);
        if (!this.ignoreSavedVersions) {
            oldContrs.restore();
        }
        this.hasChanged = false;
        Enumeration<Object> keysEnum = this.keys();
        while (keysEnum.hasMoreElements()) {
            oneContr = (String)keysEnum.nextElement();
            if (!oldContrs.containsKey(oneContr)) {
                this.added.add(oneContr);
                continue;
            }
            versions = (String)this.get(oneContr);
            if (this.compare(versions, oldVersions = (String)oldContrs.get(oneContr))) continue;
            this.added.add(oneContr);
        }
        keysEnum = oldContrs.keys();
        while (keysEnum.hasMoreElements()) {
            oneContr = (String)keysEnum.nextElement();
            if (!this.containsKey(oneContr)) {
                this.removed.add(oneContr);
                continue;
            }
            versions = (String)this.get(oneContr);
            if (this.compare(versions, oldVersions = (String)oldContrs.get(oneContr))) continue;
            this.removed.add(oneContr);
        }
        this.hasChanged = this.added.size() > 0 || this.removed.size() > 0;
        this.doComparison = false;
        return this.hasChanged;
    }

    public Collection getAdded() {
        if (this.doComparison) {
            this.detectChange();
        }
        return this.added;
    }

    public Collection getRemoved() {
        if (this.doComparison) {
            this.detectChange();
        }
        return this.removed;
    }

    public boolean save() {
        if (super.save()) {
            this.doComparison = false;
            this.hasChanged = false;
            this.ignoreSavedVersions = false;
            this.added = new ArrayList();
            this.removed = new ArrayList();
            return true;
        }
        return false;
    }

    private boolean compare(String versions, String oldVersions) {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        StringTokenizer t = new StringTokenizer(versions, SEPARATOR, false);
        while (t.hasMoreTokens()) {
            String pluginOrFragment = t.nextToken();
            if (!t.hasMoreTokens()) continue;
            versionMap.put(pluginOrFragment, t.nextToken());
        }
        HashMap<String, String> oldVersionMap = new HashMap<String, String>();
        StringTokenizer t2 = new StringTokenizer(oldVersions, SEPARATOR, false);
        while (t2.hasMoreTokens()) {
            String pluginOrFragment = t2.nextToken();
            if (!t2.hasMoreTokens()) continue;
            oldVersionMap.put(pluginOrFragment, t2.nextToken());
        }
        return versionMap.equals(oldVersionMap);
    }
}

