/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.Reader;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.search.WordTokenStream;

public class DefaultAnalyzer
extends Analyzer {
    private Locale locale;

    public DefaultAnalyzer(String localeString) {
        int i;
        Locale userLocale = this.getLocale(localeString);
        Locale[] availableLocales = BreakIterator.getAvailableLocales();
        int i2 = 0;
        while (i2 < availableLocales.length) {
            if (userLocale.equals(availableLocales[i2])) {
                this.locale = userLocale;
                break;
            }
            ++i2;
        }
        if (this.locale == null && userLocale.getDisplayVariant().length() > 0) {
            Locale countryLocale = new Locale(userLocale.getLanguage(), userLocale.getCountry());
            i = 0;
            while (i < availableLocales.length) {
                if (countryLocale.equals(availableLocales[i])) {
                    this.locale = countryLocale;
                    break;
                }
                ++i;
            }
        }
        if (this.locale == null && userLocale.getCountry().length() > 0) {
            Locale language = new Locale(userLocale.getLanguage(), "");
            i = 0;
            while (i < availableLocales.length) {
                if (language.equals(availableLocales[i])) {
                    this.locale = language;
                    break;
                }
                ++i;
            }
        }
        if (this.locale == null) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES24", localeString), null);
            this.locale = new Locale("en", "US");
        }
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return new LowerCaseFilter((TokenStream)new WordTokenStream(fieldName, reader, this.locale));
    }

    private Locale getLocale(String clientLocale) {
        StringTokenizer locales;
        if (clientLocale == null) {
            clientLocale = BootLoader.getNL();
        }
        if (clientLocale == null) {
            clientLocale = Locale.getDefault().toString();
        }
        if ((locales = new StringTokenizer(clientLocale, "_")).countTokens() == 1) {
            return new Locale(locales.nextToken(), "");
        }
        if (locales.countTokens() == 2) {
            return new Locale(locales.nextToken(), locales.nextToken());
        }
        if (locales.countTokens() == 3) {
            return new Locale(locales.nextToken(), locales.nextToken(), locales.nextToken());
        }
        return Locale.getDefault();
    }
}

