/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.browser.IBrowserFactory;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.browser.BrowserDescriptor;
import org.eclipse.help.internal.browser.CurrentBrowser;

public class BrowserManager {
    public static final String DEFAULT_BROWSER_ID_KEY = "default_browser";
    private static BrowserManager instance;
    private boolean initialized = false;
    private BrowserDescriptor currentBrowserDesc;
    private BrowserDescriptor defaultBrowserDesc;
    private BrowserDescriptor[] browsersDescriptors;
    private Collection browsers = new ArrayList();

    private BrowserManager() {
    }

    private void init() {
        String curBrowserID;
        this.initialized = true;
        this.browsersDescriptors = this.createBrowserDescriptors();
        String defBrowserID = HelpBasePlugin.getDefault().getPluginPreferences().getDefaultString(DEFAULT_BROWSER_ID_KEY);
        if (defBrowserID != null && !"".equals(defBrowserID)) {
            this.setDefaultBrowserID(defBrowserID);
        }
        if (this.defaultBrowserDesc == null) {
            this.setDefaultBrowserID("org.eclipse.help.ui.embeddedbrowser");
        }
        if (this.defaultBrowserDesc == null) {
            if (System.getProperty("os.name").startsWith("Win")) {
                this.setDefaultBrowserID("org.eclipse.help.ui.systembrowser");
            } else if (System.getProperty("os.name").startsWith("Linux")) {
                this.setDefaultBrowserID("org.eclipse.help.base.mozillaLinux");
                if (this.defaultBrowserDesc == null) {
                    this.setDefaultBrowserID("org.eclipse.help.base.netscapeLinux");
                }
            } else if (System.getProperty("os.name").startsWith("SunOS")) {
                this.setDefaultBrowserID("org.eclipse.help.base.netscapeSolaris");
            } else if (System.getProperty("os.name").startsWith("AIX")) {
                this.setDefaultBrowserID("org.eclipse.help.base.netscapeAIX");
            } else if (System.getProperty("os.name").toLowerCase().startsWith("hp")) {
                this.setDefaultBrowserID("org.eclipse.help.base.mozillaHPUX");
                if (this.defaultBrowserDesc == null) {
                    this.setDefaultBrowserID("org.eclipse.help.base.netscapeHPUX");
                }
            } else if (System.getProperty("os.name").equals("Mac OS X")) {
                this.setDefaultBrowserID("org.eclipse.help.base.defaultBrowserMacOSX");
            } else {
                this.setDefaultBrowserID("org.eclipse.help.base.mozillaLinux");
            }
        }
        if (this.defaultBrowserDesc == null) {
            int i = 0;
            while (i < this.browsersDescriptors.length) {
                if ("org.eclipse.help.base.custombrowser".equals(this.browsersDescriptors[i].getID())) {
                    this.defaultBrowserDesc = this.browsersDescriptors[i];
                }
                ++i;
            }
        }
        if (this.defaultBrowserDesc == null) {
            this.setDefaultBrowserID("org.eclipse.help.base.custombrowser");
        }
        if (this.defaultBrowserDesc == null) {
            this.defaultBrowserDesc = new BrowserDescriptor("", "Null Browser", new IBrowserFactory(){

                public boolean isAvailable() {
                    return true;
                }

                public IBrowser createBrowser() {
                    return new IBrowser(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void close() {
                        }

                        public void displayURL(String url) {
                            String msg = HelpBaseResources.getString("no_browsers", url);
                            HelpBasePlugin.logError(msg, null);
                            BaseHelpSystem.getDefaultErrorUtil().displayError(msg);
                        }

                        public boolean isCloseSupported() {
                            return false;
                        }

                        public boolean isSetLocationSupported() {
                            return false;
                        }

                        public boolean isSetSizeSupported() {
                            return false;
                        }

                        public void setLocation(int width, int height) {
                        }

                        public void setSize(int x, int y) {
                        }
                    };
                }
            });
        }
        if ((curBrowserID = HelpBasePlugin.getDefault().getPluginPreferences().getString(DEFAULT_BROWSER_ID_KEY)) != null && !"".equals(curBrowserID)) {
            this.setCurrentBrowserID(curBrowserID);
        }
        if (this.currentBrowserDesc == null) {
            this.setCurrentBrowserID(this.getDefaultBrowserID());
        }
    }

    public static BrowserManager getInstance() {
        if (instance == null) {
            instance = new BrowserManager();
        }
        return instance;
    }

    private BrowserDescriptor[] createBrowserDescriptors() {
        if (this.browsersDescriptors != null) {
            return this.browsersDescriptors;
        }
        ArrayList<BrowserDescriptor> bDescriptors = new ArrayList<BrowserDescriptor>();
        IConfigurationElement[] configElements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.help.base", "browser");
        int i = 0;
        while (i < configElements.length) {
            String label;
            String id;
            if (configElements[i].getName().equals("browser") && (id = configElements[i].getAttribute("id")) != null && (label = configElements[i].getAttribute("name")) != null) {
                try {
                    Object adapter = configElements[i].createExecutableExtension("factoryclass");
                    if (adapter instanceof IBrowserFactory && ((IBrowserFactory)adapter).isAvailable()) {
                        bDescriptors.add(new BrowserDescriptor(id, label, (IBrowserFactory)adapter));
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        this.browsersDescriptors = bDescriptors.toArray(new BrowserDescriptor[bDescriptors.size()]);
        return this.browsersDescriptors;
    }

    public BrowserDescriptor[] getBrowserDescriptors() {
        if (!this.initialized) {
            this.init();
        }
        return this.browsersDescriptors;
    }

    public String getCurrentBrowserID() {
        if (!this.initialized) {
            this.init();
        }
        if (this.currentBrowserDesc == null) {
            return null;
        }
        return this.currentBrowserDesc.getID();
    }

    public String getDefaultBrowserID() {
        if (!this.initialized) {
            this.init();
        }
        if (this.defaultBrowserDesc == null) {
            return null;
        }
        return this.defaultBrowserDesc.getID();
    }

    public void setCurrentBrowserID(String currentAdapterID) {
        if (!this.initialized) {
            this.init();
        }
        int i = 0;
        while (i < this.browsersDescriptors.length) {
            if (this.browsersDescriptors[i].getID().equals(currentAdapterID)) {
                this.currentBrowserDesc = this.browsersDescriptors[i];
                return;
            }
            ++i;
        }
    }

    private void setDefaultBrowserID(String defaultAdapterID) {
        if (!this.initialized) {
            this.init();
        }
        int i = 0;
        while (i < this.browsersDescriptors.length) {
            if (this.browsersDescriptors[i].getID().equals(defaultAdapterID)) {
                this.defaultBrowserDesc = this.browsersDescriptors[i];
                return;
            }
            ++i;
        }
    }

    public IBrowser createBrowser() {
        if (!this.initialized) {
            this.init();
        }
        return new CurrentBrowser(this.createBrowserAdapter(), this.getCurrentBrowserID());
    }

    private IBrowser createBrowserAdapter() {
        IBrowser browser = this.currentBrowserDesc.getFactory().createBrowser();
        this.browsers.add(browser);
        return browser;
    }

    public void closeAll() {
        if (!this.initialized) {
            return;
        }
        Iterator it = this.browsers.iterator();
        while (it.hasNext()) {
            IBrowser browser = (IBrowser)it.next();
            browser.close();
        }
    }
}

