/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.IHelpActivitySupport;

public class HelpBasePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.help.base";
    public static boolean DEBUG = false;
    public static boolean DEBUG_SEARCH = false;
    protected static HelpBasePlugin plugin;
    private IHelpActivitySupport helpActivitySupport = new IHelpActivitySupport(){

        public boolean isEnabled(String href) {
            return true;
        }

        public void enableActivities(String href) {
        }
    };

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpBasePlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logWarning(String message) {
        if (DEBUG) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, null);
            HelpBasePlugin.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public HelpBasePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static HelpBasePlugin getDefault() {
        return plugin;
    }

    public void shutdown() throws CoreException {
        BaseHelpSystem.shutdown();
    }

    public void startup() throws CoreException {
        DEBUG = this.isDebugging();
        if (DEBUG) {
            DEBUG_SEARCH = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help.base/debug/search"));
        }
        BaseHelpSystem.startup();
    }

    protected void initializeDefaultPluginPreferences() {
        boolean isWindows;
        Preferences prefs = this.getPluginPreferences();
        String os = System.getProperty("os.name").toLowerCase();
        boolean bl = isWindows = os.indexOf("windows") != -1;
        if (isWindows) {
            prefs.setDefault("custom_browser_path", "\"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\" %1");
        } else {
            prefs.setDefault("custom_browser_path", "mozilla %1");
        }
    }

    public static IHelpActivitySupport getActivitySupport() {
        return HelpBasePlugin.getDefault().helpActivitySupport;
    }

    public static void setActivitySupport(IHelpActivitySupport activitySupport) {
        HelpBasePlugin.getDefault().helpActivitySupport = activitySupport;
    }
}

