/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;

public class HelpApplication
implements IPlatformRunnable,
IExecutableExtension {
    private static final String APPLICATION_LOCK_FILE = ".applicationlock";
    private static final int STATUS_EXITTING = 0;
    private static final int STATUS_RESTARTING = 2;
    private static final int STATUS_RUNNING = 1;
    private static int status = 1;
    private File metadata;
    private FileLock lock;

    public static void stop() {
        status = 0;
    }

    public static void restart() {
        if (status != 0) {
            status = 2;
        }
    }

    public Object run(Object args) throws Exception {
        if (status == 2) {
            return IPlatformRunnable.EXIT_RESTART;
        }
        this.metadata = new File(Platform.getLocation().toFile(), ".metadata/");
        if (!BaseHelpSystem.ensureWebappRunning()) {
            System.out.println("Help web application could not start.  Check log file for details.");
            return IPlatformRunnable.EXIT_OK;
        }
        if (status == 2) {
            return IPlatformRunnable.EXIT_RESTART;
        }
        this.writeHostAndPort();
        this.obtainLock();
        while (status == 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        this.releaseLock();
        if (status == 2) {
            return IPlatformRunnable.EXIT_RESTART;
        }
        return IPlatformRunnable.EXIT_OK;
    }

    public void setInitializationData(IConfigurationElement configElement, String propertyName, Object data) {
        String value = (String)((Map)data).get("mode");
        if ("infocenter".equalsIgnoreCase(value)) {
            BaseHelpSystem.setMode(1);
        } else if ("standalone".equalsIgnoreCase(value)) {
            BaseHelpSystem.setMode(2);
        }
    }

    /*
     * Exception decompiling
     */
    private void writeHostAndPort() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 103->107)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void obtainLock() {
        File lockFile = new File(this.metadata, APPLICATION_LOCK_FILE);
        try {
            RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
            this.lock = raf.getChannel().lock();
        }
        catch (IOException iOException) {
            this.lock = null;
        }
    }

    private void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
            }
            catch (IOException iOException) {}
        }
    }
}

