/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.util.HashMap;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.appserver.WebappManager;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.HelpDisplay;
import org.eclipse.help.internal.base.util.IErrorUtil;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.internal.search.SearchManager;
import org.eclipse.help.internal.workingset.WorkingSetManager;

public final class BaseHelpSystem {
    protected static final BaseHelpSystem instance = new BaseHelpSystem();
    private static final String WEBAPP_EXTENSION_ID = "org.eclipse.help.base.webapp";
    private static final String WEBAPP_DEFAULT_ATTRIBUTE = "default";
    public static final String BOOKMARKS = "bookmarks";
    public static final String WORKING_SETS = "workingSets";
    public static final String WORKING_SET = "workingSet";
    public static final int MODE_WORKBENCH = 0;
    public static final int MODE_INFOCENTER = 1;
    public static final int MODE_STANDALONE = 2;
    protected SearchManager searchManager;
    protected HashMap workingSetManagers;
    private int mode = 0;
    private boolean webappStarted = false;
    private IErrorUtil defaultErrorMessenger;
    private IBrowser browser;
    private HelpDisplay helpDisplay = null;
    private boolean webappRunning = false;
    static /* synthetic */ Class class$0;

    private BaseHelpSystem() {
    }

    public static BaseHelpSystem getInstance() {
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchManager getSearchManager() {
        if (BaseHelpSystem.getInstance().searchManager != null) return BaseHelpSystem.getInstance().searchManager;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.help.internal.base.BaseHelpSystem;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (BaseHelpSystem.getInstance().searchManager != null) return BaseHelpSystem.getInstance().searchManager;
            BaseHelpSystem.getInstance().searchManager = new SearchManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return BaseHelpSystem.getInstance().searchManager;
        }
    }

    public static WorkingSetManager getWorkingSetManager() {
        return BaseHelpSystem.getWorkingSetManager(BootLoader.getNL());
    }

    public static synchronized WorkingSetManager getWorkingSetManager(String locale) {
        WorkingSetManager wsmgr;
        if (BaseHelpSystem.getInstance().workingSetManagers == null) {
            BaseHelpSystem.getInstance().workingSetManagers = new HashMap();
        }
        if ((wsmgr = (WorkingSetManager)BaseHelpSystem.getInstance().workingSetManagers.get(locale)) == null) {
            wsmgr = new WorkingSetManager(locale);
            BaseHelpSystem.getInstance().workingSetManagers.put(locale, wsmgr);
        }
        return wsmgr;
    }

    public static synchronized IBrowser getHelpBrowser() {
        if (BaseHelpSystem.getInstance().browser == null) {
            BaseHelpSystem.getInstance().browser = BrowserManager.getInstance().createBrowser();
        }
        return BaseHelpSystem.getInstance().browser;
    }

    public static synchronized HelpDisplay getHelpDisplay() {
        if (BaseHelpSystem.getInstance().helpDisplay == null) {
            BaseHelpSystem.getInstance().helpDisplay = new HelpDisplay();
        }
        return BaseHelpSystem.getInstance().helpDisplay;
    }

    public BaseHelpSystem newInstance() {
        return null;
    }

    public static void shutdown() throws CoreException {
        if (HelpBasePlugin.DEBUG) {
            System.out.println("Base Help System is shutting down.");
        }
        if (BaseHelpSystem.getInstance().searchManager != null) {
            BaseHelpSystem.getInstance().searchManager.close();
        }
        WebappManager.stop((String)"help");
        if (BaseHelpSystem.getMode() != 0) {
            WebappManager.stop((String)"helpControl");
        }
        BrowserManager.getInstance().closeAll();
        if (HelpBasePlugin.DEBUG) {
            System.out.println("Help System is shut down.");
        }
    }

    public static void startup() {
        try {
            BaseHelpSystem.setDefaultErrorUtil(new IErrorUtil(){

                public void displayError(String msg) {
                    System.out.println(msg);
                }

                public void displayError(String msg, Thread uiThread) {
                    System.out.println(msg);
                }
            });
            HelpBasePlugin.getDefault().getPluginPreferences();
        }
        catch (Exception e) {
            HelpBasePlugin.getDefault().getLog().log((IStatus)new Status(4, HelpBasePlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, HelpBaseResources.getString("E005"), (Throwable)e));
        }
        if (HelpBasePlugin.DEBUG) {
            System.out.println("Base Help System started.");
        }
    }

    public static boolean ensureWebappRunning() {
        if (!BaseHelpSystem.getInstance().webappStarted) {
            BaseHelpSystem.getInstance().webappStarted = true;
            String webappPlugin = BaseHelpSystem.getWebappPlugin();
            if (BaseHelpSystem.getMode() != 0) {
                try {
                    WebappManager.start((String)"helpControl", (String)webappPlugin, (IPath)Path.EMPTY);
                }
                catch (CoreException e) {
                    HelpBasePlugin.logError(HelpBaseResources.getString("E042"), e);
                    return false;
                }
            }
            try {
                WebappManager.start((String)"help", (String)webappPlugin, (IPath)Path.EMPTY);
            }
            catch (CoreException e) {
                HelpBasePlugin.logError(HelpBaseResources.getString("E043"), e);
                return false;
            }
            BaseHelpSystem.getInstance().webappRunning = true;
        }
        return BaseHelpSystem.getInstance().webappRunning;
    }

    public static int getMode() {
        return BaseHelpSystem.getInstance().mode;
    }

    public static void setMode(int mode) {
        BaseHelpSystem.getInstance().mode = mode;
    }

    public static void setDefaultErrorUtil(IErrorUtil em) {
        BaseHelpSystem.getInstance().defaultErrorMessenger = em;
    }

    public static IErrorUtil getDefaultErrorUtil() {
        return BaseHelpSystem.getInstance().defaultErrorMessenger;
    }

    private static String getWebappPlugin() {
        IExtension[] extensions;
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(WEBAPP_EXTENSION_ID);
        if (point != null && (extensions = point.getExtensions()).length != 0) {
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String defaultValue = elements[i].getAttribute(WEBAPP_DEFAULT_ATTRIBUTE);
                if (defaultValue == null || defaultValue.equals("false")) {
                    return elements[i].getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                }
                ++i;
            }
            if (elements.length > 0) {
                return elements[0].getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
            }
        }
        return "org.eclipse.help.webapp";
    }

    public static String getProductName() {
        IPlatformConfiguration c = BootLoader.getCurrentPlatformConfiguration();
        String primaryFeatureId = c.getPrimaryFeatureIdentifier();
        if (primaryFeatureId == null) {
            return "";
        }
        IPluginDescriptor pfd = Platform.getPluginRegistry().getPluginDescriptor(primaryFeatureId);
        if (pfd == null) {
            return "";
        }
        return pfd.getLabel();
    }
}

