/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.ide;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.util.IErrorUtil;
import org.eclipse.help.internal.workingset.PropertyChange;
import org.eclipse.help.ui.internal.util.ErrorUtil;
import org.eclipse.help.ui.internal.workingset.HelpWorkingSetSynchronizer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class HelpIdePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.help.ide";
    public static boolean DEBUG = false;
    private static HelpIdePlugin plugin;
    private HelpWorkingSetSynchronizer workingSetListener;

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpBasePlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logWarning(String message) {
        if (HelpBasePlugin.DEBUG) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, null);
            HelpBasePlugin.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public HelpIdePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static HelpIdePlugin getDefault() {
        return plugin;
    }

    public void shutdown() throws CoreException {
        if (BaseHelpSystem.getMode() == 0) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this.workingSetListener);
            BaseHelpSystem.getWorkingSetManager().removePropertyChangeListener((PropertyChange.IPropertyChangeListener)this.workingSetListener);
        }
        super.shutdown();
    }

    public void startup() {
        DEBUG = this.isDebugging();
        BaseHelpSystem.setDefaultErrorUtil((IErrorUtil)new ErrorUtil());
        if (BaseHelpSystem.getMode() == 0) {
            this.workingSetListener = new HelpWorkingSetSynchronizer();
            PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this.workingSetListener);
            BaseHelpSystem.getWorkingSetManager().addPropertyChangeListener((PropertyChange.IPropertyChangeListener)this.workingSetListener);
        }
    }

    public HelpWorkingSetSynchronizer getWorkingSetSynchronizer() {
        return this.workingSetListener;
    }
}

