/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;

public class ReliableFileOutputStream
extends FilterOutputStream {
    private ReliableFile reliable;

    public ReliableFileOutputStream(File file) throws IOException {
        this(ReliableFile.getReliableFile(file), false);
    }

    public ReliableFileOutputStream(File file, boolean append) throws IOException {
        this(ReliableFile.getReliableFile(file), append);
    }

    public ReliableFileOutputStream(String name) throws IOException {
        this(ReliableFile.getReliableFile(name), false);
    }

    public ReliableFileOutputStream(String name, boolean append) throws IOException {
        this(ReliableFile.getReliableFile(name), append);
    }

    private ReliableFileOutputStream(ReliableFile reliable, boolean append) throws IOException {
        super(reliable.getOutputStream(append));
        this.reliable = reliable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws IOException {
        if (this.reliable == null) return;
        try {
            super.close();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.reliable.closeOutputFile();
            this.reliable = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.reliable.closeOutputFile();
        this.reliable = null;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }
}

