/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.eclipse.osgi.framework.internal.defaultadaptor.AdaptorMsg;

public class ReliableFile {
    public static final String tmpExt = ".tmp";
    public static final String oldExt = ".bak";
    public static final String newExt = ".new";
    private static Hashtable files = new Hashtable(30);
    private File orgFile;
    private File tmpFile;
    private File oldFile;
    private File newFile;
    private boolean locked;
    private int use;
    private static final int CP_BUF_SIZE = 4096;

    static ReliableFile getReliableFile(String name) throws IOException {
        return ReliableFile.getReliableFile(new File(name));
    }

    static ReliableFile getReliableFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new FileNotFoundException(AdaptorMsg.formatter.getString("RELIABLEFILE_FILE_IS_DIRECTORY"));
        }
        Hashtable hashtable = files;
        synchronized (hashtable) {
            ReliableFile reliable = (ReliableFile)files.get(file);
            if (reliable == null) {
                reliable = new ReliableFile(file);
                files.put(file, reliable);
            }
            ++reliable.use;
            return reliable;
        }
    }

    private void release() {
        Hashtable hashtable = files;
        synchronized (hashtable) {
            --this.use;
            if (this.use <= 0) {
                files.remove(this.orgFile);
            }
        }
    }

    private ReliableFile(File file) {
        String name = file.getPath();
        this.orgFile = file;
        this.tmpFile = new File(String.valueOf(name) + tmpExt);
        this.oldFile = new File(String.valueOf(name) + oldExt);
        this.newFile = new File(String.valueOf(name) + newExt);
        this.use = 0;
        this.locked = false;
    }

    synchronized InputStream getInputStream() throws IOException {
        try {
            this.lock();
        }
        catch (IOException e) {
            this.release();
            throw e;
        }
        try {
            this.recoverFile();
            return new FileInputStream(this.orgFile.getPath());
        }
        catch (IOException e) {
            this.unlock();
            this.release();
            throw e;
        }
    }

    void closeInputFile() throws IOException {
        this.unlock();
        this.release();
    }

    synchronized OutputStream getOutputStream(boolean append) throws IOException {
        try {
            this.lock();
        }
        catch (IOException e) {
            this.release();
            throw e;
        }
        try {
            if (append) {
                this.recoverFile();
                if (this.orgFile.exists()) {
                    ReliableFile.cp(this.orgFile, this.tmpFile);
                }
            }
            return new FileOutputStream(this.tmpFile.getPath(), append);
        }
        catch (IOException e) {
            this.unlock();
            this.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void closeOutputFile() throws IOException {
        try {
            boolean orgExists = this.orgFile.exists();
            boolean newExists = this.newFile.exists();
            if (newExists) {
                ReliableFile.rm(this.oldFile);
                ReliableFile.mv(this.newFile, this.oldFile);
            }
            ReliableFile.mv(this.tmpFile, this.newFile);
            if (orgExists) {
                if (newExists) {
                    ReliableFile.rm(this.orgFile);
                } else {
                    ReliableFile.rm(this.oldFile);
                    ReliableFile.mv(this.orgFile, this.oldFile);
                }
            }
            ReliableFile.mv(this.newFile, this.orgFile);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.unlock();
            this.release();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.unlock();
            this.release();
            return;
        }
    }

    private void recoverFile() throws IOException {
        boolean orgExists = this.orgFile.exists();
        boolean newExists = this.newFile.exists();
        boolean oldExists = this.oldFile.exists();
        if (newExists) {
            if (orgExists && !oldExists) {
                ReliableFile.mv(this.orgFile, this.oldFile);
            }
            ReliableFile.cp(this.newFile, this.orgFile);
            if (orgExists || oldExists) {
                ReliableFile.rm(this.newFile);
            } else {
                ReliableFile.mv(this.newFile, this.oldFile);
            }
        } else if (oldExists && !orgExists) {
            ReliableFile.cp(this.oldFile, this.orgFile);
        }
    }

    private void lock() throws IOException {
        if (this.locked) {
            throw new FileNotFoundException(AdaptorMsg.formatter.getString("RELIABLEFILE_FILE_LOCKED"));
        }
        this.locked = true;
    }

    private void unlock() {
        this.locked = false;
    }

    private static void mv(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException(AdaptorMsg.formatter.getString("RELIABLEFILE_RENAME_FAILED"));
        }
    }

    private static void cp(File from, File to) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(to);
            int length = (int)from.length();
            if (length > 0) {
                int count;
                if (length > 4096) {
                    length = 4096;
                }
                in = new FileInputStream(from);
                byte[] buffer = new byte[length];
                while ((count = in.read(buffer, 0, length)) > 0) {
                    out.write(buffer, 0, count);
                }
                in.close();
                in = null;
            }
            out.close();
            out = null;
        }
        catch (IOException e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
    }

    private static void rm(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException(AdaptorMsg.formatter.getString("RELIABLEFILE_DELETE_FAILED"));
        }
    }

    public static boolean exists(File file) {
        if (file.exists()) {
            return true;
        }
        String name = file.getPath();
        return new File(String.valueOf(name) + oldExt).exists() || new File(String.valueOf(name) + newExt).exists();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void delete() throws IOException {
        try {
            this.lock();
        }
        catch (IOException e) {
            this.release();
            throw e;
        }
        try {
            ReliableFile.rm(this.oldFile);
            ReliableFile.rm(this.orgFile);
            ReliableFile.rm(this.newFile);
            ReliableFile.rm(this.tmpFile);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.unlock();
            this.release();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.unlock();
            this.release();
            return;
        }
    }

    public static boolean delete(File file) {
        try {
            ReliableFile.getReliableFile(file).delete();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

