/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.defaultadaptor.BundleFile;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.osgi.framework.BundleException;

public class DefaultClassLoader
extends BundleClassLoader {
    protected DefaultBundleData hostdata;
    protected ClasspathEntry[] classpathEntries;
    protected Vector fragClasspaths;
    protected int buffersize = 8192;

    public DefaultClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath, DefaultBundleData bundledata) {
        this(delegate, domain, classpath, null, bundledata);
    }

    public DefaultClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath, ClassLoader parent, DefaultBundleData bundledata) {
        super(delegate, domain, classpath, parent);
        this.hostdata = bundledata;
        try {
            this.hostdata.open();
        }
        catch (IOException e) {
            this.hostdata.adaptor.getEventPublisher().publishFrameworkEvent(2, this.hostdata.getBundle(), (Throwable)e);
        }
    }

    public void initialize() {
        this.classpathEntries = this.buildClasspath(this.hostclasspath, this.hostdata, this.hostdomain);
    }

    public void attachFragment(BundleData bundledata, ProtectionDomain domain, String[] classpath) {
        DefaultBundleData defaultBundledata = (DefaultBundleData)bundledata;
        try {
            bundledata.open();
        }
        catch (IOException e) {
            defaultBundledata.adaptor.getEventPublisher().publishFrameworkEvent(2, defaultBundledata.getBundle(), (Throwable)e);
        }
        ClasspathEntry[] fragEntries = this.buildClasspath(classpath, defaultBundledata, domain);
        FragmentClasspath fragClasspath = new FragmentClasspath(fragEntries, defaultBundledata, domain);
        this.insertFragment(fragClasspath);
    }

    protected synchronized void insertFragment(FragmentClasspath fragClasspath) {
        if (this.fragClasspaths == null) {
            this.fragClasspaths = new Vector(10);
            this.fragClasspaths.addElement(fragClasspath);
            return;
        }
        int size = this.fragClasspaths.size();
        long fragID = fragClasspath.bundledata.id;
        int i = 0;
        while (i < size) {
            long otherID = ((FragmentClasspath)this.fragClasspaths.elementAt((int)i)).bundledata.id;
            if (fragID < otherID) {
                this.fragClasspaths.insertElementAt(fragClasspath, i);
                return;
            }
            ++i;
        }
        this.fragClasspaths.addElement(fragClasspath);
    }

    protected ClasspathEntry getClasspath(String cp, DefaultBundleData bundledata, ProtectionDomain domain) {
        Enumeration entries;
        BundleFile bundlefile = null;
        File file = bundledata.bundleFile.getFile(cp);
        if (file != null && file.exists()) {
            try {
                bundlefile = BundleFile.createBundleFile(file, bundledata);
            }
            catch (IOException e) {
                bundledata.adaptor.getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), (Throwable)e);
            }
        } else if (bundledata.bundleFile instanceof BundleFile.ZipBundleFile && (entries = bundledata.bundleFile.getEntryPaths(cp)).hasMoreElements()) {
            bundlefile = BundleFile.createBundleFile((BundleFile.ZipBundleFile)bundledata.bundleFile, cp);
        }
        if (bundlefile != null) {
            return new ClasspathEntry(bundlefile, domain);
        }
        return null;
    }

    protected synchronized Class findClass(String name) throws ClassNotFoundException {
        Class result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        int i = 0;
        while (i < this.classpathEntries.length) {
            if (this.classpathEntries[i] != null && (result = this.findClassImpl(name, this.classpathEntries[i].bundlefile, this.classpathEntries[i].domain)) != null) {
                return result;
            }
            ++i;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            int i2 = 0;
            while (i2 < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i2);
                int j = 0;
                while (j < fragCP.classpathEntries.length) {
                    result = this.findClassImpl(name, fragCP.classpathEntries[j].bundlefile, fragCP.classpathEntries[j].domain);
                    if (result != null) {
                        return result;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findClassImpl(String name, BundleFile bundleFile, ProtectionDomain bundledomain) {
        if (Debug.DEBUG_LOADER) {
            Debug.println((String)("BundleClassLoader[" + this.hostdata + "].findClass(" + name + ")"));
        }
        if ((entry = bundleFile.getEntry(filename = name.replace('.', '/').concat(".class"))) == null) {
            return null;
        }
        try {
            in = entry.getInputStream();
        }
        catch (IOException v0) {
            return null;
        }
        length = (int)entry.getSize();
        bytesread = 0;
        if (Debug.DEBUG_LOADER) {
            Debug.println((String)("  about to read " + length + " bytes from " + filename));
        }
        try {
            try {
                block22: {
                    if (length <= 0) break block22;
                    classbytes = new byte[length];
                    while (bytesread < length && (readcount = in.read(classbytes, bytesread, length - bytesread)) > 0) {
                        bytesread += readcount;
                    }
                    ** GOTO lbl-1000
                }
                length = this.buffersize;
                classbytes = new byte[length];
                while (true) {
                    if (bytesread >= length) {
                        oldbytes = classbytes;
                        classbytes = new byte[length += this.buffersize];
                        System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                        continue;
                    }
                    readcount = in.read(classbytes, bytesread, length - bytesread);
                    if (readcount > 0) {
                        bytesread += readcount;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException v1) {
                if (Debug.DEBUG_LOADER) {
                    Debug.println((String)("  IOException reading " + filename + " from " + this.hostdata));
                }
                var14_14 = null;
                var12_15 = null;
                try {
                    in.close();
                    return var14_14;
                }
                catch (IOException v2) {}
                return var14_14;
            }
        }
        catch (Throwable var13_18) {
            var12_16 = null;
            try {}
            catch (IOException v3) {}
            in.close();
            throw var13_18;
            throw var13_18;
        }
lbl-1000:
        // 2 sources

        {
            var12_17 = null;
        }
        try {}
        catch (IOException v4) {}
        in.close();
        if (Debug.DEBUG_LOADER) {
            Debug.println((String)("  read " + bytesread + " bytes from " + filename));
            Debug.println((String)("  defining class " + name));
        }
        try {
            return this.defineClass(name, classbytes, 0, bytesread, bundledomain);
        }
        catch (Error e) {
            if (Debug.DEBUG_LOADER == false) throw e;
            Debug.println((String)("  error defining class " + name));
            throw e;
        }
    }

    protected URL findResource(String name) {
        URL result = null;
        int i = 0;
        while (i < this.classpathEntries.length) {
            if (this.classpathEntries[i] != null && (result = this.findResourceImpl(name, this.classpathEntries[i].bundlefile, i)) != null) {
                return result;
            }
            ++i;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            int i2 = 0;
            while (i2 < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i2);
                int j = 0;
                while (j < fragCP.classpathEntries.length) {
                    result = this.findResourceImpl(name, fragCP.classpathEntries[j].bundlefile, j);
                    if (result != null) {
                        return result;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return null;
    }

    protected URL findResourceImpl(String name, BundleFile bundlefile, int cpEntry) {
        return bundlefile.getURL(name, cpEntry);
    }

    public Enumeration findLocalResources(String resource) {
        Vector<URL> resources = new Vector<URL>(6);
        int i = 0;
        while (i < this.classpathEntries.length) {
            URL url;
            if (this.classpathEntries[i] != null && (url = this.findResourceImpl(resource, this.classpathEntries[i].bundlefile, i)) != null) {
                resources.addElement(url);
            }
            ++i;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            int i2 = 0;
            while (i2 < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i2);
                int j = 0;
                while (j < fragCP.classpathEntries.length) {
                    URL url = this.findResourceImpl(resource, fragCP.classpathEntries[j].bundlefile, j);
                    if (url != null) {
                        resources.addElement(url);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        if (resources.size() > 0) {
            return resources.elements();
        }
        return null;
    }

    public void close() {
        if (!this.closed) {
            super.close();
            int i = 0;
            while (i < this.classpathEntries.length) {
                if (this.classpathEntries[i] != null) {
                    try {
                        if (this.classpathEntries[i].bundlefile != this.hostdata.bundleFile) {
                            this.classpathEntries[i].bundlefile.close();
                        }
                    }
                    catch (IOException e) {
                        this.hostdata.adaptor.getEventPublisher().publishFrameworkEvent(2, this.hostdata.getBundle(), (Throwable)e);
                    }
                }
                ++i;
            }
            if (this.fragClasspaths != null) {
                int size = this.fragClasspaths.size();
                int i2 = 0;
                while (i2 < size) {
                    FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i2);
                    fragCP.close();
                    ++i2;
                }
            }
        }
    }

    protected ClasspathEntry[] buildClasspath(String[] classpath, DefaultBundleData bundledata, ProtectionDomain domain) {
        ArrayList result = new ArrayList(10);
        if (System.getProperty("osgi.dev") == null) {
            int i = 0;
            while (i < classpath.length) {
                this.findClassPathEntry(result, classpath[i], bundledata, domain);
                ++i;
            }
            return result.toArray(new ClasspathEntry[result.size()]);
        }
        this.addDefaultDevEntries(result, bundledata, domain);
        int i = 0;
        while (i < classpath.length) {
            String[] devEntries = this.getDevEntries(classpath[i], bundledata);
            if (devEntries != null && devEntries.length > 0) {
                int j = 0;
                while (j < devEntries.length) {
                    this.findClassPathEntry(result, devEntries[j], bundledata, domain);
                    ++j;
                }
            } else {
                this.findClassPathEntry(result, classpath[i], bundledata, domain);
            }
            ++i;
        }
        return result.toArray(new ClasspathEntry[result.size()]);
    }

    protected void addDefaultDevEntries(ArrayList result, DefaultBundleData bundledata, ProtectionDomain domain) {
        if (System.getProperty("osgi.dev") == null) {
            return;
        }
        String[] defaultDevEntries = bundledata.adaptor.devCP;
        if (defaultDevEntries != null) {
            int i = 0;
            while (i < defaultDevEntries.length) {
                this.findClassPathEntry(result, defaultDevEntries[i], bundledata, domain);
                ++i;
            }
        }
    }

    protected void findClassPathEntry(ArrayList result, String entry, DefaultBundleData bundledata, ProtectionDomain domain) {
        if (!this.addClassPathEntry(result, entry, bundledata, domain)) {
            BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION", (Object)entry));
            bundledata.adaptor.getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), (Throwable)be);
        }
    }

    protected boolean addClassPathEntry(ArrayList result, String entry, DefaultBundleData bundledata, ProtectionDomain domain) {
        if (entry.equals(".")) {
            result.add(new ClasspathEntry(bundledata.bundleFile, domain));
            return true;
        }
        ClasspathEntry element = this.getClasspath(entry, bundledata, domain);
        if (element != null) {
            result.add(element);
            return true;
        }
        if (this.fragClasspaths != null && this.hostdata == bundledata) {
            int size = this.fragClasspaths.size();
            int i = 0;
            while (i < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i);
                element = this.getClasspath(entry, fragCP.bundledata, fragCP.domain);
                if (element != null) {
                    result.add(element);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected String[] getDevEntries(String classpathEntry, DefaultBundleData bundledata) {
        Properties devProps = null;
        File propLocation = bundledata.bundleFile.getFile(String.valueOf(classpathEntry) + ".properties");
        if (propLocation == null) {
            return null;
        }
        try {
            String[] stringArray;
            FileInputStream in = new FileInputStream(propLocation);
            try {
                devProps = new Properties();
                devProps.load(in);
                stringArray = this.getArrayFromList(devProps.getProperty("bin"));
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return stringArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    protected class FragmentClasspath {
        protected ClasspathEntry[] classpathEntries;
        protected DefaultBundleData bundledata;
        protected ProtectionDomain domain;

        protected FragmentClasspath(ClasspathEntry[] classpathEntries, DefaultBundleData bundledata, ProtectionDomain domain) {
            this.classpathEntries = classpathEntries;
            this.bundledata = bundledata;
            this.domain = domain;
        }

        protected void close() {
            int i = 0;
            while (i < this.classpathEntries.length) {
                try {
                    if (this.classpathEntries[i].bundlefile != this.bundledata.bundleFile) {
                        this.classpathEntries[i].bundlefile.close();
                    }
                }
                catch (IOException e) {
                    this.bundledata.adaptor.getEventPublisher().publishFrameworkEvent(2, this.bundledata.getBundle(), (Throwable)e);
                }
                ++i;
            }
        }
    }

    protected class ClasspathEntry {
        protected BundleFile bundlefile;
        protected ProtectionDomain domain;

        protected ClasspathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            this.bundlefile = bundlefile;
            this.domain = domain;
        }
    }
}

