/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.Version;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.AdaptorMsg;
import org.eclipse.osgi.framework.internal.defaultadaptor.BundleFile;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor;
import org.eclipse.osgi.framework.internal.defaultadaptor.MetaData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class DefaultBundleData
extends AbstractBundleData
implements Cloneable {
    public static final String METADATA_BUNDLE_GEN = "METADATA_BUNDLE_GEN";
    public static final String METADATA_BUNDLE_LOC = "METADATA_BUNDLE_LOC";
    public static final String METADATA_BUNDLE_REF = "METADATA_BUNDLE_REF";
    public static final String METADATA_BUNDLE_NAME = "METADATA_BUNDLE_NAME";
    public static final String METADATA_BUNDLE_NCP = "METADATA_BUNDLE_NCP";
    public static final String METADATA_BUNDLE_ABSL = "METADATA_BUNDLE_ABSL";
    public static final String METADATA_BUNDLE_STATUS = "METADATA_BUNDLE_STATUS";
    public static final String METADATA_BUNDLE_METADATA = "METADATA_BUNDLE_METADATA";
    protected File dir;
    protected File dirData;
    protected File dirGeneration;
    protected long id;
    protected String location;
    protected boolean reference;
    protected MetaData metadata;
    protected File file;
    protected BundleFile bundleFile;
    protected String name;
    protected String uniqueId;
    protected Version version;
    protected boolean isFragment = false;
    protected String classpath;
    protected String activator;
    protected String executionEnvironment;
    protected String dynamicImports;
    protected int generation = 1;
    protected String[] nativepaths;
    protected DefaultAdaptor adaptor;
    protected int startLevel = -1;
    protected int status = 0;

    public DefaultBundleData(DefaultAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    public void initializeExistingBundle(String directory) throws IOException {
        this.id = Long.parseLong(directory);
        this.dir = new File(this.adaptor.bundleRootDir, directory);
        if (!this.dir.exists() || !this.dir.isDirectory()) {
            throw new NumberFormatException();
        }
        File delete = new File(this.dir, ".delete");
        if (delete.exists()) {
            throw new NumberFormatException();
        }
        try {
            this.loadFromMetaData();
        }
        catch (IOException iOException) {
            throw new NumberFormatException();
        }
        this.dirData = new File(this.dir, this.adaptor.dataDirName);
        this.dirGeneration = new File(this.dir, String.valueOf(this.generation));
        this.file = this.reference ? new File(this.name) : new File(this.dirGeneration, this.name);
        this.bundleFile = BundleFile.createBundleFile(this.file, this);
        this.loadFromManifest();
    }

    public void initializeReferencedBundle(long id, String location, String name) throws IOException {
        this.id = id;
        this.location = location;
        this.name = name;
        this.reference = true;
        String directory = String.valueOf(id);
        this.dir = new File(this.adaptor.bundleRootDir, directory);
        this.dirData = new File(this.dir, this.adaptor.dataDirName);
        this.dirGeneration = new File(this.dir, String.valueOf(this.generation));
        this.file = new File(name);
        this.loadMetaData();
        this.setStartLevel(this.adaptor.getInitialBundleStartLevel());
        if (!this.getGenerationDir().exists()) {
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)this.getGenerationDir().getPath()));
        }
        this.bundleFile = BundleFile.createBundleFile(this.file, this);
        this.loadFromManifest();
    }

    public void initializeNewBundle(long id, String location, InputStream in) throws IOException {
        this.id = id;
        this.location = location;
        this.name = this.adaptor.mapLocationToName(location);
        this.reference = false;
        String directory = String.valueOf(id);
        this.dir = new File(this.adaptor.bundleRootDir, directory);
        this.dirData = new File(this.dir, this.adaptor.dataDirName);
        this.dirGeneration = new File(this.dir, String.valueOf(this.generation));
        this.file = new File(this.dirGeneration, this.name);
        this.loadMetaData();
        this.setStartLevel(this.adaptor.getInitialBundleStartLevel());
        if (!this.getGenerationDir().exists()) {
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)this.dirGeneration.getPath()));
        }
        DefaultAdaptor.readFile(in, this.file);
        this.bundleFile = BundleFile.createBundleFile(this.file, this);
        this.loadFromManifest();
    }

    public BundleClassLoader createClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] bundleclasspath) {
        return this.adaptor.getElementFactory().createClassLoader(delegate, domain, bundleclasspath, this);
    }

    public URL getEntry(String path) {
        return this.bundleFile.getURL(path, 0);
    }

    public Enumeration getEntryPaths(String path) {
        return this.bundleFile.getEntryPaths(path);
    }

    public String findLibrary(String libname) {
        String mappedName = System.mapLibraryName(libname);
        String path = null;
        if (Debug.DEBUG_LOADER) {
            Debug.println((String)("  mapped library name: " + mappedName));
        }
        if ((path = this.findNativePath(mappedName)) == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println((String)("  library does not exist: " + mappedName));
            }
            path = this.findNativePath(libname);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println((String)("  returning library: " + path));
        }
        return path;
    }

    protected String findNativePath(String libname) {
        String path = null;
        if (!libname.startsWith("/")) {
            libname = String.valueOf('/') + libname;
        }
        if (this.nativepaths != null) {
            int i = 0;
            while (i < this.nativepaths.length) {
                if (this.nativepaths[i].endsWith(libname)) {
                    File nativeFile = this.bundleFile.getFile(this.nativepaths[i]);
                    path = nativeFile.getAbsolutePath();
                }
                ++i;
            }
        }
        return path;
    }

    public void installNativeCode(String[] nativepaths) throws BundleException {
        this.nativepaths = nativepaths;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < nativepaths.length) {
            File nativeFile = this.bundleFile.getFile(nativepaths[i]);
            if (nativeFile == null) {
                throw new BundleException(AdaptorMsg.formatter.getString("BUNDLE_NATIVECODE_EXCEPTION", (Object)nativepaths[i]));
            }
            sb.append(nativepaths[i]);
            if (i < nativepaths.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        this.metadata.set(METADATA_BUNDLE_NCP, sb.toString());
    }

    public File getDataFile(String path) {
        if (!this.dirData.exists() && !this.dirData.mkdirs() && Debug.DEBUG_GENERAL) {
            Debug.println((String)("Unable to create bundle data directory: " + this.dirData.getPath()));
        }
        return new File(this.dirData, path);
    }

    public long getBundleID() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public void close() throws IOException {
        if (this.bundleFile != null) {
            this.bundleFile.close();
        }
    }

    public void open() throws IOException {
        this.bundleFile.open();
    }

    protected synchronized void loadFromMetaData() throws IOException {
        this.loadMetaData();
        this.status = this.metadata.getInt(METADATA_BUNDLE_STATUS, 0);
        this.startLevel = this.metadata.getInt(METADATA_BUNDLE_ABSL, 1);
        this.generation = this.metadata.getInt(METADATA_BUNDLE_GEN, -1);
        this.name = this.metadata.get(METADATA_BUNDLE_NAME, null);
        this.location = this.metadata.get(METADATA_BUNDLE_LOC, null);
        this.reference = this.metadata.getBoolean(METADATA_BUNDLE_REF, false);
        String npString = this.metadata.get(METADATA_BUNDLE_NCP, null);
        if (npString != null) {
            this.setNativeCodePath(npString);
        }
        if (this.generation == -1 || this.name == null || this.location == null) {
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
        }
    }

    protected void loadMetaData() throws IOException {
        this.metadata = new MetaData(new File(this.dir, ".bundle"), "Bundle metadata");
        this.metadata.load();
    }

    protected void loadFromManifest() throws IOException {
        try {
            this.getManifest();
        }
        catch (BundleException bundleException) {
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_ERROR_GETTING_MANIFEST", (Object)this.location));
        }
        if (this.manifest == null) {
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_ERROR_GETTING_MANIFEST", (Object)this.location));
        }
        this.version = new Version((String)this.manifest.get("Bundle-Version"));
        this.uniqueId = (String)this.manifest.get("Bundle-GlobalName");
        if (this.uniqueId == null) {
            this.uniqueId = (String)this.manifest.get("Bundle-Name");
        }
        this.classpath = (String)this.manifest.get("Bundle-ClassPath");
        this.activator = (String)this.manifest.get("Bundle-Activator");
        String host = (String)this.manifest.get("Host-Bundle");
        this.isFragment = host != null;
        this.executionEnvironment = (String)this.manifest.get("Bundle-RequiredExecutionEnvironment");
        this.dynamicImports = (String)this.manifest.get("DynamicImport-Package");
    }

    protected File getGenerationDir() {
        if (!this.dirGeneration.exists() && !this.dirGeneration.mkdirs() && Debug.DEBUG_GENERAL) {
            Debug.println((String)("Unable to create bundle jar directory: " + this.dirGeneration.getPath()));
        }
        return this.dirGeneration;
    }

    protected File getBundleFile() {
        this.getGenerationDir();
        return this.file;
    }

    protected File getBundleDir() {
        return this.dir;
    }

    public synchronized void save() throws IOException {
        this.metadata.setInt(METADATA_BUNDLE_STATUS, this.status);
        this.metadata.setInt(METADATA_BUNDLE_ABSL, this.startLevel);
        this.metadata.setInt(METADATA_BUNDLE_GEN, this.generation);
        this.metadata.set(METADATA_BUNDLE_NAME, this.name);
        this.metadata.set(METADATA_BUNDLE_LOC, this.location);
        this.metadata.setBoolean(METADATA_BUNDLE_REF, this.reference);
        this.metadata.save();
    }

    protected DefaultBundleData nextGeneration(String name) throws IOException {
        int nextGeneration = this.generation;
        while (nextGeneration < Integer.MAX_VALUE) {
            DefaultBundleData next;
            File nextDirGeneration;
            if ((nextDirGeneration = new File(this.dir, String.valueOf(++nextGeneration))).exists()) continue;
            try {
                next = (DefaultBundleData)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
            next.generation = nextGeneration;
            next.dirGeneration = nextDirGeneration;
            next.name = name;
            next.file = new File(name);
            next.reference = true;
            next.manifest = null;
            return next;
        }
        throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
    }

    public DefaultBundleData nextGeneration() throws IOException {
        int nextGeneration = this.generation;
        while (nextGeneration < Integer.MAX_VALUE) {
            DefaultBundleData next;
            File nextDirGeneration;
            if ((nextDirGeneration = new File(this.dir, String.valueOf(++nextGeneration))).exists()) continue;
            try {
                next = (DefaultBundleData)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
            next.generation = nextGeneration;
            next.dirGeneration = nextDirGeneration;
            if (next.reference) {
                next.reference = false;
                next.name = this.adaptor.mapLocationToName(this.location);
            }
            next.file = new File(nextDirGeneration, next.name);
            next.manifest = null;
            return next;
        }
        throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String toString() {
        return this.location;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStartLevel(int value) {
        this.startLevel = value;
    }

    public void setStatus(int value) {
        this.status = value;
    }

    public boolean isReference() {
        return this.reference;
    }

    public void setReference(boolean value) {
        this.reference = value;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int value) {
        this.generation = value;
    }

    public String getNativeCodePath() {
        if (this.nativepaths == null || this.nativepaths.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.nativepaths.length) {
            File nativeFile = this.bundleFile.getFile(this.nativepaths[i]);
            if (nativeFile != null) {
                sb.append(this.nativepaths[i]);
                if (i < this.nativepaths.length - 1) {
                    sb.append(",");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    protected String[] parseNativeCodePath(String value) {
        if (value == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(5);
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            result.add(path);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setNativeCodePath(String value) {
        this.nativepaths = this.parseNativeCodePath(value);
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getClassPath() {
        return this.classpath;
    }

    public String getActivator() {
        return this.activator;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public String getDynamicImports() {
        return this.dynamicImports;
    }

    public DefaultAdaptor getAdaptor() {
        return this.adaptor;
    }
}

