/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.IBundleStats;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.AdaptorElementFactory;
import org.eclipse.osgi.framework.internal.defaultadaptor.AdaptorMsg;
import org.eclipse.osgi.framework.internal.defaultadaptor.BundleFile;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.eclipse.osgi.framework.internal.defaultadaptor.MetaData;
import org.eclipse.osgi.framework.internal.defaultadaptor.PermissionStorage;
import org.eclipse.osgi.framework.internal.defaultadaptor.ReferenceInputStream;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;

public class DefaultAdaptor
extends AbstractFrameworkAdaptor {
    protected static final String METADATA_ADAPTOR_NEXTID = "METADATA_ADAPTOR_NEXTID";
    protected static final String METADATA_ADAPTOR_IBSL = "METADATA_ADAPTOR_IBSL";
    protected File bundleRootDir;
    protected String bundledir = null;
    protected String dataDirName = "data";
    protected boolean reset = false;
    protected MetaData metadata;
    protected PermissionStorage permissionStore;
    protected long nextId = 1L;
    protected String[] devCP;
    protected final String ADAPTOR_MANIFEST = "/META-INF/ADAPTOR.MF";
    protected Headers manifest = null;
    protected AdaptorElementFactory elementFactory = null;
    protected StateManager stateManager;

    public DefaultAdaptor(String[] args) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                String key;
                StringTokenizer tok;
                String arg = args[i];
                if (arg.equalsIgnoreCase("reset")) {
                    this.reset = true;
                } else if (arg.indexOf("=") != -1 && (tok = new StringTokenizer(args[i], "=")).countTokens() == 2 && (key = tok.nextToken()).equalsIgnoreCase("bundledir")) {
                    this.bundledir = tok.nextToken();
                }
                ++i;
            }
        }
    }

    public void initialize(EventPublisher eventPublisher) {
        super.initialize(eventPublisher);
        this.getBundleDir();
        this.readAdaptorManifest();
        this.stateManager = this.createStateManager();
    }

    protected StateManager createStateManager() {
        this.stateManager = new StateManager(this.bundleRootDir);
        StateImpl systemState = this.stateManager.getSystemState();
        if (systemState != null) {
            return this.stateManager;
        }
        systemState = this.stateManager.createSystemState();
        Vector installedBundles = this.getInstalledBundles();
        if (installedBundles == null) {
            return this.stateManager;
        }
        StateObjectFactory factory = this.stateManager.getFactory();
        Iterator iter = installedBundles.iterator();
        while (iter.hasNext()) {
            BundleData toAdd = (BundleData)iter.next();
            try {
                Dictionary manifest = toAdd.getManifest();
                BundleDescription newDescription = factory.createBundleDescription(manifest, toAdd.getLocation(), toAdd.getBundleID());
                systemState.addBundle(newDescription);
            }
            catch (BundleException bundleException) {}
        }
        systemState.resolve();
        return this.stateManager;
    }

    protected void getBundleDir() {
        if (this.bundledir == null) {
            this.bundledir = System.getProperty("org.eclipse.osgi.framework.defaultadaptor.bundledir");
            if (this.bundledir == null) {
                this.bundledir = this.properties.getProperty("org.eclipse.osgi.framework.defaultadaptor.bundledir", "bundles");
            }
        }
        this.properties.put("org.eclipse.osgi.framework.defaultadaptor.bundledir", this.bundledir);
        this.bundleRootDir = new File(this.bundledir);
    }

    protected void readAdaptorManifest() {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/ADAPTOR.MF");
        if (Debug.DEBUG_GENERAL && in == null) {
            Debug.println((String)"Unable to find adaptor bundle manifest /META-INF/ADAPTOR.MF");
        }
        try {
            this.manifest = Headers.parseManifest((InputStream)in);
        }
        catch (BundleException bundleException) {
            Debug.println((String)"Unable to read adaptor bundle manifest /META-INF/ADAPTOR.MF");
        }
    }

    public void initializeStorage() throws IOException {
        boolean makedir = false;
        if (this.bundleRootDir.exists()) {
            if (this.reset) {
                makedir = true;
                if (!this.rm(this.bundleRootDir) && Debug.DEBUG_GENERAL) {
                    Debug.println((String)("Could not remove directory: " + this.bundleRootDir.getPath()));
                }
            } else if (!this.bundleRootDir.isDirectory()) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.println((String)("Exists but not a directory: " + this.bundleRootDir.getPath()));
                }
                throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
            }
        } else {
            makedir = true;
        }
        if (makedir && !this.bundleRootDir.mkdirs()) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)("Unable to create directory: " + this.bundleRootDir.getPath()));
            }
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
        }
        this.metadata = new MetaData(this.getMetaDataFile(), "Framework metadata");
        this.metadata.load();
        this.nextId = this.metadata.getLong(METADATA_ADAPTOR_NEXTID, 1L);
        this.initialBundleStartLevel = this.metadata.getInt(METADATA_ADAPTOR_IBSL, 1);
    }

    protected File getMetaDataFile() {
        return new File(this.bundleRootDir, ".framework");
    }

    private void compact(File directory) {
        String[] list;
        if (Debug.DEBUG_GENERAL) {
            Debug.println((String)("compact(" + directory.getPath() + ")"));
        }
        if ((list = directory.list()) != null) {
            int len = list.length;
            int i = 0;
            while (i < len) {
                File target;
                if (!this.dataDirName.equals(list[i]) && (target = new File(directory, list[i])).isDirectory()) {
                    File delete = new File(target, ".delete");
                    if (delete.exists()) {
                        if (!this.rm(target) && !delete.exists()) {
                            try {
                                FileOutputStream out = new FileOutputStream(delete);
                                out.close();
                            }
                            catch (IOException e) {
                                if (Debug.DEBUG_GENERAL) {
                                    Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                                }
                            }
                        }
                    } else {
                        this.compact(target);
                    }
                }
                ++i;
            }
        }
    }

    public void compactStorage() {
        this.compact(this.bundleRootDir);
    }

    public Vector getInstalledBundles() {
        String[] list = this.bundleRootDir.list();
        if (list == null) {
            return null;
        }
        int len = list.length;
        Vector<DefaultBundleData> bundleDatas = new Vector<DefaultBundleData>(len << 1, 10);
        int i = 0;
        while (i < len) {
            block7: {
                try {
                    DefaultBundleData data;
                    try {
                        data = (DefaultBundleData)this.getElementFactory().getBundleData(this);
                        data.initializeExistingBundle(list[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block7;
                    }
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println((String)("BundleData created: " + data));
                    }
                    bundleDatas.addElement(data);
                }
                catch (IOException e) {
                    if (!Debug.DEBUG_GENERAL) break block7;
                    Debug.println((String)("Unable to open Bundle[" + list[i] + "]: " + e.getMessage()));
                    Debug.printStackTrace((Throwable)e);
                }
            }
            ++i;
        }
        return bundleDatas;
    }

    public BundleOperation installBundle(final String location, final URLConnection source) {
        return new BundleOperation(){
            private DefaultBundleData data;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public BundleData begin() throws BundleException {
                try {
                    InputStream in = source.getInputStream();
                    try {
                        long id;
                        try {
                            id = DefaultAdaptor.this.getNextBundleId();
                            DefaultAdaptor.this.metadata.save();
                        }
                        catch (IOException e) {
                            throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                        }
                        if (in instanceof ReferenceInputStream) {
                            URL reference = ((ReferenceInputStream)in).getReference();
                            if (!"file".equals(reference.getProtocol())) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_URL_CREATE_EXCEPTION", (Object)reference));
                            }
                            this.data = (DefaultBundleData)DefaultAdaptor.this.getElementFactory().getBundleData(DefaultAdaptor.this);
                            this.data.initializeReferencedBundle(id, location, reference.getPath());
                        } else {
                            this.data = (DefaultBundleData)DefaultAdaptor.this.getElementFactory().getBundleData(DefaultAdaptor.this);
                            this.data.initializeNewBundle(id, location, in);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        Object var5_8 = null;
                        try {}
                        catch (IOException iOException) {
                            return this.data;
                        }
                        in.close();
                        return this.data;
                    }
                }
                catch (IOException ioe) {
                    throw new BundleException(AdaptorMsg.formatter.getString("BUNDLE_READ_EXCEPTION"), (Throwable)ioe);
                }
            }

            public void undo() {
                block7: {
                    File delete;
                    File bundleDir;
                    block6: {
                        if (this.data != null) {
                            try {
                                this.data.close();
                            }
                            catch (IOException e) {
                                if (!Debug.DEBUG_GENERAL) break block6;
                                Debug.println((String)("Unable to close " + this.data + ": " + e.getMessage()));
                            }
                        }
                    }
                    if (this.data != null && !DefaultAdaptor.this.rm(bundleDir = this.data.getBundleDir()) && !(delete = new File(bundleDir, ".delete")).exists()) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (!Debug.DEBUG_GENERAL) break block7;
                            Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                        }
                    }
                }
            }

            public void commit(boolean postpone) throws BundleException {
                try {
                    this.data.save();
                }
                catch (IOException e) {
                    throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                }
                BundleDescription bundleDescription = DefaultAdaptor.this.stateManager.getFactory().createBundleDescription(this.data.getManifest(), this.data.getLocation(), this.data.getBundleID());
                DefaultAdaptor.this.stateManager.getSystemState().addBundle(bundleDescription);
            }
        };
    }

    public BundleOperation updateBundle(final BundleData bundledata, final URLConnection source) {
        return new BundleOperation(){
            private DefaultBundleData data;
            private DefaultBundleData newData;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public BundleData begin() throws BundleException {
                this.data = (DefaultBundleData)bundledata;
                try {
                    InputStream in = source.getInputStream();
                    try {
                        if (in instanceof ReferenceInputStream) {
                            URL reference = ((ReferenceInputStream)in).getReference();
                            if (!"file".equals(reference.getProtocol())) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_URL_CREATE_EXCEPTION", (Object)reference));
                            }
                            String path = reference.getPath();
                            if (path.equals(this.data.getName())) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_SAME_REF_UPDATE", (Object)reference));
                            }
                            try {
                                this.newData = this.data.nextGeneration(reference.getPath());
                            }
                            catch (IOException e) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                            }
                            File bundleGenerationDir = this.newData.getGenerationDir();
                            if (!bundleGenerationDir.exists()) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)bundleGenerationDir.getPath()));
                            }
                            this.newData.bundleFile = BundleFile.createBundleFile(this.newData.file, this.newData);
                        } else {
                            try {
                                this.newData = this.data.nextGeneration();
                            }
                            catch (IOException e) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                            }
                            File bundleGenerationDir = this.newData.getGenerationDir();
                            if (!bundleGenerationDir.exists()) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)bundleGenerationDir.getPath()));
                            }
                            File file = this.newData.getBundleFile();
                            DefaultAdaptor.readFile(in, file);
                            this.newData.bundleFile = BundleFile.createBundleFile(file, this.newData);
                        }
                        Object var5_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_11 = null;
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    in.close();
                    this.newData.loadFromManifest();
                    return this.newData;
                }
                catch (IOException e) {
                    throw new BundleException(AdaptorMsg.formatter.getString("BUNDLE_READ_EXCEPTION"), (Throwable)e);
                }
            }

            public void commit(boolean postpone) throws BundleException {
                File delete;
                try {
                    this.newData.save();
                }
                catch (IOException e) {
                    throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                }
                long bundleId = this.newData.getBundleID();
                StateImpl systemState = DefaultAdaptor.this.stateManager.getSystemState();
                systemState.removeBundle(bundleId);
                BundleDescription newDescription = DefaultAdaptor.this.stateManager.getFactory().createBundleDescription(this.newData.getManifest(), this.newData.getLocation(), bundleId);
                systemState.addBundle(newDescription);
                File originalGenerationDir = this.data.getGenerationDir();
                if (!(!postpone && DefaultAdaptor.this.rm(originalGenerationDir) || (delete = new File(originalGenerationDir, ".delete")).exists())) {
                    try {
                        FileOutputStream out = new FileOutputStream(delete);
                        out.close();
                    }
                    catch (IOException e) {
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                        }
                        DefaultAdaptor.this.eventPublisher.publishFrameworkEvent(2, this.data.getBundle(), (Throwable)e);
                    }
                }
            }

            public void undo() throws BundleException {
                block3: {
                    File delete;
                    File nextGenerationDir;
                    if (this.newData != null && !DefaultAdaptor.this.rm(nextGenerationDir = this.newData.getGenerationDir()) && !(delete = new File(nextGenerationDir, ".delete")).exists()) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (!Debug.DEBUG_GENERAL) break block3;
                            Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                        }
                    }
                }
            }
        };
    }

    public BundleOperation uninstallBundle(final BundleData bundledata) {
        return new BundleOperation(){
            private DefaultBundleData data;

            public BundleData begin() throws BundleException {
                this.data = (DefaultBundleData)bundledata;
                return bundledata;
            }

            public void commit(boolean postpone) throws BundleException {
                block3: {
                    File delete;
                    File bundleDir = this.data.getBundleDir();
                    if (!(!postpone && DefaultAdaptor.this.rm(bundleDir) || (delete = new File(bundleDir, ".delete")).exists())) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (!Debug.DEBUG_GENERAL) break block3;
                            Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                        }
                    }
                }
                DefaultAdaptor.this.stateManager.getSystemState().removeBundle(this.data.getBundleID());
            }

            public void undo() throws BundleException {
            }
        };
    }

    public org.eclipse.osgi.framework.adaptor.PermissionStorage getPermissionStorage() throws IOException {
        if (this.permissionStore == null) {
            DefaultAdaptor defaultAdaptor = this;
            synchronized (defaultAdaptor) {
                if (this.permissionStore == null) {
                    this.permissionStore = new PermissionStorage(this);
                }
            }
        }
        return this.permissionStore;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        StateImpl state;
        BundleDescription systemBundle;
        super.frameworkStart(context);
        String osgiDev = context.getProperty("osgi.dev");
        if (osgiDev != null) {
            Vector<String> devClassPath = new Vector<String>(6);
            StringTokenizer st = new StringTokenizer(osgiDev, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.equals("")) continue;
                devClassPath.addElement(tok);
            }
            this.devCP = new String[devClassPath.size()];
            devClassPath.toArray(this.devCP);
        }
        if ((systemBundle = (state = this.stateManager.getSystemState()).getBundle(0L)) == null || !systemBundle.isResolved()) {
            throw new IllegalStateException();
        }
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        try {
            this.stateManager.shutdown();
        }
        catch (IOException e) {
            throw new BundleException(null, (Throwable)e);
        }
        super.frameworkStop(context);
    }

    protected ServiceRegistration register(String name, Object service, Bundle bundle) {
        Hashtable properties = new Hashtable(7);
        Dictionary headers = bundle.getHeaders();
        properties.put("service.vendor", headers.get("Bundle-Vendor"));
        properties.put("service.ranking", new Integer(Integer.MAX_VALUE));
        properties.put("service.pid", String.valueOf(bundle.getBundleId()) + "." + service.getClass().getName());
        return this.context.registerService(name, service, properties);
    }

    protected boolean rm(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                String[] list = file.list();
                int len = list.length;
                int i = 0;
                while (i < len) {
                    this.rm(new File(file, list[i]));
                    ++i;
                }
            }
            if (Debug.DEBUG_GENERAL) {
                if (file.isDirectory()) {
                    Debug.println((String)("rmdir " + file.getPath()));
                } else {
                    Debug.println((String)("rm " + file.getPath()));
                }
            }
            boolean success = file.delete();
            if (Debug.DEBUG_GENERAL && !success) {
                Debug.println((String)"  rm failed!!");
            }
            return success;
        }
        return true;
    }

    public void setInitialBundleStartLevel(int value) {
        super.setInitialBundleStartLevel(value);
        this.metadata.setInt(METADATA_ADAPTOR_IBSL, value);
        try {
            this.metadata.save();
        }
        catch (IOException e) {
            this.eventPublisher.publishFrameworkEvent(2, this.context.getBundle(), (Throwable)e);
        }
    }

    public String mapLocationToName(String location) {
        int end = location.indexOf(63, 0);
        if (end == -1 && (end = location.indexOf(35, 0)) == -1) {
            end = location.length();
        }
        int begin = location.replace('\\', '/').lastIndexOf(47, end);
        int colon = location.lastIndexOf(58, end);
        if (colon > begin) {
            begin = colon;
        }
        return location.substring(begin + 1, end);
    }

    protected synchronized long getNextBundleId() throws IOException {
        while (this.nextId < Long.MAX_VALUE) {
            long id = this.nextId++;
            this.metadata.setLong(METADATA_ADAPTOR_NEXTID, this.nextId);
            File bundleDir = new File(this.bundleRootDir, String.valueOf(id));
            if (bundleDir.exists()) continue;
            return id;
        }
        throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
    }

    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            fos = null;
            in.close();
            in = null;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)"Unable to read file");
                Debug.printStackTrace((Throwable)e);
            }
            throw e;
        }
    }

    public String getExportPackages() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get((Object)"Export-Package");
    }

    public String getExportServices() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get((Object)"Export-Service");
    }

    public AdaptorElementFactory getElementFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new AdaptorElementFactory();
        }
        return this.elementFactory;
    }

    public IBundleStats getBundleStats() {
        return null;
    }

    public State getState() {
        return this.stateManager.getSystemState();
    }

    public PlatformAdmin getPlatformAdmin() {
        return this.stateManager;
    }
}

