/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.AdaptorMsg;
import org.eclipse.osgi.framework.internal.defaultadaptor.BundleEntry;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.eclipse.osgi.framework.internal.protocol.bundle.Handler;

public abstract class BundleFile {
    protected File bundlefile;
    protected DefaultBundleData bundledata;
    protected String bundleID;

    public BundleFile(File bundlefile, DefaultBundleData bundledata) {
        this.bundlefile = bundlefile;
        this.bundledata = bundledata;
        this.bundleID = String.valueOf(bundledata.getBundleID());
    }

    public abstract File getFile(String var1);

    public abstract BundleEntry getEntry(String var1);

    public abstract Enumeration getEntryPaths(String var1);

    public abstract void close() throws IOException;

    public abstract void open() throws IOException;

    public URL getURL(String path, int cpEntry) {
        BundleEntry bundleEntry = this.getEntry(path);
        if (bundleEntry == null) {
            return null;
        }
        if (System.getSecurityManager() != null) {
            try {
                return new URL("bundle", this.bundleID, cpEntry, path, new Handler(bundleEntry));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return bundleEntry.getURL();
    }

    public static BundleFile createBundleFile(File bundlefile, DefaultBundleData bundledata) throws IOException {
        if (bundlefile.isDirectory()) {
            return new DirBundleFile(bundlefile, bundledata);
        }
        return new ZipBundleFile(bundlefile, bundledata);
    }

    public static BundleFile createBundleFile(ZipBundleFile bundlefile, String cp) {
        return new ZipDirBundleFile(bundlefile, cp);
    }

    public static class ZipBundleFile
    extends BundleFile {
        protected ZipFile zipFile;
        protected boolean closed = true;

        protected ZipBundleFile(File bundlefile, DefaultBundleData bundledata) throws IOException {
            super(bundlefile, bundledata);
            this.open();
        }

        protected ZipEntry getZipEntry(String path) {
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            return this.zipFile.getEntry(path);
        }

        public File getFile(String entry) {
            block10: {
                ZipEntry zipEntry = this.getZipEntry(entry);
                if (zipEntry == null) {
                    return null;
                }
                try {
                    File bundleGenerationDir = this.bundledata.getGenerationDir();
                    if (bundleGenerationDir.exists()) {
                        String path = ".cp";
                        String name = zipEntry.getName().replace('/', File.separatorChar);
                        path = name.length() > 1 && name.charAt(0) == File.separatorChar ? path.concat(name) : String.valueOf(path) + File.separator + name;
                        File nested = new File(bundleGenerationDir, path);
                        if (nested.exists()) {
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println((String)("File already present: " + nested.getPath()));
                            }
                        } else {
                            File dir;
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println((String)("Creating file: " + nested.getPath()));
                            }
                            if (!(dir = new File(nested.getParent())).exists() && !dir.mkdirs()) {
                                if (Debug.DEBUG_GENERAL) {
                                    Debug.println((String)("Unable to create directory: " + dir.getPath()));
                                }
                                throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
                            }
                            DefaultAdaptor.readFile(this.zipFile.getInputStream(zipEntry), nested);
                        }
                        return nested;
                    }
                }
                catch (IOException e) {
                    if (!Debug.DEBUG_GENERAL) break block10;
                    Debug.printStackTrace((Throwable)e);
                }
            }
            return null;
        }

        public BundleEntry getEntry(String path) {
            ZipEntry zipEntry = this.getZipEntry(path);
            if (zipEntry == null) {
                return null;
            }
            return new BundleEntry.ZipBundleEntry(this.zipFile, zipEntry, this.bundlefile);
        }

        public Enumeration getEntryPaths(String path) {
            if (path == null) {
                return null;
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() > 0 & !path.endsWith("/")) {
                path = path + "/";
            }
            Vector<String> vEntries = new Vector<String>();
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryPath = zipEntry.getName();
                if (!entryPath.startsWith(path) || path.length() >= entryPath.length()) continue;
                if (entryPath.lastIndexOf(47) < path.length()) {
                    vEntries.add(entryPath);
                    continue;
                }
                entryPath = entryPath.substring(path.length());
                int i = entryPath.indexOf(47);
                entryPath = String.valueOf(path) + entryPath.substring(0, i + 1);
                if (vEntries.contains(entryPath)) continue;
                vEntries.add(entryPath);
            }
            return vEntries.elements();
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.zipFile.close();
            }
        }

        public void open() throws IOException {
            if (this.closed) {
                this.zipFile = new ZipFile(this.bundlefile);
                this.closed = false;
            }
        }
    }

    public static class DirBundleFile
    extends BundleFile {
        protected DirBundleFile(File bundlefile, DefaultBundleData bundledata) throws IOException {
            super(bundlefile, bundledata);
            if (!bundlefile.exists() || !bundlefile.isDirectory()) {
                throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_EXCEPTION", (Object)bundlefile));
            }
        }

        public File getFile(String path) {
            File filePath = new File(this.bundlefile, path);
            if (filePath.exists()) {
                return filePath;
            }
            return null;
        }

        public BundleEntry getEntry(String path) {
            File filePath = new File(this.bundlefile, path);
            return new BundleEntry.FileBundleEntry(filePath, path);
        }

        public URL getURL(String path, int cpEntry) {
            File filePath = new File(this.bundlefile, path);
            if (!filePath.exists()) {
                return null;
            }
            if (System.getSecurityManager() != null) {
                try {
                    BundleEntry.FileBundleEntry bundleEntry = new BundleEntry.FileBundleEntry(filePath, path);
                    return new URL("bundle", this.bundleID, cpEntry, path, new Handler(bundleEntry));
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            try {
                return filePath.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        public Enumeration getEntryPaths(String path) {
            File pathFile = new File(this.bundlefile, path);
            if (!pathFile.exists()) {
                return null;
            }
            if (pathFile.isDirectory()) {
                String[] fileList = pathFile.list();
                return new Enumeration(this, fileList, pathFile){
                    int cur;
                    final /* synthetic */ DirBundleFile this$1;
                    private final /* synthetic */ String[] val$fileList;
                    private final /* synthetic */ File val$pathFile;
                    {
                        this.this$1 = dirBundleFile;
                        this.val$fileList = stringArray;
                        this.val$pathFile = file;
                        this.cur = 0;
                    }

                    public boolean hasMoreElements() {
                        return this.cur < this.val$fileList.length;
                    }

                    public Object nextElement() {
                        if (this.cur >= this.val$fileList.length) {
                            throw new NoSuchElementException();
                        }
                        File childFile = new File(this.val$pathFile, this.val$fileList[this.cur]);
                        if (childFile.isDirectory()) {
                            StringBuffer sb = new StringBuffer(this.val$fileList[this.cur++]).append("/");
                            return sb.toString();
                        }
                        return this.val$fileList[this.cur++];
                    }
                };
            }
            return new Enumeration(this, path){
                int cur;
                final /* synthetic */ DirBundleFile this$1;
                private final /* synthetic */ String val$path;
                {
                    this.this$1 = dirBundleFile;
                    this.val$path = string;
                    this.cur = 0;
                }

                public boolean hasMoreElements() {
                    return this.cur < 1;
                }

                public Object nextElement() {
                    if (this.cur == 0) {
                        this.cur = 1;
                        return this.val$path;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        public void close() {
        }

        public void open() {
        }
    }

    public static class ZipDirBundleFile
    extends BundleFile {
        ZipBundleFile zipBundlefile;
        String cp;

        public ZipDirBundleFile(ZipBundleFile zipBundlefile, String cp) {
            super(zipBundlefile.bundlefile, zipBundlefile.bundledata);
            this.zipBundlefile = zipBundlefile;
            this.cp = cp;
            if (cp.charAt(cp.length() - 1) != '/') {
                this.cp = String.valueOf(this.cp) + '/';
            }
        }

        public void close() {
        }

        public BundleEntry getEntry(String path) {
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            String newpath = this.cp + path;
            return this.zipBundlefile.getEntry(newpath);
        }

        public Enumeration getEntryPaths(String path) {
            return null;
        }

        public File getFile(String entry) {
            return null;
        }

        public void open() {
        }
    }
}

