/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class BundleEntry {
    public abstract InputStream getInputStream() throws IOException;

    public abstract long getSize();

    public abstract String getName();

    public abstract long getTime();

    public abstract URL getURL();

    public String toString() {
        return this.getName();
    }

    public static class ZipBundleEntry
    extends BundleEntry {
        private ZipFile zipFile;
        private ZipEntry zipEntry;
        private File bundleFile;

        ZipBundleEntry(ZipFile zipFile, ZipEntry entry, File bundleFile) {
            this.zipFile = zipFile;
            this.zipEntry = entry;
            this.bundleFile = bundleFile;
        }

        public InputStream getInputStream() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        public long getSize() {
            return this.zipEntry.getSize();
        }

        public String getName() {
            return this.zipEntry.getName();
        }

        public long getTime() {
            return this.zipEntry.getTime();
        }

        public URL getURL() {
            try {
                return new URL("jar:file:" + this.bundleFile.getAbsolutePath() + "!/" + this.zipEntry.getName());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    public static class FileBundleEntry
    extends BundleEntry {
        private File file;
        private String name;

        FileBundleEntry(File file, String name) {
            this.file = file;
            this.name = name;
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public long getSize() {
            return this.file.length();
        }

        public String getName() {
            return this.name;
        }

        public long getTime() {
            return this.file.lastModified();
        }

        public URL getURL() {
            try {
                return this.file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }
}

