/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessorExtension2;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.internal.BaseCompareAction;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditionAction
extends BaseCompareAction {
    private String fBundleName;
    private boolean fReplaceMode;
    protected boolean fPrevious = false;
    protected String fHelpContextId;

    EditionAction(boolean replaceMode, String bundleName) {
        this.fReplaceMode = replaceMode;
        this.fBundleName = bundleName;
    }

    protected boolean isEnabled(ISelection selection) {
        return Utilities.getFiles(selection).length == 1;
    }

    protected void run(ISelection selection) {
        IFile[] files = Utilities.getFiles(selection);
        int i = 0;
        while (i < files.length) {
            this.doFromHistory(files[i]);
            ++i;
        }
    }

    private void doFromHistory(IFile file) {
        block14: {
            ResourceBundle bundle = ResourceBundle.getBundle(this.fBundleName);
            String title = Utilities.getString(bundle, "title");
            Shell parentShell = CompareUIPlugin.getShell();
            IFileState[] states = null;
            try {
                states = file.getHistory(null);
            }
            catch (CoreException ex) {
                MessageDialog.openError((Shell)parentShell, (String)title, (String)ex.getMessage());
                return;
            }
            if (states == null || states.length <= 0) {
                String msg = Utilities.getString(bundle, "noLocalHistoryError");
                MessageDialog.openInformation((Shell)parentShell, (String)title, (String)msg);
                return;
            }
            ResourceNode base = new ResourceNode((IResource)file);
            IDocument document = this.getDocument(file);
            ITypedElement target = base;
            if (document != null) {
                target = new DocumentBufferNode(document, file);
            }
            ITypedElement[] editions = new ITypedElement[states.length + 1];
            editions[0] = base;
            int i = 0;
            while (i < states.length) {
                editions[i + 1] = new HistoryItem(base, states[i]);
                ++i;
            }
            EditionSelectionDialog d = new EditionSelectionDialog(parentShell, bundle);
            d.setEditionTitleArgument(file.getName());
            d.setEditionTitleImage(CompareUIPlugin.getImage((IAdaptable)file));
            if (this.fHelpContextId != null) {
                d.setHelpContextId(this.fHelpContextId);
            }
            if (this.fReplaceMode) {
                ITypedElement ti = null;
                ti = this.fPrevious ? d.selectPreviousEdition(target, editions, null) : d.selectEdition(target, editions, null);
                if (ti instanceof IStreamContentAccessor) {
                    IStreamContentAccessor sa = (IStreamContentAccessor)((Object)ti);
                    if (Utilities.validateResource((IResource)file, parentShell, title)) {
                        try {
                            if (document != null) {
                                this.updateDocument(document, sa);
                                break block14;
                            }
                            this.updateWorkspace(bundle, parentShell, sa, file);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException x) {
                            String reason = x.getTargetException().getMessage();
                            MessageDialog.openError((Shell)parentShell, (String)title, (String)Utilities.getFormattedString(bundle, "replaceError", reason));
                        }
                    }
                }
            } else {
                d.setCompareMode(true);
                d.selectEdition(target, editions, null);
            }
        }
    }

    private void updateWorkspace(final ResourceBundle bundle, Shell shell, final IStreamContentAccessor sa, final IFile file) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    try {
                        String taskName = Utilities.getString(bundle, "taskName");
                        pm.beginTask(taskName, -1);
                        file.setContents(sa.getContents(), false, true, pm);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    pm.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                pm.done();
            }
        };
        ProgressMonitorDialog pmdialog = new ProgressMonitorDialog(shell);
        pmdialog.run(false, true, (IRunnableWithProgress)operation);
    }

    private void updateDocument(IDocument document, IStreamContentAccessor sa) throws InvocationTargetException {
        try {
            String text = Utilities.readString(sa);
            document.replace(0, document.getLength(), text);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (BadLocationException e) {
            throw new InvocationTargetException(e);
        }
    }

    private IDocument getDocument(IFile file) {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow[] ws = wb.getWorkbenchWindows();
        if (ws == null) {
            return null;
        }
        FileEditorInput test = new FileEditorInput(file);
        int i = 0;
        while (i < ws.length) {
            IWorkbenchWindow w = ws[i];
            IWorkbenchPage[] wps = w.getPages();
            if (wps != null) {
                int j = 0;
                while (j < wps.length) {
                    IDocument doc;
                    ITextEditor te;
                    IDocumentProvider dp;
                    IWorkbenchPage wp = wps[j];
                    IEditorPart ep = wp.findEditor((IEditorInput)test);
                    if (ep instanceof ITextEditor && (dp = (te = (ITextEditor)ep).getDocumentProvider()) != null && (doc = dp.getDocument((Object)ep)) != null) {
                        return doc;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    class DocumentBufferNode
    implements ITypedElement,
    IStreamContentAccessorExtension2 {
        private static final String UTF_16 = "UTF-16";
        private IDocument fDocument;
        private IFile fFile;

        DocumentBufferNode(IDocument document, IFile file) {
            this.fDocument = document;
            this.fFile = file;
        }

        public String getName() {
            return this.fFile.getName();
        }

        public String getType() {
            return this.fFile.getFileExtension();
        }

        public Image getImage() {
            return null;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(Utilities.getBytes(this.fDocument.get(), UTF_16));
        }

        public String getCharset() {
            return UTF_16;
        }
    }
}

