/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareDialog;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.ComparePreferencePage;
import org.eclipse.compare.internal.IStructureCreatorDescriptor;
import org.eclipse.compare.internal.IViewerDescriptor;
import org.eclipse.compare.internal.SimpleTextViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class CompareUIPlugin
extends AbstractUIPlugin {
    public static final String DTOOL_NEXT = "dlcl16/next_nav.gif";
    public static final String CTOOL_NEXT = "clcl16/next_nav.gif";
    public static final String ETOOL_NEXT = "elcl16/next_nav.gif";
    public static final String DTOOL_PREV = "dlcl16/prev_nav.gif";
    public static final String CTOOL_PREV = "clcl16/prev_nav.gif";
    public static final String ETOOL_PREV = "elcl16/prev_nav.gif";
    public static final int INTERNAL_ERROR = 1;
    private static boolean NORMALIZE_CASE = true;
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String EXTENSIONS_ATTRIBUTE = "extensions";
    public static final String PLUGIN_ID = "org.eclipse.compare";
    private static final String STRUCTURE_CREATOR_EXTENSION_POINT = "structureCreators";
    private static final String STRUCTURE_MERGEVIEWER_EXTENSION_POINT = "structureMergeViewers";
    private static final String CONTENT_MERGEVIEWER_EXTENSION_POINT = "contentMergeViewers";
    private static final String CONTENT_VIEWER_EXTENSION_POINT = "contentViewers";
    private static final String COMPARE_EDITOR = "org.eclipse.compare.CompareEditor";
    private static final String STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME = "StructureViewerAliases";
    private static Map fgImages = new Hashtable(10);
    private static Map fgImageDescriptors = new Hashtable(10);
    private static Map fgImages2 = new Hashtable(10);
    private static Map fgStructureCreators = new Hashtable(10);
    private static Map fgStructureViewerDescriptors = new Hashtable(10);
    private static Map fgStructureViewerAliases = new Hashtable(10);
    private static Map fgContentViewerDescriptors = new Hashtable(10);
    private static Map fgContentMergeViewerDescriptors = new Hashtable(10);
    private static List fgDisposeOnShutdownImages = new ArrayList();
    private static ResourceBundle fgResourceBundle;
    private static CompareUIPlugin fgComparePlugin;
    static /* synthetic */ Class class$0;

    public CompareUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgComparePlugin = this;
        fgResourceBundle = descriptor.getResourceBundle();
        this.registerExtensions();
        this.initPreferenceStore();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        ComparePreferencePage.initDefaults(store);
    }

    private void registerExtensions() {
        String ext;
        ViewerDescriptor desc;
        IPluginRegistry registry = Platform.getPluginRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PLUGIN_ID, STRUCTURE_CREATOR_EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            final IConfigurationElement conf = elements[i];
            String extensions = conf.getAttribute(EXTENSIONS_ATTRIBUTE);
            CompareUIPlugin.registerStructureCreator(extensions, new IStructureCreatorDescriptor(){

                public IStructureCreator createStructureCreator() {
                    try {
                        return (IStructureCreator)conf.createExecutableExtension(CompareUIPlugin.CLASS_ATTRIBUTE);
                    }
                    catch (CoreException coreException) {
                        return null;
                    }
                }
            });
            ++i;
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, STRUCTURE_MERGEVIEWER_EXTENSION_POINT);
        i = 0;
        while (i < elements.length) {
            desc = new ViewerDescriptor(elements[i]);
            ext = desc.getExtension();
            if (ext != null) {
                CompareUIPlugin.registerStructureViewerDescriptor(desc.getExtension(), desc);
            }
            ++i;
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, CONTENT_MERGEVIEWER_EXTENSION_POINT);
        i = 0;
        while (i < elements.length) {
            desc = new ViewerDescriptor(elements[i]);
            ext = desc.getExtension();
            if (ext != null) {
                CompareUIPlugin.registerContentMergeViewerDescriptor(desc.getExtension(), desc);
            }
            ++i;
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, CONTENT_VIEWER_EXTENSION_POINT);
        i = 0;
        while (i < elements.length) {
            desc = new ViewerDescriptor(elements[i]);
            ext = desc.getExtension();
            if (ext != null) {
                CompareUIPlugin.registerContentViewerDescriptor(desc.getExtension(), desc);
            }
            ++i;
        }
    }

    public static CompareUIPlugin getDefault() {
        return fgComparePlugin;
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public static IWorkbench getActiveWorkbench() {
        CompareUIPlugin plugin = CompareUIPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        return plugin.getWorkbench();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = CompareUIPlugin.getActiveWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = CompareUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static Shell getShell() {
        IWorkbenchWindow window = CompareUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static void disposeOnShutdown(Image image) {
        if (image != null) {
            fgDisposeOnShutdownImages.add(image);
        }
    }

    public void shutdown() throws CoreException {
        IPreferenceStore ps = this.getPreferenceStore();
        if (ps != null) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = fgStructureViewerAliases.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String alias = (String)fgStructureViewerAliases.get(key);
                sb.append(key);
                sb.append('.');
                sb.append(alias);
                sb.append(' ');
            }
            ps.setValue(STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME, sb.toString());
        }
        super.shutdown();
        if (fgDisposeOnShutdownImages != null) {
            Iterator i = fgDisposeOnShutdownImages.iterator();
            while (i.hasNext()) {
                Image img = (Image)i.next();
                if (img.isDisposed()) continue;
                img.dispose();
            }
            fgImages = null;
        }
    }

    public void openCompareEditor(CompareEditorInput input, IWorkbenchPage page, IReusableEditor editor) {
        if (this.compareResultOK(input)) {
            if (editor != null) {
                editor.setInput((IEditorInput)input);
                return;
            }
            if (page == null) {
                page = CompareUIPlugin.getActivePage();
            }
            if (page != null) {
                try {
                    page.openEditor((IEditorInput)input, COMPARE_EDITOR);
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)CompareUIPlugin.getShell(), (String)Utilities.getString("CompareUIPlugin.openEditorError"), (String)e.getMessage());
                }
            } else {
                MessageDialog.openError((Shell)CompareUIPlugin.getShell(), (String)Utilities.getString("CompareUIPlugin.openEditorError"), (String)Utilities.getString("CompareUIPlugin.noActiveWorkbenchPage"));
            }
        }
    }

    public void openCompareDialog(CompareEditorInput input) {
        if (this.compareResultOK(input)) {
            CompareDialog dialog = new CompareDialog(CompareUIPlugin.getShell(), input);
            dialog.open();
        }
    }

    private boolean compareResultOK(CompareEditorInput input) {
        Shell shell = CompareUIPlugin.getShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)input);
            String message = input.getMessage();
            if (message != null) {
                MessageDialog.openError((Shell)shell, (String)Utilities.getString("CompareUIPlugin.compareFailed"), (String)message);
                return false;
            }
            if (input.getCompareResult() == null) {
                MessageDialog.openInformation((Shell)shell, (String)Utilities.getString("CompareUIPlugin.dialogTitle"), (String)Utilities.getString("CompareUIPlugin.noDifferences"));
                return false;
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            MessageDialog.openError((Shell)shell, (String)Utilities.getString("CompareUIPlugin.compareFailed"), (String)x.getTargetException().getMessage());
        }
        return false;
    }

    private static void registerImage(String type, Image image, boolean dispose) {
        fgImages.put(CompareUIPlugin.normalizeCase(type), image);
        if (image != null && dispose) {
            fgDisposeOnShutdownImages.add(image);
        }
    }

    public static void registerImageDescriptor(String type, ImageDescriptor descriptor) {
        fgImageDescriptors.put(CompareUIPlugin.normalizeCase(type), descriptor);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        URL installURL = null;
        if (fgComparePlugin != null) {
            installURL = fgComparePlugin.getDescriptor().getInstallURL();
        }
        if (installURL != null) {
            try {
                URL url = new URL(installURL, String.valueOf(Utilities.getIconPath(null)) + relativePath);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException malformedURLException) {
                Assert.isTrue((boolean)false);
            }
        }
        return null;
    }

    public static Image getImage(String type) {
        type = CompareUIPlugin.normalizeCase(type);
        boolean dispose = false;
        Image image = null;
        if (type != null) {
            image = (Image)fgImages.get(type);
        }
        if (image == null) {
            ImageDescriptor id = (ImageDescriptor)fgImageDescriptors.get(type);
            if (id != null) {
                image = id.createImage();
                dispose = true;
            }
            if (image == null) {
                if (fgComparePlugin != null) {
                    if ("FOLDER".equals(type)) {
                        image = CompareUIPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                    } else {
                        image = CompareUIPlugin.createWorkbenchImage(type);
                        dispose = true;
                    }
                } else {
                    id = (ImageDescriptor)fgImageDescriptors.get(CompareUIPlugin.normalizeCase("file"));
                    image = id.createImage();
                    dispose = true;
                }
            }
            if (image != null) {
                CompareUIPlugin.registerImage(type, image, dispose);
            }
        }
        return image;
    }

    public static Image getImage(IAdaptable adaptable) {
        if (adaptable != null) {
            ImageDescriptor id;
            Object o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((o = adaptable.getAdapter((Class)clazz)) instanceof IWorkbenchAdapter && (id = ((IWorkbenchAdapter)o).getImageDescriptor((Object)adaptable)) != null) {
                Image image = (Image)fgImages2.get(id);
                if (image == null) {
                    image = id.createImage();
                    try {
                        fgImages2.put(id, image);
                    }
                    catch (NullPointerException nullPointerException) {}
                    fgDisposeOnShutdownImages.add(image);
                }
                return image;
            }
        }
        return null;
    }

    private static Image createWorkbenchImage(String type) {
        IEditorRegistry er = CompareUIPlugin.getDefault().getWorkbench().getEditorRegistry();
        ImageDescriptor id = er.getImageDescriptor("foo." + type);
        return id.createImage();
    }

    public static void registerStructureCreator(String types, IStructureCreatorDescriptor descriptor) {
        if (types != null) {
            StringTokenizer tokenizer = new StringTokenizer(types, ",");
            while (tokenizer.hasMoreElements()) {
                String extension = tokenizer.nextToken().trim();
                fgStructureCreators.put(CompareUIPlugin.normalizeCase(extension), descriptor);
            }
        }
    }

    public static IStructureCreatorDescriptor getStructureCreator(String type) {
        return (IStructureCreatorDescriptor)fgStructureCreators.get(CompareUIPlugin.normalizeCase(type));
    }

    public static void registerStructureViewerDescriptor(String types, IViewerDescriptor descriptor) {
        StringTokenizer tokenizer = new StringTokenizer(types, ",");
        while (tokenizer.hasMoreElements()) {
            String extension = tokenizer.nextToken().trim();
            fgStructureViewerDescriptors.put(CompareUIPlugin.normalizeCase(extension), descriptor);
        }
    }

    public static void registerContentMergeViewerDescriptor(String types, IViewerDescriptor descriptor) {
        StringTokenizer tokenizer = new StringTokenizer(types, ",");
        while (tokenizer.hasMoreElements()) {
            String extension = tokenizer.nextToken().trim();
            fgContentMergeViewerDescriptors.put(CompareUIPlugin.normalizeCase(extension), descriptor);
        }
    }

    public static void registerContentViewerDescriptor(String types, IViewerDescriptor descriptor) {
        StringTokenizer tokenizer = new StringTokenizer(types, ",");
        while (tokenizer.hasMoreElements()) {
            String extension = tokenizer.nextToken().trim();
            fgContentViewerDescriptors.put(CompareUIPlugin.normalizeCase(extension), descriptor);
        }
    }

    public static Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent, CompareConfiguration configuration) {
        IStructureCreator sc;
        String alias;
        if (input.getLeft() == null || input.getRight() == null) {
            return null;
        }
        String[] types = CompareUIPlugin.getTypes(input);
        if (!CompareUIPlugin.isHomogenous(types)) {
            return null;
        }
        String type = types[0];
        IViewerDescriptor vd = (IViewerDescriptor)fgStructureViewerDescriptors.get(type = CompareUIPlugin.normalizeCase(type));
        if (vd == null && (alias = (String)fgStructureViewerAliases.get(type)) != null) {
            vd = (IViewerDescriptor)fgStructureViewerDescriptors.get(alias);
        }
        if (vd != null) {
            return vd.createViewer(oldViewer, parent, configuration);
        }
        IStructureCreatorDescriptor scc = CompareUIPlugin.getStructureCreator(type);
        if (scc != null && (sc = scc.createStructureCreator()) != null) {
            StructureDiffViewer sdv = new StructureDiffViewer(parent, configuration);
            sdv.setStructureCreator(sc);
            return sdv;
        }
        return null;
    }

    public static Viewer findContentViewer(Viewer oldViewer, Object in, Composite parent, CompareConfiguration cc) {
        if (in instanceof IStreamContentAccessor) {
            ITypedElement tin;
            String ty;
            String type = "txt";
            if (in instanceof ITypedElement && (ty = (tin = (ITypedElement)in).getType()) != null) {
                type = ty;
            }
            type = CompareUIPlugin.normalizeCase(type);
            IViewerDescriptor vd = (IViewerDescriptor)fgContentViewerDescriptors.get(type);
            Viewer viewer = null;
            if (vd != null && (viewer = vd.createViewer(oldViewer, parent, cc)) != null) {
                return viewer;
            }
            return new SimpleTextViewer(parent);
        }
        if (!(in instanceof ICompareInput)) {
            return null;
        }
        ICompareInput input = (ICompareInput)in;
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            type = types[0];
        }
        if ("FOLDER".equals(type)) {
            return null;
        }
        if (type == null) {
            int n = 0;
            int i = 0;
            while (i < types.length) {
                if (!"???".equals(types[i])) {
                    ++n;
                    if (type == null) {
                        type = types[i];
                    }
                }
                ++i;
            }
            if (n > 1) {
                type = null;
            }
        }
        if (type != null) {
            IViewerDescriptor vd = (IViewerDescriptor)fgContentMergeViewerDescriptors.get(type);
            Viewer viewer = null;
            if (vd != null && (viewer = vd.createViewer(oldViewer, parent, cc)) != null) {
                return viewer;
            }
        }
        String leftType = CompareUIPlugin.guessType(input.getLeft());
        String rightType = CompareUIPlugin.guessType(input.getRight());
        if (leftType != null || rightType != null) {
            boolean right_text = rightType != null && "txt".equals(rightType);
            boolean left_text = leftType != null && "txt".equals(leftType);
            type = leftType == null && right_text || left_text && rightType == null || left_text && right_text ? "txt" : "binary";
            IViewerDescriptor vd = (IViewerDescriptor)fgContentMergeViewerDescriptors.get(CompareUIPlugin.normalizeCase(type));
            if (vd != null) {
                return vd.createViewer(oldViewer, parent, cc);
            }
        }
        return null;
    }

    private static String[] getTypes(ICompareInput input) {
        String type;
        ITypedElement ancestor = input.getAncestor();
        ITypedElement left = input.getLeft();
        ITypedElement right = input.getRight();
        String[] types = new String[3];
        int cnt = 0;
        if (ancestor != null && (type = ancestor.getType()) != null) {
            types[cnt++] = CompareUIPlugin.normalizeCase(type);
        }
        if (left != null && (type = left.getType()) != null) {
            types[cnt++] = CompareUIPlugin.normalizeCase(type);
        }
        if (right != null && (type = right.getType()) != null) {
            types[cnt++] = CompareUIPlugin.normalizeCase(type);
        }
        String[] result = new String[cnt];
        int i = 0;
        while (i < cnt) {
            result[i] = types[i];
            ++i;
        }
        return result;
    }

    private static boolean isHomogenous(String[] types) {
        switch (types.length) {
            case 1: {
                return true;
            }
            case 2: {
                return types[0].equals(types[1]);
            }
            case 3: {
                return types[0].equals(types[1]) && types[1].equals(types[2]);
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private static String guessType(ITypedElement input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [6 : 142->145)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String normalizeCase(String s) {
        if (NORMALIZE_CASE && s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    private void initPreferenceStore() {
        String aliases;
        IPreferenceStore ps = this.getPreferenceStore();
        if (ps != null && (aliases = ps.getString(STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME)) != null && aliases.length() > 0) {
            StringTokenizer st = new StringTokenizer(aliases, " ");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int pos = pair.indexOf(46);
                if (pos <= 0) continue;
                String key = pair.substring(0, pos);
                String alias = pair.substring(pos + 1);
                fgStructureViewerAliases.put(key, alias);
            }
        }
    }

    public static void addStructureViewerAlias(String type, String alias) {
        fgStructureViewerAliases.put(CompareUIPlugin.normalizeCase(alias), CompareUIPlugin.normalizeCase(type));
    }

    public static void removeAllStructureViewerAliases(String type) {
        String t = CompareUIPlugin.normalizeCase(type);
        Set entrySet = fgStructureViewerAliases.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!entry.getValue().equals(t)) continue;
            iter.remove();
        }
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = CompareUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static void log(Throwable e) {
        CompareUIPlugin.log((IStatus)new Status(4, CompareUIPlugin.getPluginId(), 1, CompareMessages.getString("ComparePlugin.internal_error"), e));
    }

    public static void log(IStatus status) {
        CompareUIPlugin.getDefault().getLog().log(status);
    }

    public static String getPluginId() {
        return CompareUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }
}

