/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorPart;

public class CompareEditor
extends EditorPart
implements IReusableEditor {
    public static final String CONFIRM_SAVE_PROPERTY = "org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY";
    private IActionBars fActionBars;
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private Control fControl;

    CompareConfiguration getCompareConfiguration() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof CompareEditorInput) {
            return ((CompareEditorInput)input).getCompareConfiguration();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof CompareEditorInput)) {
            throw new PartInitException(Utilities.getString("CompareEditor.invalidInput"));
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void setInput(IEditorInput input) {
        try {
            this.doSetInput(input);
        }
        catch (CoreException x) {
            String title = Utilities.getString("CompareEditor.error.setinput.title");
            String msg = Utilities.getString("CompareEditor.error.setinput.message");
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        if (!(input instanceof CompareEditorInput)) {
            Status s = new Status(4, "org.eclipse.ui", 0, Utilities.getString("CompareEditor.invalidInput"), null);
            throw new CoreException((IStatus)s);
        }
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput instanceof IPropertyChangeNotifier) {
            ((IPropertyChangeNotifier)input).removePropertyChangeListener(this.fPropertyChangeListener);
        }
        super.setInput(input);
        CompareEditorInput cei = (CompareEditorInput)input;
        this.setTitleImage(cei.getTitleImage());
        this.setTitle(cei.getTitle());
        if (input instanceof IPropertyChangeNotifier) {
            ((IPropertyChangeNotifier)input).addPropertyChangeListener(this.fPropertyChangeListener);
        }
        if (oldInput != null && this.fControl != null && !this.fControl.isDisposed()) {
            Point oldSize = this.fControl.getSize();
            Composite parent = this.fControl.getParent();
            this.fControl.dispose();
            this.createPartControl(parent);
            if (this.fControl != null) {
                this.fControl.setSize(oldSize);
            }
        }
    }

    public IActionBars getActionBars() {
        return this.fActionBars;
    }

    public void setActionBars(IActionBars actionBars) {
        this.fActionBars = actionBars;
    }

    public void createPartControl(Composite parent) {
        parent.setData((Object)this);
        IEditorInput input = this.getEditorInput();
        if (input instanceof CompareEditorInput) {
            this.fControl = ((CompareEditorInput)input).createContents(parent);
            WorkbenchHelp.setHelp((Control)this.fControl, (String)"org.eclipse.compare.compare_editor_context");
        }
    }

    public void dispose() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IPropertyChangeNotifier) {
            ((IPropertyChangeNotifier)input).removePropertyChangeListener(this.fPropertyChangeListener);
        }
        super.dispose();
        this.fPropertyChangeListener = null;
    }

    public void setFocus() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof CompareEditorInput) {
            ((CompareEditorInput)input).setFocus();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void doSaveAs() {
        Assert.isTrue((boolean)false);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final IEditorInput input = this.getEditorInput();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor pm) throws CoreException {
                if (input instanceof CompareEditorInput) {
                    ((CompareEditorInput)input).saveChanges(pm);
                }
            }
        };
        Shell shell = this.getSite().getShell();
        try {
            operation.run(progressMonitor);
            this.firePropertyChange(257);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException x) {
            String title = Utilities.getString("CompareEditor.saveError.title");
            String reason = x.getTargetException().getMessage();
            MessageDialog.openError((Shell)shell, (String)title, (String)Utilities.getFormattedString("CompareEditor.cantSaveError", reason));
        }
    }

    public boolean isDirty() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof CompareEditorInput) {
            return ((CompareEditorInput)input).isSaveNeeded();
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object old_value = event.getOldValue();
        Object new_value = event.getNewValue();
        if (old_value == null || new_value == null || !old_value.equals(new_value)) {
            this.firePropertyChange(257);
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            CompareEditor.this.propertyChange(event);
        }
    }
}

