/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.AbstractViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class BinaryCompareViewer
extends AbstractViewer {
    private static final String BUNDLE_NAME = "org.eclipse.compare.internal.BinaryCompareViewerResources";
    private static final int EOF = -1;
    private Text fControl;
    private ICompareInput fInput;
    private ResourceBundle fBundle;
    private boolean fLeftIsLocal;

    public BinaryCompareViewer(Composite parent, CompareConfiguration cc) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.compare.binary_compare_view_context");
        this.fBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this.fControl = new Text(parent, 0);
        this.fControl.setEditable(false);
        this.fControl.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Utilities.getString(this.fBundle, "title"));
        this.fLeftIsLocal = Utilities.getBoolean(cc, "LEFT_IS_LOCAL", false);
    }

    public Control getControl() {
        return this.fControl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInput(Object input) {
        String message;
        InputStream right;
        block22: {
            if (this.fControl == null) return;
            if (!(input instanceof ICompareInput)) return;
            this.fInput = (ICompareInput)input;
            InputStream left = null;
            right = null;
            message = null;
            try {
                block21: {
                    int pos;
                    block20: {
                        try {
                            left = this.getStream(this.fInput.getLeft());
                            right = this.getStream(this.fInput.getRight());
                            if (left != null && right != null) {
                                pos = 0;
                                break block20;
                            }
                            if (left == null && right == null) {
                                message = Utilities.getString(this.fBundle, "deleteConflictMessage");
                                break block21;
                            }
                            if (left == null) {
                                message = this.fLeftIsLocal ? Utilities.getString(this.fBundle, "deletedMessage") : Utilities.getString(this.fBundle, "addedMessage");
                                break block21;
                            }
                            if (right != null) break block21;
                            if (this.fLeftIsLocal) {
                                message = Utilities.getString(this.fBundle, "addedMessage");
                                break block21;
                            }
                            message = Utilities.getString(this.fBundle, "deletedMessage");
                        }
                        catch (CoreException coreException) {
                            message = Utilities.getString(this.fBundle, "errorMessage");
                        }
                        catch (IOException iOException) {
                            message = Utilities.getString(this.fBundle, "errorMessage");
                        }
                        break block21;
                    }
                    while (true) {
                        int r;
                        int l;
                        if ((l = left.read()) != (r = right.read())) {
                            String format = Utilities.getString(this.fBundle, "diffMessageFormat");
                            message = MessageFormat.format(format, Integer.toString(pos));
                            break;
                        }
                        if (l == -1) break;
                        ++pos;
                    }
                }
                Object var9_11 = null;
                if (left == null) break block22;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (left != null) {
                    try {
                        left.close();
                    }
                    catch (IOException iOException) {}
                }
                if (right == null) throw throwable;
                try {
                    right.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            left.close();
        }
        if (right != null) {
            try {}
            catch (IOException iOException) {}
            right.close();
        }
        if (message == null) return;
        this.fControl.setText(message);
    }

    public Object getInput() {
        return this.fInput;
    }

    private InputStream getStream(ITypedElement input) throws CoreException {
        if (input instanceof IStreamContentAccessor) {
            return ((IStreamContentAccessor)((Object)input)).getContents();
        }
        return null;
    }
}

