/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.CompareNavigator;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ISavable;
import org.eclipse.compare.internal.IgnoreWhiteSpaceAction;
import org.eclipse.compare.internal.ShowPseudoConflicts;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public abstract class CompareEditorInput
implements IEditorInput,
IPropertyChangeNotifier,
IRunnableWithProgress {
    private static final boolean DEBUG = false;
    public static final String DIRTY_STATE = "DIRTY_STATE";
    private static final String COMPARE_EDITOR_IMAGE_NAME = "cview16/compare_view.gif";
    private static Image fgTitleImage;
    private Splitter fComposite;
    private CompareConfiguration fCompareConfiguration;
    private CompareViewerSwitchingPane fStructureInputPane;
    private CompareViewerSwitchingPane fStructurePane1;
    private CompareViewerSwitchingPane fStructurePane2;
    private CompareViewerSwitchingPane fContentInputPane;
    private CompareViewerSwitchingPane fFocusPane;
    private String fMessage;
    private Object fInput;
    private String fTitle;
    private ListenerList fListenerList = new ListenerList();
    private CompareNavigator fNavigator;
    private boolean fDirty = false;
    private ArrayList fDirtyViewers = new ArrayList();
    private IPropertyChangeListener fDirtyStateListener;
    private IgnoreWhiteSpaceAction fIgnoreWhitespace;
    private ShowPseudoConflicts fShowPseudoConflicts;
    boolean fStructureCompareOnSingleClick = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CompareEditorInput(CompareConfiguration configuration) {
        this.fCompareConfiguration = configuration;
        Assert.isNotNull((Object)configuration);
        ResourceBundle bundle = CompareUIPlugin.getResourceBundle();
        this.fIgnoreWhitespace = new IgnoreWhiteSpaceAction(bundle, configuration);
        this.fShowPseudoConflicts = new ShowPseudoConflicts(bundle, configuration);
        this.fDirtyStateListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getProperty();
                if (CompareEditorInput.DIRTY_STATE.equals(propertyName)) {
                    boolean changed = false;
                    Object newValue = e.getNewValue();
                    if (newValue instanceof Boolean) {
                        changed = (Boolean)newValue;
                    }
                    CompareEditorInput.this.setDirty(e.getSource(), changed);
                }
            }
        };
        IPreferenceStore ps = configuration.getPreferenceStore();
        if (ps != null) {
            this.fStructureCompareOnSingleClick = ps.getBoolean("org.eclipse.compare.OpenStructureCompare");
        }
    }

    private boolean structureCompareOnSingleClick() {
        return this.fStructureCompareOnSingleClick;
    }

    public Object getAdapter(Class adapter) {
        block13: {
            block12: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.compare.ICompareNavigator;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(adapter)) break block12;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("[Lorg.eclipse.compare.internal.CompareNavigator;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.equals(adapter)) break block13;
            }
            if (this.fNavigator == null) {
                this.fNavigator = new CompareNavigator(new CompareViewerSwitchingPane[]{this.fStructureInputPane, this.fStructurePane1, this.fStructurePane2, this.fContentInputPane});
            }
            return this.fNavigator;
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getToolTipText() {
        return this.getTitle();
    }

    public String getName() {
        return this.getTitle();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean exists() {
        return false;
    }

    protected void setMessage(String message) {
        this.fMessage = message;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String getTitle() {
        if (this.fTitle == null) {
            return Utilities.getString("CompareEditorInput.defaultTitle");
        }
        return this.fTitle;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public Image getTitleImage() {
        if (fgTitleImage == null) {
            fgTitleImage = CompareUIPlugin.getImageDescriptor(COMPARE_EDITOR_IMAGE_NAME).createImage();
            CompareUI.disposeOnShutdown(fgTitleImage);
        }
        return fgTitleImage;
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.fCompareConfiguration;
    }

    public void contributeToToolBar(ToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.fIgnoreWhitespace);
        toolBarManager.add((IAction)this.fShowPseudoConflicts);
    }

    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        this.fInput = this.prepareInput(monitor);
    }

    protected abstract Object prepareInput(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    public Object getCompareResult() {
        return this.fInput;
    }

    public Control createContents(Composite parent) {
        this.fComposite = new Splitter(parent, 512);
        this.fComposite.setData(this);
        Splitter h = new Splitter((Composite)this.fComposite, 256);
        this.fFocusPane = this.fStructureInputPane = new CompareViewerSwitchingPane((Composite)h, 0x800800, true){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                DiffNode dn;
                if (input instanceof DiffNode && (dn = (DiffNode)input).hasChildren()) {
                    return CompareEditorInput.this.createDiffViewer((Composite)this);
                }
                if (input instanceof ICompareInput) {
                    return CompareEditorInput.this.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this);
                }
                return null;
            }
        };
        this.fStructurePane1 = new CompareViewerSwitchingPane((Composite)h, 0x800800, true){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (input instanceof ICompareInput) {
                    return CompareEditorInput.this.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this);
                }
                return null;
            }
        };
        h.setVisible((Control)this.fStructurePane1, false);
        this.fStructurePane2 = new CompareViewerSwitchingPane((Composite)h, 0x800800, true){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (input instanceof ICompareInput) {
                    return CompareEditorInput.this.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this);
                }
                return null;
            }
        };
        h.setVisible((Control)this.fStructurePane2, false);
        this.fContentInputPane = new CompareViewerSwitchingPane((Composite)this.fComposite, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (input instanceof ICompareInput) {
                    return CompareEditorInput.this.findContentViewer(oldViewer, (ICompareInput)input, (Composite)this);
                }
                return null;
            }
        };
        this.fComposite.setVisible((Control)h, false);
        this.fComposite.setVisible((Control)this.fContentInputPane, true);
        this.fComposite.setWeights(new int[]{30, 70});
        this.fComposite.layout();
        this.fStructureInputPane.addOpenListener(new IOpenListener(){

            public void open(OpenEvent oe) {
                CompareEditorInput.this.feed1(oe.getSelection());
            }
        });
        this.fStructureInputPane.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ISelection s = e.getSelection();
                if (s == null || s.isEmpty()) {
                    CompareEditorInput.this.feed1(s);
                }
            }
        });
        this.fStructureInputPane.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CompareEditorInput.this.feedDefault1(event.getSelection());
            }
        });
        this.fStructurePane1.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CompareEditorInput.this.feed2(e.getSelection());
            }
        });
        this.fStructurePane2.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CompareEditorInput.this.feed3(e.getSelection());
            }
        });
        if (this.fInput instanceof ICompareInput) {
            this.fStructureInputPane.setInput(this.fInput);
            ISelection sel = this.fStructureInputPane.getSelection();
            if (sel == null || sel.isEmpty()) {
                this.feed1(sel);
            }
        }
        this.fComposite.setData("Nav", new CompareViewerSwitchingPane[]{this.fStructureInputPane, this.fStructurePane1, this.fStructurePane2, this.fContentInputPane});
        return this.fComposite;
    }

    private void feed1(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (selection == null || selection.isEmpty()) {
                    Object input = CompareEditorInput.this.fStructureInputPane.getInput();
                    CompareEditorInput.this.fContentInputPane.setInput(input);
                    CompareEditorInput.this.fStructurePane2.setInput(null);
                    CompareEditorInput.this.fStructurePane1.setInput(null);
                } else {
                    Object input = CompareEditorInput.getElement(selection);
                    CompareEditorInput.this.fContentInputPane.setInput(input);
                    if (CompareEditorInput.this.structureCompareOnSingleClick()) {
                        CompareEditorInput.this.fStructurePane1.setInput(input);
                    }
                    CompareEditorInput.this.fStructurePane2.setInput(null);
                    if (CompareEditorInput.this.fStructurePane1.getInput() != input) {
                        CompareEditorInput.this.fStructurePane1.setInput(null);
                    }
                }
            }
        });
    }

    private void feedDefault1(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (!selection.isEmpty()) {
                    CompareEditorInput.this.fStructurePane1.setInput(CompareEditorInput.getElement(selection));
                }
            }
        });
    }

    private void feed2(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (selection.isEmpty()) {
                    Object input = CompareEditorInput.this.fStructurePane1.getInput();
                    CompareEditorInput.this.fContentInputPane.setInput(input);
                    CompareEditorInput.this.fStructurePane2.setInput(null);
                } else {
                    Object input = CompareEditorInput.getElement(selection);
                    CompareEditorInput.this.fContentInputPane.setInput(input);
                    CompareEditorInput.this.fStructurePane2.setInput(input);
                }
            }
        });
    }

    private void feed3(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (selection.isEmpty()) {
                    CompareEditorInput.this.fContentInputPane.setInput(CompareEditorInput.this.fStructurePane2.getInput());
                } else {
                    CompareEditorInput.this.fContentInputPane.setInput(CompareEditorInput.getElement(selection));
                }
            }
        });
    }

    private static Object getElement(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement();
        }
        return null;
    }

    public void setFocus() {
        if (this.fFocusPane != null) {
            Control c;
            Viewer v = this.fFocusPane.getViewer();
            if (v != null && (c = v.getControl()) != null) {
                c.setFocus();
            }
        } else if (this.fComposite != null) {
            this.fComposite.setFocus();
        }
    }

    public Viewer createDiffViewer(Composite parent) {
        return new DiffTreeViewer(parent, this.fCompareConfiguration);
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        return CompareUIPlugin.findStructureViewer(oldViewer, input, parent, this.fCompareConfiguration);
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        boolean isNewViewer;
        Viewer newViewer = CompareUIPlugin.findContentViewer(oldViewer, input, parent, this.fCompareConfiguration);
        boolean bl = isNewViewer = newViewer != oldViewer;
        if (isNewViewer && newViewer instanceof IPropertyChangeNotifier) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
            dsp.addPropertyChangeListener(this.fDirtyStateListener);
            Control c = newViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dsp.removePropertyChangeListener(CompareEditorInput.this.fDirtyStateListener);
                }
            });
        }
        return newViewer;
    }

    public boolean isSaveNeeded() {
        return this.fDirty || this.fDirtyViewers.size() > 0;
    }

    public void setDirty(boolean dirty) {
        boolean confirmSave = true;
        Object o = this.fCompareConfiguration.getProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY");
        if (o instanceof Boolean) {
            confirmSave = (Boolean)o;
        }
        if (!confirmSave) {
            this.fDirty = dirty;
            if (!this.fDirty) {
                this.fDirtyViewers.clear();
            }
        }
    }

    private void setDirty(Object source, boolean dirty) {
        boolean newDirty;
        boolean oldDirty;
        Assert.isNotNull((Object)source);
        boolean bl = oldDirty = this.fDirtyViewers.size() > 0;
        if (dirty) {
            this.fDirtyViewers.add(source);
        } else {
            this.fDirtyViewers.remove(source);
        }
        boolean bl2 = newDirty = this.fDirtyViewers.size() > 0;
        if (oldDirty != newDirty) {
            Utilities.firePropertyChange(this.fListenerList, this, DIRTY_STATE, new Boolean(oldDirty), new Boolean(newDirty));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.fListenerList.add((Object)listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.fListenerList.remove((Object)listener);
        }
    }

    public void save(IProgressMonitor pm) {
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        CompareEditorInput.flushViewer(this.fStructureInputPane, pm);
        CompareEditorInput.flushViewer(this.fStructurePane1, pm);
        CompareEditorInput.flushViewer(this.fStructurePane2, pm);
        CompareEditorInput.flushViewer(this.fContentInputPane, pm);
        this.save(pm);
    }

    private static void flushViewer(CompareViewerSwitchingPane pane, IProgressMonitor pm) throws CoreException {
        Viewer v;
        if (pane != null && (v = pane.getViewer()) instanceof ISavable) {
            ((ISavable)v).save(pm);
        }
    }
}

