/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.util.HashMap;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DiffImage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;

public class CompareConfiguration {
    public static final String IGNORE_WHITESPACE = "IGNORE_WHITESPACE";
    public static final String SHOW_PSEUDO_CONFLICTS = "SHOW_PSEUDO_CONFLICTS";
    private static final int WIDTH = 22;
    private static ImageDescriptor[] fgImages = new ImageDescriptor[16];
    private static Object fgDummy = new Object();
    private static HashMap fgMap = new HashMap(20);
    private static boolean fLeftIsLocal = true;
    private IPreferenceStore fPreferenceStore;
    private ListenerList fListeners = new ListenerList();
    private HashMap fProperties = new HashMap();
    private boolean fLeftEditable = true;
    private boolean fRightEditable = true;
    private String fAncestorLabel;
    private String fLeftLabel;
    private String fRightLabel;
    private Image fAncestorImage;
    private Image fRightImage;
    private Image fLeftImage;
    private Image[] fImages = new Image[16];

    static {
        if (fLeftIsLocal) {
            CompareConfiguration.fgImages[1] = CompareUIPlugin.getImageDescriptor("ovr16/del_ov.gif");
            CompareConfiguration.fgImages[5] = CompareUIPlugin.getImageDescriptor("ovr16/r_inadd_ov.gif");
            CompareConfiguration.fgImages[9] = CompareUIPlugin.getImageDescriptor("ovr16/r_outadd_ov.gif");
            CompareConfiguration.fgImages[2] = CompareUIPlugin.getImageDescriptor("ovr16/add_ov.gif");
            CompareConfiguration.fgImages[6] = CompareUIPlugin.getImageDescriptor("ovr16/r_indel_ov.gif");
            CompareConfiguration.fgImages[10] = CompareUIPlugin.getImageDescriptor("ovr16/r_outdel_ov.gif");
            CompareConfiguration.fgImages[7] = CompareUIPlugin.getImageDescriptor("ovr16/r_inchg_ov.gif");
            CompareConfiguration.fgImages[11] = CompareUIPlugin.getImageDescriptor("ovr16/r_outchg_ov.gif");
        } else {
            CompareConfiguration.fgImages[1] = CompareUIPlugin.getImageDescriptor("ovr16/add_ov.gif");
            CompareConfiguration.fgImages[5] = CompareUIPlugin.getImageDescriptor("ovr16/inadd_ov.gif");
            CompareConfiguration.fgImages[9] = CompareUIPlugin.getImageDescriptor("ovr16/outadd_ov.gif");
            CompareConfiguration.fgImages[2] = CompareUIPlugin.getImageDescriptor("ovr16/del_ov.gif");
            CompareConfiguration.fgImages[6] = CompareUIPlugin.getImageDescriptor("ovr16/indel_ov.gif");
            CompareConfiguration.fgImages[10] = CompareUIPlugin.getImageDescriptor("ovr16/outdel_ov.gif");
            CompareConfiguration.fgImages[7] = CompareUIPlugin.getImageDescriptor("ovr16/inchg_ov.gif");
            CompareConfiguration.fgImages[11] = CompareUIPlugin.getImageDescriptor("ovr16/outchg_ov.gif");
        }
        CompareConfiguration.fgImages[13] = CompareUIPlugin.getImageDescriptor("ovr16/confadd_ov.gif");
        CompareConfiguration.fgImages[14] = CompareUIPlugin.getImageDescriptor("ovr16/confdel_ov.gif");
        CompareConfiguration.fgImages[15] = CompareUIPlugin.getImageDescriptor("ovr16/confchg_ov.gif");
    }

    public CompareConfiguration(IPreferenceStore prefStore) {
        this.setProperty("LEFT_IS_LOCAL", new Boolean(fLeftIsLocal));
        this.fPreferenceStore = prefStore;
        if (this.fPreferenceStore != null) {
            boolean b = this.fPreferenceStore.getBoolean("org.eclipse.compare.InitiallyShowAncestorPane");
            this.setProperty("org.eclipse.compare.InitiallyShowAncestorPane", new Boolean(b));
            b = this.fPreferenceStore.getBoolean("org.eclipse.compare.IgnoreWhitespace");
            this.setProperty(IGNORE_WHITESPACE, new Boolean(b));
        }
    }

    public CompareConfiguration() {
        this(CompareUIPlugin.getDefault().getPreferenceStore());
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    public Image getImage(int kind) {
        Image image = this.fImages[kind & 0xF];
        if (image == null) {
            ImageDescriptor id = fgImages[kind & 0xF];
            if (id != null) {
                image = id.createImage();
            }
            this.fImages[kind & 0xF] = image;
        }
        return image;
    }

    public Image getImage(Image base, int kind) {
        Image b;
        Object key = base;
        if (key == null) {
            key = fgDummy;
        }
        kind &= 0xF;
        Image[] a = (Image[])fgMap.get(key);
        if (a == null) {
            a = new Image[16];
            fgMap.put(key, a);
        }
        if ((b = a[kind]) == null) {
            b = new DiffImage(base, fgImages[kind], 22, !fLeftIsLocal).createImage();
            CompareUI.disposeOnShutdown(b);
            a[kind] = b;
        }
        return b;
    }

    public void dispose() {
        if (this.fImages != null) {
            int i = 0;
            while (i < this.fImages.length) {
                Image image = this.fImages[i];
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                ++i;
            }
        }
        this.fImages = null;
    }

    private void fireChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = null;
        Object[] listeners = this.fListeners.getListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                if (event == null) {
                    event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
                }
                l.propertyChange(event);
                ++i;
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setProperty(String key, Object newValue) {
        Object oldValue = this.fProperties.get(key);
        this.fProperties.put(key, newValue);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.fireChange(key, oldValue, newValue);
        }
    }

    public Object getProperty(String key) {
        return this.fProperties.get(key);
    }

    public void setAncestorLabel(String label) {
        this.fAncestorLabel = label;
    }

    public String getAncestorLabel(Object element) {
        return this.fAncestorLabel;
    }

    public void setAncestorImage(Image image) {
        this.fAncestorImage = image;
    }

    public Image getAncestorImage(Object element) {
        return this.fAncestorImage;
    }

    public void setLeftEditable(boolean editable) {
        this.fLeftEditable = editable;
    }

    public boolean isLeftEditable() {
        return this.fLeftEditable;
    }

    public void setLeftLabel(String label) {
        this.fLeftLabel = label;
    }

    public String getLeftLabel(Object element) {
        return this.fLeftLabel;
    }

    public void setLeftImage(Image image) {
        this.fLeftImage = image;
    }

    public Image getLeftImage(Object element) {
        return this.fLeftImage;
    }

    public void setRightEditable(boolean editable) {
        this.fRightEditable = editable;
    }

    public boolean isRightEditable() {
        return this.fRightEditable;
    }

    public void setRightLabel(String label) {
        this.fRightLabel = label;
    }

    public String getRightLabel(Object element) {
        return this.fRightLabel;
    }

    public void setRightImage(Image image) {
        this.fRightImage = image;
    }

    public Image getRightImage(Object element) {
        return this.fRightImage;
    }
}

