/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.CompositeId;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.ListenerList;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntryResolver;
import org.eclipse.jdt.internal.launching.RuntimeClasspathProvider;
import org.eclipse.jdt.internal.launching.SocketAttachConnector;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;
import org.eclipse.jdt.launching.IRuntimeContainerComparator;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.jdt.launching.StandardSourcePathProvider;
import org.eclipse.jdt.launching.VMStandin;

public final class JavaRuntime {
    public static final String JRELIB_VARIABLE = "JRE_LIB";
    public static final String JRESRC_VARIABLE = "JRE_SRC";
    public static final String JRESRCROOT_VARIABLE = "JRE_SRCROOT";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRY_RESOLVERS = "runtimeClasspathEntryResolvers";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_PROVIDERS = "classpathProviders";
    public static final String JRE_CONTAINER = String.valueOf(LaunchingPlugin.getUniqueIdentifier()) + ".JRE_CONTAINER";
    public static final int ERR_UNABLE_TO_RESOLVE_JRE = 160;
    public static final String PREF_CONNECT_TIMEOUT = String.valueOf(LaunchingPlugin.getUniqueIdentifier()) + ".PREF_CONNECT_TIMEOUT";
    public static final String PREF_VM_XML = String.valueOf(LaunchingPlugin.getUniqueIdentifier()) + ".PREF_VM_XML";
    public static final int DEF_CONNECT_TIMEOUT = 20000;
    public static final String ATTR_CMDLINE = String.valueOf(LaunchingPlugin.getUniqueIdentifier()) + ".launcher.cmdLine";
    private static IVMInstallType[] fgVMTypes = null;
    private static String fgDefaultVMId = null;
    private static String fgDefaultVMConnectorId = null;
    private static Map fgVariableResolvers = null;
    private static Map fgContainerResolvers = null;
    private static Map fgPathProviders = null;
    private static IRuntimeClasspathProvider fgDefaultClasspathProvider = new StandardClasspathProvider();
    private static IRuntimeClasspathProvider fgDefaultSourcePathProvider = new StandardSourcePathProvider();
    private static ListenerList fgVMListeners = new ListenerList(5);

    private JavaRuntime() {
    }

    private static synchronized void initializeVMTypes() {
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint(String.valueOf(LaunchingPlugin.getUniqueIdentifier()) + ".vmInstallTypes");
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.getString("JavaRuntime.exceptionOccurred"), null);
        fgVMTypes = new IVMInstallType[configs.length];
        int i = 0;
        while (i < configs.length) {
            try {
                IVMInstallType vmType;
                JavaRuntime.fgVMTypes[i] = vmType = (IVMInstallType)configs[i].createExecutableExtension("class");
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            LaunchingPlugin.log((IStatus)status);
            ArrayList<IVMInstallType> temp = new ArrayList<IVMInstallType>(fgVMTypes.length);
            int i2 = 0;
            while (i2 < fgVMTypes.length) {
                if (fgVMTypes[i2] != null) {
                    temp.add(fgVMTypes[i2]);
                }
                fgVMTypes = new IVMInstallType[temp.size()];
                fgVMTypes = temp.toArray(fgVMTypes);
                ++i2;
            }
        }
        try {
            JavaRuntime.initializeVMConfiguration();
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        catch (ParserConfigurationException e) {
            LaunchingPlugin.log(e);
        }
        catch (TransformerException e) {
            LaunchingPlugin.log(e);
        }
    }

    public static IVMInstall getVMInstall(IJavaProject project) throws CoreException {
        IVMInstall vm = null;
        IClasspathEntry[] classpath = project.getRawClasspath();
        IRuntimeClasspathEntryResolver resolver = null;
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            switch (entry.getEntryKind()) {
                case 4: {
                    resolver = JavaRuntime.getVariableResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    vm = resolver.resolveVMInstall(entry);
                    break;
                }
                case 5: {
                    resolver = JavaRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    vm = resolver.resolveVMInstall(entry);
                }
            }
            if (vm != null) {
                return vm;
            }
            ++i;
        }
        return null;
    }

    public static IVMInstallType getVMInstallType(String id) {
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            if (vmTypes[i].getId().equals(id)) {
                return vmTypes[i];
            }
            ++i;
        }
        return null;
    }

    public static void setDefaultVMInstall(IVMInstall vm, IProgressMonitor monitor) throws CoreException {
        JavaRuntime.setDefaultVMInstall(vm, monitor, true);
    }

    public static void setDefaultVMInstall(IVMInstall vm, IProgressMonitor monitor, boolean savePreference) throws CoreException {
        IVMInstall previous = null;
        if (fgDefaultVMId != null) {
            previous = JavaRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        fgDefaultVMId = JavaRuntime.getCompositeIdFromVM(vm);
        if (savePreference) {
            JavaRuntime.saveVMConfiguration();
        }
        IVMInstall current = null;
        if (fgDefaultVMId != null) {
            current = JavaRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        if (previous != current) {
            JavaRuntime.notifyDefaultVMChanged(previous, current);
        }
    }

    public static void setDefaultVMConnector(IVMConnector connector, IProgressMonitor monitor) throws CoreException {
        fgDefaultVMConnectorId = connector.getIdentifier();
        JavaRuntime.saveVMConfiguration();
    }

    public static IVMInstall getDefaultVMInstall() {
        IVMInstall install = JavaRuntime.getVMFromCompositeId(JavaRuntime.getDefaultVMId());
        if (install != null && install.getInstallLocation().exists()) {
            return install;
        }
        if (install != null) {
            install.getVMInstallType().disposeVMInstall(install.getId());
        }
        fgDefaultVMId = null;
        JavaRuntime.detectDefaultVM();
        try {
            JavaRuntime.saveVMConfiguration();
        }
        catch (CoreException e) {
            LaunchingPlugin.log(e);
        }
        return JavaRuntime.getVMFromCompositeId(JavaRuntime.getDefaultVMId());
    }

    public static IVMConnector getDefaultVMConnector() {
        String id = JavaRuntime.getDefaultVMConnectorId();
        IVMConnector connector = null;
        if (id != null) {
            connector = JavaRuntime.getVMConnector(id);
        }
        if (connector == null) {
            connector = new SocketAttachConnector();
        }
        return connector;
    }

    public static IVMInstallType[] getVMInstallTypes() {
        if (fgVMTypes == null) {
            JavaRuntime.initializeVMTypes();
        }
        return fgVMTypes;
    }

    private static String getDefaultVMId() {
        if (fgVMTypes == null) {
            JavaRuntime.initializeVMTypes();
        }
        return fgDefaultVMId;
    }

    private static String getDefaultVMConnectorId() {
        if (fgVMTypes == null) {
            JavaRuntime.initializeVMTypes();
        }
        return fgDefaultVMConnectorId;
    }

    public static String getCompositeIdFromVM(IVMInstall vm) {
        if (vm == null) {
            return null;
        }
        IVMInstallType vmType = vm.getVMInstallType();
        String typeID = vmType.getId();
        CompositeId id = new CompositeId(new String[]{typeID, vm.getId()});
        return id.toString();
    }

    public static IVMInstall getVMFromCompositeId(String idString) {
        IVMInstallType vmType;
        if (idString == null || idString.length() == 0) {
            return null;
        }
        CompositeId id = CompositeId.fromString(idString);
        if (id.getPartCount() == 2 && (vmType = JavaRuntime.getVMInstallType(id.get(0))) != null) {
            return vmType.findVMInstall(id.get(1));
        }
        return null;
    }

    public static IRuntimeClasspathEntry newProjectRuntimeClasspathEntry(IJavaProject project) {
        IClasspathEntry cpe = JavaCore.newProjectEntry((IPath)project.getProject().getFullPath());
        return JavaRuntime.newRuntimeClasspathEntry(cpe);
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IResource resource) {
        IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)resource.getFullPath(), null, null);
        return JavaRuntime.newRuntimeClasspathEntry(cpe);
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IPath path) {
        IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)path, null, null);
        return JavaRuntime.newRuntimeClasspathEntry(cpe);
    }

    public static IRuntimeClasspathEntry newVariableRuntimeClasspathEntry(IPath path) {
        IClasspathEntry cpe = JavaCore.newVariableEntry((IPath)path, null, null);
        return JavaRuntime.newRuntimeClasspathEntry(cpe);
    }

    public static IRuntimeClasspathEntry newRuntimeContainerClasspathEntry(IPath path, int classpathProperty) throws CoreException {
        IClasspathEntry cpe = JavaCore.newContainerEntry((IPath)path);
        return new RuntimeClasspathEntry(cpe, classpathProperty);
    }

    public static IRuntimeClasspathEntry newRuntimeClasspathEntry(String memento) throws CoreException {
        return new RuntimeClasspathEntry(memento);
    }

    private static IRuntimeClasspathEntry newRuntimeClasspathEntry(IClasspathEntry entry) {
        return new RuntimeClasspathEntry(entry);
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeClasspath(IJavaProject project) throws CoreException {
        IClasspathEntry entry = JavaCore.newProjectEntry((IPath)project.getProject().getFullPath());
        ArrayList classpathEntries = new ArrayList(5);
        ArrayList expanding = new ArrayList(5);
        JavaRuntime.expandProject(entry, classpathEntries, expanding);
        IRuntimeClasspathEntry[] runtimeEntries = new IRuntimeClasspathEntry[classpathEntries == null ? 0 : classpathEntries.size()];
        int i = 0;
        while (i < runtimeEntries.length) {
            Object e = classpathEntries.get(i);
            if (e instanceof IClasspathEntry) {
                IClasspathEntry cpe = (IClasspathEntry)e;
                runtimeEntries[i] = JavaRuntime.newRuntimeClasspathEntry(cpe);
            } else {
                runtimeEntries[i] = (IRuntimeClasspathEntry)e;
            }
            ++i;
        }
        IRuntimeClasspathEntry[] ordered = new IRuntimeClasspathEntry[runtimeEntries.length];
        int index = 0;
        int i2 = 0;
        while (i2 < runtimeEntries.length) {
            if (runtimeEntries[i2].getClasspathProperty() != 3) {
                ordered[index] = runtimeEntries[i2];
                ++index;
                runtimeEntries[i2] = null;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < runtimeEntries.length) {
            if (runtimeEntries[i2] != null) {
                ordered[index] = runtimeEntries[i2];
                ++index;
            }
            ++i2;
        }
        return ordered;
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedSourceLookupPath(ILaunchConfiguration configuration) throws CoreException {
        return JavaRuntime.getSourceLookupPathProvider(configuration).computeUnresolvedClasspath(configuration);
    }

    public static IRuntimeClasspathEntry[] resolveSourceLookupPath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        return JavaRuntime.getSourceLookupPathProvider(configuration).resolveClasspath(entries, configuration);
    }

    public static IRuntimeClasspathProvider getClasspathProvider(ILaunchConfiguration configuration) throws CoreException {
        String providerId = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
        IRuntimeClasspathProvider provider = null;
        if (providerId == null) {
            provider = fgDefaultClasspathProvider;
        } else {
            provider = (IRuntimeClasspathProvider)JavaRuntime.getClasspathProviders().get(providerId);
            if (provider == null) {
                JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.26"), providerId), null);
            }
        }
        return provider;
    }

    public static IRuntimeClasspathProvider getSourceLookupPathProvider(ILaunchConfiguration configuration) throws CoreException {
        String providerId = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        IRuntimeClasspathProvider provider = null;
        if (providerId == null) {
            provider = fgDefaultSourcePathProvider;
        } else {
            provider = (IRuntimeClasspathProvider)JavaRuntime.getClasspathProviders().get(providerId);
            if (provider == null) {
                JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.27"), providerId), null);
            }
        }
        return provider;
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        switch (entry.getType()) {
            case 1: {
                IResource resource = entry.getResource();
                if (resource instanceof IProject) {
                    IRuntimeClasspathEntry[] entries;
                    IJavaProject project = JavaCore.create((IProject)((IProject)resource));
                    if (project == null || !project.exists()) {
                        JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.Classpath_references_non-existant_project__{0}_1"), entry.getPath().lastSegment()), null);
                    }
                    if (!project.getProject().isOpen()) {
                        JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.Classpath_references_closed_project__{0}_2"), entry.getPath().lastSegment()), null);
                    }
                    if ((entries = JavaRuntime.resolveOutputLocations(project, entry.getClasspathProperty())) == null) break;
                    return entries;
                }
                JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.Classpath_references_non-existant_project__{0}_3"), entry.getPath().lastSegment()), null);
                break;
            }
            case 3: {
                IRuntimeClasspathEntryResolver resolver = JavaRuntime.getVariableResolver(entry.getVariableName());
                if (resolver == null) {
                    IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveVariableEntry(entry, null, configuration);
                    if (resolved == null) break;
                    return resolved;
                }
                return resolver.resolveRuntimeClasspathEntry(entry, configuration);
            }
            case 4: {
                IRuntimeClasspathEntryResolver resolver = JavaRuntime.getContainerResolver(entry.getVariableName());
                if (resolver == null) {
                    return JavaRuntime.computeDefaultContainerEntries(entry, configuration);
                }
                return resolver.resolveRuntimeClasspathEntry(entry, configuration);
            }
            case 2: {
                File file;
                String location = entry.getLocation();
                if (location == null) {
                    JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.Classpath_references_non-existant_archive__{0}_4"), entry.getPath().toString()), null);
                }
                if ((file = new File(location)).exists()) break;
                JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.Classpath_references_non-existant_archive__{0}_4"), entry.getPath().toString()), null);
                break;
            }
        }
        return new IRuntimeClasspathEntry[]{entry};
    }

    private static IRuntimeClasspathEntry[] resolveVariableEntry(IRuntimeClasspathEntry entry, IJavaProject project, ILaunchConfiguration configuration) throws CoreException {
        IPath archPath = JavaCore.getClasspathVariable((String)entry.getVariableName());
        if (archPath != null) {
            if (entry.getPath().segmentCount() > 1) {
                archPath = archPath.append(entry.getPath().removeFirstSegments(1));
            }
            IPath srcPath = null;
            IPath srcVar = entry.getSourceAttachmentPath();
            IPath srcRootPath = null;
            IPath srcRootVar = entry.getSourceAttachmentRootPath();
            if (archPath != null && !archPath.isEmpty()) {
                if (srcVar != null && !srcVar.isEmpty() && (srcPath = JavaCore.getClasspathVariable((String)srcVar.segment(0))) != null) {
                    if (srcVar.segmentCount() > 1) {
                        srcPath = srcPath.append(srcVar.removeFirstSegments(1));
                    }
                    if (srcRootVar != null && !srcRootVar.isEmpty() && (srcRootPath = JavaCore.getClasspathVariable((String)srcRootVar.segment(0))) != null && srcRootVar.segmentCount() > 1) {
                        srcRootPath = srcRootPath.append(srcRootVar.removeFirstSegments(1));
                    }
                }
                IClasspathEntry archEntry = JavaCore.newLibraryEntry((IPath)archPath, srcPath, srcRootPath, (boolean)entry.getClasspathEntry().isExported());
                IRuntimeClasspathEntry runtimeArchEntry = JavaRuntime.newRuntimeClasspathEntry(archEntry);
                runtimeArchEntry.setClasspathProperty(entry.getClasspathProperty());
                if (configuration == null) {
                    return JavaRuntime.resolveRuntimeClasspathEntry(runtimeArchEntry, project);
                }
                return JavaRuntime.resolveRuntimeClasspathEntry(runtimeArchEntry, configuration);
            }
        }
        return null;
    }

    private static IRuntimeClasspathEntry[] resolveOutputLocations(IJavaProject project, int classpathProperty) throws CoreException {
        ArrayList<IPath> nonDefault = new ArrayList<IPath>();
        if (project.exists() && project.getProject().isOpen()) {
            IClasspathEntry[] entries = project.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IPath path;
                IClasspathEntry classpathEntry = entries[i];
                if (classpathEntry.getEntryKind() == 3 && (path = classpathEntry.getOutputLocation()) != null) {
                    nonDefault.add(path);
                }
                ++i;
            }
        }
        if (nonDefault.isEmpty()) {
            return null;
        }
        IPath def = project.getOutputLocation();
        if (!nonDefault.contains(def)) {
            nonDefault.add(def);
        }
        IRuntimeClasspathEntry[] locations = new IRuntimeClasspathEntry[nonDefault.size()];
        int i = 0;
        while (i < locations.length) {
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)((IPath)nonDefault.get(i)), null, null);
            locations[i] = new RuntimeClasspathEntry(newEntry);
            locations[i].setClasspathProperty(classpathProperty);
            ++i;
        }
        return locations;
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        switch (entry.getType()) {
            case 1: {
                IRuntimeClasspathEntry[] entries;
                IJavaProject jp;
                IResource resource = entry.getResource();
                if (!(resource instanceof IProject) || !(jp = JavaCore.create((IProject)((IProject)resource))).exists() || !jp.getProject().isOpen() || (entries = JavaRuntime.resolveOutputLocations(jp, entry.getClasspathProperty())) == null) break;
                return entries;
            }
            case 3: {
                IRuntimeClasspathEntryResolver resolver = JavaRuntime.getVariableResolver(entry.getVariableName());
                if (resolver == null) {
                    IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveVariableEntry(entry, project, null);
                    if (resolved == null) break;
                    return resolved;
                }
                return resolver.resolveRuntimeClasspathEntry(entry, project);
            }
            case 4: {
                IRuntimeClasspathEntryResolver resolver = JavaRuntime.getContainerResolver(entry.getVariableName());
                if (resolver == null) {
                    return JavaRuntime.computeDefaultContainerEntries(entry, project);
                }
                return resolver.resolveRuntimeClasspathEntry(entry, project);
            }
        }
        return new IRuntimeClasspathEntry[]{entry};
    }

    private static IRuntimeClasspathEntry[] computeDefaultContainerEntries(IRuntimeClasspathEntry entry, ILaunchConfiguration config) throws CoreException {
        return JavaRuntime.computeDefaultContainerEntries(entry, JavaRuntime.getJavaProject(config));
    }

    private static IRuntimeClasspathEntry[] computeDefaultContainerEntries(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        if (project == null || entry == null) {
            return new IRuntimeClasspathEntry[0];
        }
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
        if (container == null) {
            JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.Could_not_resolve_classpath_container__{0}_1"), entry.getPath().toString()), null);
            return null;
        }
        IClasspathEntry[] cpes = container.getClasspathEntries();
        int property = -1;
        switch (container.getKind()) {
            case 1: {
                property = 3;
                break;
            }
            case 3: {
                property = 1;
                break;
            }
            case 2: {
                property = 2;
            }
        }
        IRuntimeClasspathEntry[] resolved = new IRuntimeClasspathEntry[cpes.length];
        int i = 0;
        while (i < resolved.length) {
            resolved[i] = JavaRuntime.newRuntimeClasspathEntry(cpes[i]);
            resolved[i].setClasspathProperty(property);
            ++i;
        }
        return resolved;
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeClasspath(ILaunchConfiguration configuration) throws CoreException {
        return JavaRuntime.getClasspathProvider(configuration).computeUnresolvedClasspath(configuration);
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        return JavaRuntime.getClasspathProvider(configuration).resolveClasspath(entries, configuration);
    }

    public static IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (projectName == null || projectName.trim().length() < 1) {
            return null;
        }
        IJavaProject javaProject = JavaRuntime.getJavaModel().getJavaProject(projectName);
        if (javaProject != null && javaProject.getProject().exists() && !javaProject.getProject().isOpen()) {
            JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.28"), configuration.getName(), projectName), 124, null);
        }
        if (javaProject == null || !javaProject.exists()) {
            JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.Launch_configuration_{0}_references_non-existing_project_{1}._1"), configuration.getName(), projectName), 107, null);
        }
        return javaProject;
    }

    private static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    public static IVMInstall computeVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String type = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
        if (type == null) {
            IVMInstall vm;
            IJavaProject proj = JavaRuntime.getJavaProject(configuration);
            if (proj != null && (vm = JavaRuntime.getVMInstall(proj)) != null) {
                return vm;
            }
        } else {
            IVMInstallType vt = JavaRuntime.getVMInstallType(type);
            if (vt == null) {
                JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.Specified_VM_install_type_does_not_exist__{0}_2"), type), null);
            }
            IVMInstall vm = null;
            String name = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
            if (name == null) {
                Status status = new Status(2, LaunchingPlugin.getUniqueIdentifier(), 103, MessageFormat.format(LaunchingMessages.getString("JavaRuntime.VM_not_fully_specified_in_launch_configuration_{0}_-_missing_VM_name._Reverting_to_default_VM._1"), configuration.getName()), null);
                LaunchingPlugin.log((IStatus)status);
                return JavaRuntime.getDefaultVMInstall();
            }
            vm = vt.findVMInstallByName(name);
            if (vm == null) {
                JavaRuntime.abort(MessageFormat.format(LaunchingMessages.getString("JavaRuntime.Specified_VM_install_not_found__type_{0},_name_{1}_2"), vt.getName(), name), null);
            } else {
                return vm;
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        JavaRuntime.abort(message, 150, exception);
    }

    private static void abort(String message, int code, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    private static void expandProject(IClasspathEntry projectEntry, List expandedPath, List expanding) throws CoreException {
        expanding.add(projectEntry);
        IPath projectPath = projectEntry.getPath();
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(projectPath.lastSegment());
        if (res == null) {
            expandedPath.add(projectEntry);
            return;
        }
        IJavaProject project = (IJavaProject)JavaCore.create((IResource)res);
        if (project == null || !project.exists() || !project.getProject().isOpen()) {
            expandedPath.add(projectEntry);
            return;
        }
        IClasspathEntry[] buildPath = project.getRawClasspath();
        ArrayList<IClasspathEntry> unexpandedPath = new ArrayList<IClasspathEntry>(buildPath.length);
        boolean projectAdded = false;
        int i = 0;
        while (i < buildPath.length) {
            if (buildPath[i].getEntryKind() == 3) {
                if (!projectAdded) {
                    projectAdded = true;
                    unexpandedPath.add(projectEntry);
                }
            } else {
                unexpandedPath.add(buildPath[i]);
            }
            ++i;
        }
        Iterator iter = unexpandedPath.iterator();
        block11: while (iter.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iter.next();
            if (entry == projectEntry) {
                expandedPath.add(entry);
                continue;
            }
            switch (entry.getEntryKind()) {
                case 2: {
                    if (expanding.contains(entry)) continue block11;
                    JavaRuntime.expandProject(entry, expandedPath, expanding);
                    break;
                }
                case 5: {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    int property = -1;
                    if (container == null) continue block11;
                    switch (container.getKind()) {
                        case 1: {
                            property = 3;
                            break;
                        }
                        case 3: {
                            property = 1;
                            break;
                        }
                        case 2: {
                            property = 2;
                        }
                    }
                    IRuntimeClasspathEntry r = JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), property);
                    boolean duplicate = false;
                    int i2 = 0;
                    while (i2 < expandedPath.size()) {
                        IRuntimeClasspathEntry re;
                        Object o = expandedPath.get(i2);
                        if (o instanceof IRuntimeClasspathEntry && (re = (IRuntimeClasspathEntry)o).getType() == 4) {
                            if (container instanceof IRuntimeContainerComparator) {
                                duplicate = ((IRuntimeContainerComparator)container).isDuplicate(re.getPath());
                                if (duplicate) {
                                    break;
                                }
                            } else if (re.getVariableName().equals(r.getVariableName())) {
                                duplicate = true;
                                break;
                            }
                        }
                        ++i2;
                    }
                    if (duplicate) continue block11;
                    expandedPath.add(r);
                    break;
                }
                case 4: {
                    IRuntimeClasspathEntry r;
                    if (entry.getPath().segment(0).equals(JRELIB_VARIABLE)) {
                        r = JavaRuntime.newVariableRuntimeClasspathEntry(entry.getPath());
                        r.setSourceAttachmentPath(entry.getSourceAttachmentPath());
                        r.setSourceAttachmentRootPath(entry.getSourceAttachmentRootPath());
                        r.setClasspathProperty(1);
                        if (expandedPath.contains(r)) continue block11;
                        expandedPath.add(r);
                        break;
                    }
                }
                default: {
                    if (expandedPath.contains(entry)) continue block11;
                    expandedPath.add(entry);
                }
            }
        }
    }

    public static String[] computeDefaultRuntimeClassPath(IJavaProject jproject) throws CoreException {
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath(jproject);
        ArrayList<String> resolved = new ArrayList<String>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeClasspathEntry entry = unresolved[i];
            if (entry.getClasspathProperty() == 3) {
                IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspathEntry(entry, jproject);
                int j = 0;
                while (j < entries.length) {
                    String location = entries[j].getLocation();
                    if (location != null) {
                        resolved.add(location);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    public static void saveVMConfiguration() throws CoreException {
        if (fgVMTypes == null) {
            return;
        }
        try {
            String xml = JavaRuntime.getVMsAsXML();
            JavaRuntime.getPreferences().setValue(PREF_VM_XML, xml);
            JavaRuntime.savePreferences();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.getString("JavaRuntime.exceptionsOccurred"), (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.getString("JavaRuntime.exceptionsOccurred"), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.getString("JavaRuntime.exceptionsOccurred"), (Throwable)e));
        }
    }

    private static void saveVMDefinitions(String vmDefXML) {
        LaunchingPlugin.getDefault().getPluginPreferences().setValue(PREF_VM_XML, vmDefXML);
        LaunchingPlugin.getDefault().savePluginPreferences();
    }

    private static String getVMsAsXML() throws IOException, ParserConfigurationException, TransformerException {
        VMDefinitionsContainer container = new VMDefinitionsContainer();
        container.setDefaultVMInstallCompositeID(JavaRuntime.getDefaultVMId());
        container.setDefaultVMInstallConnectorTypeID(JavaRuntime.getDefaultVMConnectorId());
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            IVMInstall[] vms = vmTypes[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                IVMInstall install = vms[j];
                container.addVM(install);
                ++j;
            }
            ++i;
        }
        return container.getAsXML();
    }

    private static void initializeVMConfiguration() throws ParserConfigurationException, IOException, TransformerException {
        String vmXMLString = JavaRuntime.getPreferences().getString(PREF_VM_XML);
        if (vmXMLString.length() > 0) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(vmXMLString.getBytes());
                VMDefinitionsContainer vmDefs = VMDefinitionsContainer.parseXMLIntoContainer(inputStream);
                JavaRuntime.loadVMDefsIntoMemory(vmDefs);
            }
            catch (IOException ioe) {
                LaunchingPlugin.log(ioe);
            }
        } else {
            IPath stateLocation = LaunchingPlugin.getDefault().getStateLocation();
            IPath stateFile = stateLocation.append("vmConfiguration.xml");
            File file = new File(stateFile.toOSString());
            VMDefinitionsContainer vmDefs = null;
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                vmDefs = VMDefinitionsContainer.parseXMLIntoContainer(fileInputStream);
                JavaRuntime.loadVMDefsIntoMemory(vmDefs);
                LaunchingPlugin.getDefault().setIgnoreVMDefPropertyChangeEvents(true);
                JavaRuntime.saveVMDefinitions(vmDefs.getAsXML());
                LaunchingPlugin.getDefault().setIgnoreVMDefPropertyChangeEvents(false);
            } else {
                JavaRuntime.detectAndSaveVMDefinitions();
            }
        }
    }

    private static void loadVMDefsIntoMemory(VMDefinitionsContainer vmContainer) {
        fgDefaultVMId = vmContainer.getDefaultVMInstallCompositeID();
        fgDefaultVMConnectorId = vmContainer.getDefaultVMInstallConnectorTypeID();
        List vmList = vmContainer.getValidVMList();
        Iterator vmListIterator = vmList.iterator();
        while (vmListIterator.hasNext()) {
            VMStandin vmStandin = (VMStandin)vmListIterator.next();
            vmStandin.convertToRealVM();
        }
    }

    public static LibraryLocation[] getLibraryLocations(IVMInstall vm) {
        IPath[] sourceRootPaths;
        IPath[] sourcePaths;
        IPath[] libraryPaths;
        LibraryLocation[] locations = vm.getLibraryLocations();
        if (locations == null) {
            LibraryLocation[] dflts = vm.getVMInstallType().getDefaultLibraryLocations(vm.getInstallLocation());
            libraryPaths = new IPath[dflts.length];
            sourcePaths = new IPath[dflts.length];
            sourceRootPaths = new IPath[dflts.length];
            int i = 0;
            while (i < dflts.length) {
                libraryPaths[i] = dflts[i].getSystemLibraryPath();
                if (!libraryPaths[i].toFile().isFile()) {
                    libraryPaths[i] = Path.EMPTY;
                }
                sourcePaths[i] = dflts[i].getSystemLibrarySourcePath();
                if (sourcePaths[i].toFile().isFile()) {
                    sourceRootPaths[i] = dflts[i].getPackageRootPath();
                } else {
                    sourcePaths[i] = Path.EMPTY;
                    sourceRootPaths[i] = Path.EMPTY;
                }
                ++i;
            }
        } else {
            libraryPaths = new IPath[locations.length];
            sourcePaths = new IPath[locations.length];
            sourceRootPaths = new IPath[locations.length];
            int i = 0;
            while (i < locations.length) {
                libraryPaths[i] = locations[i].getSystemLibraryPath();
                sourcePaths[i] = locations[i].getSystemLibrarySourcePath();
                sourceRootPaths[i] = locations[i].getPackageRootPath();
                ++i;
            }
        }
        locations = new LibraryLocation[sourcePaths.length];
        int i = 0;
        while (i < sourcePaths.length) {
            locations[i] = new LibraryLocation(libraryPaths[i], sourcePaths[i], sourceRootPaths[i]);
            ++i;
        }
        return locations;
    }

    private static VMStandin detectEclipseRuntime() {
        VMStandin detectedVMStandin = null;
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            File detectedLocation = vmTypes[i].detectInstallLocation();
            if (detectedLocation != null && detectedVMStandin == null) {
                int unique = i;
                IVMInstallType vmType = vmTypes[i];
                while (vmType.findVMInstall(String.valueOf(unique)) != null) {
                    ++unique;
                }
                String vmID = String.valueOf(unique);
                detectedVMStandin = new VMStandin(vmType, vmID);
                if (detectedVMStandin != null) {
                    detectedVMStandin.setInstallLocation(detectedLocation);
                    detectedVMStandin.setName(JavaRuntime.generateDetectedVMName(detectedVMStandin));
                    if (vmType instanceof AbstractVMInstallType) {
                        AbstractVMInstallType abs = (AbstractVMInstallType)vmType;
                        URL url = abs.getDefaultJavadocLocation(detectedLocation);
                        detectedVMStandin.setJavadocLocation(url);
                    }
                }
            }
            ++i;
        }
        return detectedVMStandin;
    }

    private static void detectDefaultVM() {
        if (JavaRuntime.getDefaultVMId() == null) {
            VMStandin eclipseRuntime = JavaRuntime.detectEclipseRuntime();
            IVMInstall defaultVM = null;
            IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
            if (eclipseRuntime == null) {
                int i = 0;
                while (i < vmTypes.length) {
                    IVMInstallType type = vmTypes[i];
                    IVMInstall[] vms = type.getVMInstalls();
                    int j = 0;
                    if (j < vms.length) {
                        defaultVM = vms[j];
                    }
                    if (defaultVM == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                IVMInstallType type = eclipseRuntime.getVMInstallType();
                IVMInstall[] vms = type.getVMInstalls();
                int j = 0;
                while (j < vms.length) {
                    IVMInstall install = vms[j];
                    if (install.getInstallLocation().equals(eclipseRuntime.getInstallLocation())) {
                        defaultVM = install;
                        break;
                    }
                    ++j;
                }
                if (defaultVM == null) {
                    defaultVM = eclipseRuntime.convertToRealVM();
                }
            }
            if (defaultVM != null) {
                fgDefaultVMId = JavaRuntime.getCompositeIdFromVM(defaultVM);
            }
        }
    }

    private static void detectAndSaveVMDefinitions() {
        JavaRuntime.detectDefaultVM();
        try {
            String vmDefXML = JavaRuntime.getVMsAsXML();
            JavaRuntime.saveVMDefinitions(vmDefXML);
        }
        catch (IOException ioe) {
            LaunchingPlugin.log(ioe);
        }
        catch (ParserConfigurationException e) {
            LaunchingPlugin.log(e);
        }
        catch (TransformerException e) {
            LaunchingPlugin.log(e);
        }
    }

    private static String generateDetectedVMName(IVMInstall vm) {
        return vm.getInstallLocation().getName();
    }

    public static IClasspathEntry getJREVariableEntry() {
        return JavaCore.newVariableEntry((IPath)new Path(JRELIB_VARIABLE), (IPath)new Path(JRESRC_VARIABLE), (IPath)new Path(JRESRCROOT_VARIABLE));
    }

    public static IClasspathEntry getDefaultJREContainerEntry() {
        return JavaCore.newContainerEntry((IPath)new Path(JRE_CONTAINER));
    }

    public static IVMConnector getVMConnector(String id) {
        return LaunchingPlugin.getDefault().getVMConnector(id);
    }

    public static IVMConnector[] getVMConnectors() {
        return LaunchingPlugin.getDefault().getVMConnectors();
    }

    public static Preferences getPreferences() {
        return LaunchingPlugin.getDefault().getPluginPreferences();
    }

    public static void savePreferences() {
        LaunchingPlugin.getDefault().savePluginPreferences();
    }

    public static void addVariableResolver(IRuntimeClasspathEntryResolver resolver, String variableName) {
        Map map = JavaRuntime.getVariableResolvers();
        map.put(variableName, resolver);
    }

    public static void addContainerResolver(IRuntimeClasspathEntryResolver resolver, String containerIdentifier) {
        Map map = JavaRuntime.getContainerResolvers();
        map.put(containerIdentifier, resolver);
    }

    private static Map getVariableResolvers() {
        if (fgVariableResolvers == null) {
            JavaRuntime.initializeResolvers();
        }
        return fgVariableResolvers;
    }

    private static Map getContainerResolvers() {
        if (fgContainerResolvers == null) {
            JavaRuntime.initializeResolvers();
        }
        return fgContainerResolvers;
    }

    private static void initializeResolvers() {
        IExtensionPoint point = LaunchingPlugin.getDefault().getDescriptor().getExtensionPoint(EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRY_RESOLVERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgVariableResolvers = new HashMap(extensions.length);
        fgContainerResolvers = new HashMap(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeClasspathEntryResolver res = new RuntimeClasspathEntryResolver(extensions[i]);
            String variable = res.getVariableName();
            String container = res.getContainerId();
            if (variable != null) {
                fgVariableResolvers.put(variable, res);
            }
            if (container != null) {
                fgContainerResolvers.put(container, res);
            }
            ++i;
        }
    }

    private static Map getClasspathProviders() {
        if (fgPathProviders == null) {
            JavaRuntime.initializeProviders();
        }
        return fgPathProviders;
    }

    private static void initializeProviders() {
        IExtensionPoint point = LaunchingPlugin.getDefault().getDescriptor().getExtensionPoint(EXTENSION_POINT_RUNTIME_CLASSPATH_PROVIDERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgPathProviders = new HashMap(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeClasspathProvider res = new RuntimeClasspathProvider(extensions[i]);
            fgPathProviders.put(res.getIdentifier(), res);
            ++i;
        }
    }

    private static IRuntimeClasspathEntryResolver getVariableResolver(String variableName) {
        return (IRuntimeClasspathEntryResolver)JavaRuntime.getVariableResolvers().get(variableName);
    }

    private static IRuntimeClasspathEntryResolver getContainerResolver(String containerId) {
        return (IRuntimeClasspathEntryResolver)JavaRuntime.getContainerResolvers().get(containerId);
    }

    public static void addVMInstallChangedListener(IVMInstallChangedListener listener) {
        fgVMListeners.add(listener);
    }

    public static void removeVMInstallChangedListener(IVMInstallChangedListener listener) {
        fgVMListeners.remove(listener);
    }

    private static void notifyDefaultVMChanged(IVMInstall previous, IVMInstall current) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.defaultVMInstallChanged(previous, current);
            ++i;
        }
    }

    public static void fireVMChanged(PropertyChangeEvent event) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.vmChanged(event);
            ++i;
        }
    }

    public static void fireVMAdded(IVMInstall vm) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.vmAdded(vm);
            ++i;
        }
    }

    public static void fireVMRemoved(IVMInstall vm) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.vmRemoved(vm);
            ++i;
        }
    }

    public static String getProjectOutputDirectory(ILaunchConfiguration config) {
        try {
            IPath path;
            IPath outputLocation;
            IWorkspaceRoot root;
            IResource resource;
            IJavaProject javaProject;
            if (config != null && (javaProject = JavaRuntime.getJavaProject(config)) != null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(outputLocation = javaProject.getOutputLocation())) != null && (path = resource.getFullPath()) != null) {
                return path.makeRelative().toString();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

