/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.StandardVMRunner;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class StandardVMDebugger
extends StandardVMRunner {
    public StandardVMDebugger(IVMInstall vmInstance) {
        super(vmInstance);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.getString("StandardVMDebugger.Launching_VM..._1"), 4);
        subMonitor.subTask(LaunchingMessages.getString("StandardVMDebugger.Finding_free_socket..._2"));
        int port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(LaunchingMessages.getString("StandardVMDebugger.Could_not_find_a_free_socket_for_the_debugger_1"), null, 118);
        }
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(LaunchingMessages.getString("StandardVMDebugger.Constructing_command_line..._3"));
        String program = this.constructProgramString(config);
        ArrayList<String> arguments = new ArrayList<String>(12);
        arguments.add(program);
        this.addArguments(config.getVMArguments(), arguments);
        this.addBootClassPathArguments(arguments, config);
        String[] cp = config.getClassPath();
        if (cp.length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(cp));
        }
        arguments.add("-Xdebug");
        arguments.add("-Xnoagent");
        arguments.add("-Djava.compiler=NONE");
        arguments.add("-Xrunjdwp:transport=dt_socket,suspend=y,address=localhost:" + port);
        arguments.add(config.getClassToLaunch());
        this.addArguments(config.getProgramArguments(), arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        String[] envp = config.getEnvironment();
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.getString("StandardVMDebugger.Starting_virtual_machine..._4"));
        ListeningConnector connector = this.getConnector();
        if (connector == null) {
            this.abort(LaunchingMessages.getString("StandardVMDebugger.Couldn__t_find_an_appropriate_debug_connector_2"), null, 119);
        }
        Map<String, Connector.Argument> map = connector.defaultArguments();
        this.specifyArguments(map, port);
        Process p = null;
        try {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                block32: {
                                    try {
                                        if (monitor.isCanceled()) {
                                            Object var21_14 = null;
                                            break block32;
                                        }
                                        connector.startListening(map);
                                        File workingDir = this.getWorkingDir(config);
                                        p = this.exec(cmdLine, workingDir, envp);
                                        if (p == null) {
                                            break block33;
                                        }
                                        if (monitor.isCanceled()) {
                                            p.destroy();
                                            break block34;
                                        }
                                        IProcess process = this.newProcess(launch, p, StandardVMRunner.renderProcessLabel(cmdLine), this.getDefaultProcessMap());
                                        process.setAttribute(IProcess.ATTR_CMDLINE, StandardVMRunner.renderCommandLine(cmdLine));
                                        subMonitor.worked(1);
                                        subMonitor.subTask(LaunchingMessages.getString("StandardVMDebugger.Establishing_debug_connection..._5"));
                                        boolean retry = false;
                                        while (true) {
                                            try {
                                                Exception ex;
                                                ConnectRunnable runnable = new ConnectRunnable(connector, map);
                                                Thread connectThread = new Thread((Runnable)runnable, "Listening Connector");
                                                connectThread.start();
                                                while (true) {
                                                    if (!connectThread.isAlive()) {
                                                        ex = runnable.getException();
                                                        if (!(ex instanceof IllegalConnectorArgumentsException)) break;
                                                        throw (IllegalConnectorArgumentsException)ex;
                                                    }
                                                    if (monitor.isCanceled()) {
                                                        connector.stopListening(map);
                                                        p.destroy();
                                                        break block35;
                                                    }
                                                    try {
                                                        p.exitValue();
                                                        try {
                                                            connector.stopListening(map);
                                                        }
                                                        catch (IOException iOException) {}
                                                        this.checkErrorMessage(process);
                                                    }
                                                    catch (IllegalThreadStateException illegalThreadStateException) {}
                                                    try {
                                                        Thread.sleep(100L);
                                                    }
                                                    catch (InterruptedException interruptedException) {}
                                                }
                                                if (ex instanceof InterruptedIOException) {
                                                    throw (InterruptedIOException)ex;
                                                }
                                                if (ex instanceof IOException) {
                                                    throw (IOException)ex;
                                                }
                                                VirtualMachine vm = runnable.getVirtualMachine();
                                                if (vm != null) {
                                                    JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)this.renderDebugTarget(config.getClassToLaunch(), port), (IProcess)process, (boolean)true, (boolean)false);
                                                    subMonitor.worked(1);
                                                    subMonitor.done();
                                                }
                                                break block36;
                                            }
                                            catch (InterruptedIOException e) {
                                                this.checkErrorMessage(process);
                                                Status status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 117, "", (Throwable)e);
                                                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                                                retry = false;
                                                if (handler == null) {
                                                    throw new CoreException((IStatus)status);
                                                }
                                                Object result = handler.handleStatus((IStatus)status, (Object)this);
                                                if (!(result instanceof Boolean)) continue;
                                                retry = (Boolean)result;
                                                if (retry) continue;
                                                break block37;
                                            }
                                            break;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var21_19 = null;
                                        connector.stopListening(map);
                                        throw throwable;
                                    }
                                }
                                connector.stopListening(map);
                                return;
                            }
                            Object var21_15 = null;
                            connector.stopListening(map);
                            return;
                        }
                        Object var21_16 = null;
                        connector.stopListening(map);
                        return;
                    }
                    Object var21_17 = null;
                    connector.stopListening(map);
                    return;
                }
                Object var21_18 = null;
                connector.stopListening(map);
                return;
            }
            Object var21_20 = null;
            connector.stopListening(map);
        }
        catch (IOException e) {
            this.abort(LaunchingMessages.getString("StandardVMDebugger.Couldn__t_connect_to_VM_4"), e, 120);
        }
        catch (IllegalConnectorArgumentsException e) {
            this.abort(LaunchingMessages.getString("StandardVMDebugger.Couldn__t_connect_to_VM_5"), e, 120);
        }
        if (p != null) {
            p.destroy();
        }
    }

    protected void checkErrorMessage(IProcess process) throws CoreException {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        if (streamsProxy != null) {
            String errorMessage = streamsProxy.getErrorStreamMonitor().getContents();
            if (errorMessage.length() == 0) {
                errorMessage = streamsProxy.getOutputStreamMonitor().getContents();
            }
            if (errorMessage.length() != 0) {
                this.abort(errorMessage, null, 116);
            }
        }
    }

    protected void specifyArguments(Map map, int portNumber) {
        Connector.IntegerArgument port = (Connector.IntegerArgument)map.get("port");
        port.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)map.get("timeout");
        if (timeoutArg != null) {
            int timeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            timeoutArg.setValue(timeout);
        }
    }

    protected ListeningConnector getConnector() {
        List<ListeningConnector> connectors = Bootstrap.virtualMachineManager().listeningConnectors();
        int i = 0;
        while (i < connectors.size()) {
            ListeningConnector c = connectors.get(i);
            if ("com.sun.jdi.SocketListen".equals(c.name())) {
                return c;
            }
            ++i;
        }
        return null;
    }

    class ConnectRunnable
    implements Runnable {
        private VirtualMachine fVirtualMachine = null;
        private ListeningConnector fConnector = null;
        private Map fConnectionMap = null;
        private Exception fException = null;

        public ConnectRunnable(ListeningConnector connector, Map map) {
            this.fConnector = connector;
            this.fConnectionMap = map;
        }

        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IOException e) {
                this.fException = e;
            }
            catch (IllegalConnectorArgumentsException e) {
                this.fException = e;
            }
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

