/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.StandardVMRunner;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class Standard11xVMRunner
extends StandardVMRunner {
    public Standard11xVMRunner(IVMInstall vmInstance) {
        super(vmInstance);
    }

    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        int i;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.getString("StandardVMRunner.Launching_VM..._1"), 2);
        subMonitor.subTask(LaunchingMessages.getString("StandardVMRunner.Constructing_command_line..._2"));
        String program = this.constructProgramString(config);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(program);
        String[] vmArgs = config.getVMArguments();
        this.addArguments(vmArgs, arguments);
        String[] bootCP = config.getBootClassPath();
        String[] classPath = config.getClassPath();
        String[] combinedPath = null;
        if (bootCP == null) {
            LibraryLocation[] locs = JavaRuntime.getLibraryLocations(this.fVMInstance);
            bootCP = new String[locs.length];
            i = 0;
            while (i < locs.length) {
                bootCP[i] = locs[i].getSystemLibraryPath().toOSString();
                ++i;
            }
        }
        combinedPath = new String[bootCP.length + classPath.length];
        int offset = 0;
        i = 0;
        while (i < bootCP.length) {
            combinedPath[offset] = bootCP[i];
            ++offset;
            ++i;
        }
        i = 0;
        while (i < classPath.length) {
            combinedPath[offset] = classPath[i];
            ++offset;
            ++i;
        }
        if (combinedPath.length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(combinedPath));
        }
        arguments.add(config.getClassToLaunch());
        String[] programArgs = config.getProgramArguments();
        this.addArguments(programArgs, arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.getString("StandardVMRunner.Starting_virtual_machine..._3"));
        Process p = null;
        File workingDir = this.getWorkingDir(config);
        p = this.exec(cmdLine, workingDir);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)StandardVMRunner.renderProcessLabel(cmdLine));
        process.setAttribute(IProcess.ATTR_CMDLINE, StandardVMRunner.renderCommandLine(cmdLine));
        subMonitor.worked(1);
    }
}

