/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class JRERuntimeClasspathEntryResolver
implements IRuntimeClasspathEntryResolver {
    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        IVMInstall jre = null;
        jre = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? JREContainerInitializer.resolveVM(entry.getPath()) : JavaRuntime.computeVMInstall(configuration);
        if (jre == null) {
            return new IRuntimeClasspathEntry[0];
        }
        return this.resolveLibraryLocations(jre, entry.getClasspathProperty());
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        IVMInstall jre = null;
        jre = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? JREContainerInitializer.resolveVM(entry.getPath()) : JavaRuntime.getVMInstall(project);
        if (jre == null) {
            return new IRuntimeClasspathEntry[0];
        }
        return this.resolveLibraryLocations(jre, entry.getClasspathProperty());
    }

    protected IRuntimeClasspathEntry[] resolveLibraryLocations(IVMInstall vm, int kind) {
        LibraryInfo libraryInfo;
        File vmInstallLocation;
        IRuntimeClasspathEntry[] resolved = null;
        if (kind == 2 && (vmInstallLocation = vm.getInstallLocation()) != null && (libraryInfo = LaunchingPlugin.getLibraryInfo(vmInstallLocation.getAbsolutePath())) != null) {
            String[] bootpath = libraryInfo.getBootpath();
            int length = bootpath.length;
            resolved = new IRuntimeClasspathEntry[length];
            int i = 0;
            while (i < length) {
                resolved[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(bootpath[i]));
                resolved[i].setClasspathProperty(2);
                ++i;
            }
            return resolved;
        }
        LibraryLocation[] libs = vm.getLibraryLocations();
        if (libs == null) {
            libs = vm.getVMInstallType().getDefaultLibraryLocations(vm.getInstallLocation());
        } else {
            kind = 2;
        }
        resolved = new IRuntimeClasspathEntry[libs.length];
        int i = 0;
        while (i < libs.length) {
            resolved[i] = JavaRuntime.newArchiveRuntimeClasspathEntry(libs[i].getSystemLibraryPath());
            IPath path = libs[i].getSystemLibrarySourcePath();
            if (path != null && !path.isEmpty()) {
                resolved[i].setSourceAttachmentPath(path);
                resolved[i].setSourceAttachmentRootPath(libs[i].getPackageRootPath());
            }
            resolved[i].setClasspathProperty(kind);
            ++i;
        }
        return resolved;
    }

    public IVMInstall resolveVMInstall(IClasspathEntry entry) {
        switch (entry.getEntryKind()) {
            case 4: {
                if (!entry.getPath().segment(0).equals("JRE_LIB")) break;
                return JavaRuntime.getDefaultVMInstall();
            }
            case 5: {
                if (!entry.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) break;
                return JREContainerInitializer.resolveVM(entry.getPath());
            }
        }
        return null;
    }
}

