/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class ContributedDelegate {
    private IConfigurationElement fElement;
    private Set fModes;
    private ILaunchConfigurationDelegate fDelegate;

    protected ContributedDelegate(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fElement = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    protected Set getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fModes = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }

    protected String getLaunchConfigurationType() {
        return this.getConfigurationElement().getAttribute("type");
    }

    protected ILaunchConfigurationDelegate getDelegate() throws CoreException {
        if (this.fDelegate == null) {
            Object object = this.getConfigurationElement().createExecutableExtension("delegate");
            if (object instanceof ILaunchConfigurationDelegate) {
                this.fDelegate = (ILaunchConfigurationDelegate)object;
            } else {
                throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, MessageFormat.format(DebugCoreMessages.getString("LaunchConfigurationType.Launch_delegate_for_{0}_does_not_implement_required_interface_ILaunchConfigurationDelegate._1"), this.getIdentifier()), null));
            }
        }
        return this.fDelegate;
    }

    protected String getIdentifier() {
        return this.getConfigurationElement().getAttribute("id");
    }
}

