/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.ExpressionManager;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.core.ListenerList;
import org.eclipse.debug.internal.core.LogicalStructureManager;

public class DebugPlugin
extends Plugin {
    public static final String EXTENSION_POINT_LAUNCH_CONFIGURATION_TYPES = "launchConfigurationTypes";
    public static final String EXTENSION_POINT_LAUNCH_CONFIGURATION_COMPARATORS = "launchConfigurationComparators";
    public static final String EXTENSION_POINT_BREAKPOINTS = "breakpoints";
    public static final String EXTENSION_POINT_STATUS_HANDLERS = "statusHandlers";
    public static final String EXTENSION_POINT_SOURCE_LOCATORS = "sourceLocators";
    public static final String EXTENSION_POINT_LAUNCH_MODES = "launchModes";
    public static final String EXTENSION_POINT_LAUNCH_DELEGATES = "launchDelegates";
    public static final String EXTENSION_POINT_PROCESS_FACTORIES = "processFactories";
    public static final String EXTENSION_POINT_LOGICAL_STRUCTURE_TYPES = "logicalStructureTypes";
    public static final int INTERNAL_ERROR = 120;
    public static final int ERR_WORKING_DIRECTORY_NOT_SUPPORTED = 115;
    public static final String ATTR_PROCESS_FACTORY_ID = "process_factory_id";
    private static DebugPlugin fgDebugPlugin = null;
    private BreakpointManager fBreakpointManager;
    private ExpressionManager fExpressionManager;
    private LaunchManager fLaunchManager;
    private ListenerList fEventListeners;
    private ListenerList fEventFilters = null;
    private boolean fShuttingDown = false;
    private int fDispatching = 0;
    private Object fLock = new Object();
    private Vector fRunnables = null;
    private AsynchJob fAsynchJob = null;
    private HashMap fStatusHandlers = null;
    private HashMap fProcessFactories = null;
    private static final int NOTIFY_FILTERS = 0;
    private static final int NOTIFY_EVENTS = 1;

    public static DebugPlugin getDefault() {
        return fgDebugPlugin;
    }

    private static void setDefault(DebugPlugin plugin) {
        fgDebugPlugin = plugin;
    }

    public static String getUniqueIdentifier() {
        if (DebugPlugin.getDefault() == null) {
            return "org.eclipse.debug.core";
        }
        return DebugPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public DebugPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        DebugPlugin.setDefault(this);
    }

    public void addDebugEventListener(IDebugEventSetListener listener) {
        if (this.fEventListeners == null) {
            this.fEventListeners = new ListenerList(20);
        }
        this.fEventListeners.add(listener);
    }

    public void fireDebugEventSet(DebugEvent[] events) {
        if (this.isShuttingDown() || events == null || this.fEventListeners == null) {
            return;
        }
        this.getEventNotifier().dispatch(events);
    }

    public void asyncExec(Runnable r) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fRunnables == null) {
                this.fRunnables = new Vector(10);
                this.fAsynchJob = new AsynchJob();
                this.fRunnables.add(r);
                if (!this.isDispatching()) {
                    this.fAsynchJob.schedule();
                }
            } else {
                this.fRunnables.add(r);
            }
        }
    }

    public IBreakpointManager getBreakpointManager() {
        if (this.fBreakpointManager == null) {
            this.fBreakpointManager = new BreakpointManager();
        }
        return this.fBreakpointManager;
    }

    public ILaunchManager getLaunchManager() {
        if (this.fLaunchManager == null) {
            this.fLaunchManager = new LaunchManager();
        }
        return this.fLaunchManager;
    }

    public IStatusHandler getStatusHandler(IStatus status) {
        IConfigurationElement config;
        StatusHandlerKey key = new StatusHandlerKey(status.getPlugin(), status.getCode());
        if (this.fStatusHandlers == null) {
            this.initializeStatusHandlers();
        }
        if ((config = (IConfigurationElement)this.fStatusHandlers.get(key)) != null) {
            try {
                Object handler = config.createExecutableExtension("class");
                if (handler instanceof IStatusHandler) {
                    return (IStatusHandler)handler;
                }
                this.invalidStatusHandler(null, MessageFormat.format(DebugCoreMessages.getString("DebugPlugin.Registered_status_handler_{0}_does_not_implement_required_interface_IStatusHandler._1"), config.getDeclaringExtension().getUniqueIdentifier()));
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
        return null;
    }

    public IExpressionManager getExpressionManager() {
        if (this.fExpressionManager == null) {
            this.fExpressionManager = new ExpressionManager();
        }
        return this.fExpressionManager;
    }

    public void removeDebugEventListener(IDebugEventSetListener listener) {
        if (this.fEventListeners != null) {
            this.fEventListeners.remove(listener);
        }
    }

    public void shutdown() throws CoreException {
        this.setShuttingDown(true);
        super.shutdown();
        if (this.fAsynchJob != null) {
            this.fAsynchJob.cancel();
        }
        if (this.fLaunchManager != null) {
            this.fLaunchManager.shutdown();
        }
        if (this.fBreakpointManager != null) {
            this.fBreakpointManager.shutdown();
        }
        if (this.fEventListeners != null) {
            this.fEventListeners.removeAll();
        }
        DebugPlugin.setDefault(null);
        ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
    }

    public static IProcess newProcess(ILaunch launch, Process process, String label) {
        return DebugPlugin.newProcess(launch, process, label, null);
    }

    public static IProcess newProcess(ILaunch launch, Process process, String label, Map attributes) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        String processFactoryID = null;
        if (config != null) {
            try {
                processFactoryID = config.getAttribute(ATTR_PROCESS_FACTORY_ID, (String)null);
            }
            catch (CoreException coreException) {}
        }
        if (processFactoryID != null) {
            IConfigurationElement element;
            DebugPlugin plugin = DebugPlugin.getDefault();
            if (plugin.fProcessFactories == null) {
                plugin.initializeProcessFactories();
            }
            if ((element = (IConfigurationElement)plugin.fProcessFactories.get(processFactoryID)) == null) {
                return null;
            }
            IProcessFactory processFactory = null;
            try {
                processFactory = (IProcessFactory)element.createExecutableExtension("class");
            }
            catch (CoreException exception) {
                DebugPlugin.log(exception);
                return null;
            }
            return processFactory.newProcess(launch, process, label, attributes);
        }
        return new RuntimeProcess(launch, process, label, attributes);
    }

    public static ILogicalStructureType[] getLogicalStructureTypes(IValue value) {
        return LogicalStructureManager.getDefault().getLogicalStructureTypes(value);
    }

    public static Process exec(String[] cmdLine, File workingDirectory) throws CoreException {
        return DebugPlugin.exec(cmdLine, workingDirectory, null);
    }

    public static Process exec(String[] cmdLine, File workingDirectory, String[] envp) throws CoreException {
        Process p;
        block4: {
            p = null;
            try {
                p = workingDirectory == null ? Runtime.getRuntime().exec(cmdLine, envp) : Runtime.getRuntime().exec(cmdLine, envp, workingDirectory);
            }
            catch (IOException e) {
                if (p != null) {
                    p.destroy();
                }
                Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("DebugPlugin.Exception_occurred_executing_command_line._1"), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 115, DebugCoreMessages.getString("DebugPlugin.Eclipse_runtime_does_not_support_working_directory_2"), (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, null)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block4;
                p = DebugPlugin.exec(cmdLine, null);
            }
        }
        return p;
    }

    private boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    private void setShuttingDown(boolean value) {
        this.fShuttingDown = value;
    }

    private Object[] getEventListeners() {
        return this.fEventListeners.getListeners();
    }

    public void addDebugEventFilter(IDebugEventFilter filter) {
        if (this.fEventFilters == null) {
            this.fEventFilters = new ListenerList(2);
        }
        this.fEventFilters.add(filter);
    }

    public void removeDebugEventFilter(IDebugEventFilter filter) {
        if (this.fEventFilters != null) {
            this.fEventFilters.remove(filter);
            if (this.fEventFilters.size() == 0) {
                this.fEventFilters = null;
            }
        }
    }

    public static void logDebugMessage(String message) {
        if (DebugPlugin.getDefault().isDebugging()) {
            DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "Internal message logged from Debug Core: " + message, null));
        }
    }

    public static void logMessage(String message, Throwable throwable) {
        DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, message, throwable));
    }

    public static void log(IStatus status) {
        DebugPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "Error logged from Debug Core: ", t);
        DebugPlugin.log((IStatus)status);
    }

    private void initializeStatusHandlers() {
        IPluginDescriptor descriptor = DebugPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint(EXTENSION_POINT_STATUS_HANDLERS);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fStatusHandlers = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            String id = configurationElement.getAttribute("plugin");
            String code = configurationElement.getAttribute("code");
            if (id != null && code != null) {
                try {
                    StatusHandlerKey key = new StatusHandlerKey(id, Integer.parseInt(code));
                    this.fStatusHandlers.put(key, configurationElement);
                }
                catch (NumberFormatException e) {
                    this.invalidStatusHandler(e, configurationElement.getAttribute("id"));
                }
            } else {
                this.invalidStatusHandler(null, configurationElement.getAttribute("id"));
            }
            ++i;
        }
    }

    private void initializeProcessFactories() {
        IExtensionPoint extensionPoint = this.getDescriptor().getExtensionPoint(EXTENSION_POINT_PROCESS_FACTORIES);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fProcessFactories = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            String id = configurationElement.getAttribute("id");
            String clss = configurationElement.getAttribute("class");
            if (id != null && clss != null) {
                this.fProcessFactories.put(id, configurationElement);
            } else {
                String badDefiner = infos[i].getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                DebugPlugin.log((IStatus)new Status(4, this.getDescriptor().getUniqueIdentifier(), 120, MessageFormat.format(DebugCoreMessages.getString("DebugPlugin.31"), badDefiner, id), null));
            }
            ++i;
        }
    }

    private void invalidStatusHandler(Exception e, String id) {
        DebugPlugin.log((IStatus)new Status(4, this.getDescriptor().getUniqueIdentifier(), 120, MessageFormat.format(DebugCoreMessages.getString("DebugPlugin.Invalid_status_handler_extension__{0}_2"), id), (Throwable)e));
    }

    private boolean hasEventFilters() {
        return this.fEventFilters != null && this.fEventFilters.size() > 0;
    }

    private synchronized void setDispatching(boolean dispatching) {
        this.fDispatching = dispatching ? ++this.fDispatching : --this.fDispatching;
        if (!this.isDispatching() && this.fAsynchJob != null) {
            this.fAsynchJob.schedule();
        }
    }

    private synchronized boolean isDispatching() {
        return this.fDispatching > 0;
    }

    private EventNotifier getEventNotifier() {
        return new EventNotifier();
    }

    class StatusHandlerKey {
        String fPluginId;
        int fCode;

        StatusHandlerKey(String pluginId, int code) {
            this.fPluginId = pluginId;
            this.fCode = code;
        }

        public int hashCode() {
            return this.fPluginId.hashCode() + this.fCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusHandlerKey) {
                StatusHandlerKey s = (StatusHandlerKey)obj;
                return this.fCode == s.fCode && this.fPluginId.equals(s.fPluginId);
            }
            return false;
        }
    }

    class AsynchJob
    extends Job
    implements ISchedulingRule {
        public AsynchJob() {
            super(DebugCoreMessages.getString("DebugPlugin.Debug_async_queue_1"));
            this.setPriority(10);
            this.setSystem(true);
        }

        public boolean shouldRun() {
            return !DebugPlugin.this.fShuttingDown && !DebugPlugin.this.fRunnables.isEmpty();
        }

        public IStatus run(IProgressMonitor monitor) {
            Vector v = null;
            Object object = DebugPlugin.this.fLock;
            synchronized (object) {
                v = DebugPlugin.this.fRunnables;
                DebugPlugin.this.fRunnables = null;
                DebugPlugin.this.fAsynchJob = null;
            }
            monitor.beginTask(DebugCoreMessages.getString("DebugPlugin.Debug_async_queue_1"), v.size());
            Iterator iter = v.iterator();
            while (iter.hasNext() && !DebugPlugin.this.fShuttingDown) {
                if (monitor.isCanceled()) break;
                Runnable r = (Runnable)iter.next();
                try {
                    r.run();
                }
                catch (Throwable t) {
                    DebugPlugin.log(t);
                }
                monitor.worked(1);
            }
            return Status.OK_STATUS;
        }

        public boolean contains(ISchedulingRule rule) {
            return this.isConflicting(rule);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof AsynchJob;
        }
    }

    class EventNotifier
    implements ISafeRunnable {
        private DebugEvent[] fEvents;
        private IDebugEventSetListener fListener;
        private IDebugEventFilter fFilter;
        private int fMode;

        EventNotifier() {
        }

        public void handleException(Throwable exception) {
            switch (this.fMode) {
                case 0: {
                    Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("DebugPlugin.An_exception_occurred_while_filtering_debug_events._3"), exception);
                    DebugPlugin.log((IStatus)status);
                    break;
                }
                case 1: {
                    Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("DebugPlugin.An_exception_occurred_while_dispatching_debug_events._2"), exception);
                    DebugPlugin.log((IStatus)status);
                }
            }
        }

        public void run() throws Exception {
            switch (this.fMode) {
                case 0: {
                    this.fEvents = this.fFilter.filterDebugEvents(this.fEvents);
                    break;
                }
                case 1: {
                    this.fListener.handleDebugEvents(this.fEvents);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void dispatch(DebugEvent[] events) {
            block7: {
                block6: {
                    this.fEvents = events;
                    try {
                        int i;
                        block8: {
                            DebugPlugin.this.setDispatching(true);
                            if (!DebugPlugin.this.hasEventFilters()) break block8;
                            this.fMode = 0;
                            Object[] filters = DebugPlugin.this.fEventFilters.getListeners();
                            i = 0;
                            while (i < filters.length) {
                                block10: {
                                    block9: {
                                        this.fFilter = (IDebugEventFilter)filters[i];
                                        Platform.run((ISafeRunnable)this);
                                        if (this.fEvents == null) break block9;
                                        if (this.fEvents.length != 0) break block10;
                                    }
                                    Object var4_4 = null;
                                    break block6;
                                }
                                ++i;
                            }
                        }
                        this.fMode = 1;
                        Object[] listeners = DebugPlugin.this.getEventListeners();
                        i = 0;
                        while (i < listeners.length) {
                            this.fListener = (IDebugEventSetListener)listeners[i];
                            Platform.run((ISafeRunnable)this);
                            ++i;
                        }
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        DebugPlugin.this.setDispatching(false);
                        throw throwable;
                    }
                }
                DebugPlugin.this.setDispatching(false);
                return;
            }
            Object var4_6 = null;
            DebugPlugin.this.setDispatching(false);
            this.fEvents = null;
            this.fFilter = null;
            this.fListener = null;
        }
    }
}

