/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.WebappWorkingSetManager;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class SearchServlet
extends HttpServlet {
    private String locale;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        resp.setHeader("Cache-Control", "max-age=0");
        SearchHit[] hits = this.loadSearchResults(req, resp);
        ResultsWriter resultsWriter = new ResultsWriter(resp.getWriter());
        resultsWriter.generate(hits, resp);
        resultsWriter.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    /*
     * Exception decompiling
     */
    private SearchHit[] loadSearchResults(HttpServletRequest request, HttpServletResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 88->91)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ISearchQuery createSearchQuery(HttpServletRequest request) {
        String searchWord = request.getParameter("searchWord");
        String fieldSearchStr = request.getParameter("fieldSearch");
        boolean fieldSearch = fieldSearchStr != null ? new Boolean(fieldSearchStr) : false;
        return new SearchQuery(searchWord, fieldSearch, new ArrayList(), this.locale);
    }

    private SearchResults createHitCollector(HttpServletRequest request, HttpServletResponse response) {
        WorkingSet[] workingSets = request.getParameterValues("scopedSearch") == null ? this.getWorkingSets(request, response) : this.createTempWorkingSets(request, response);
        int maxHits = 500;
        String maxHitsStr = request.getParameter("maxHits");
        if (maxHitsStr != null) {
            try {
                int clientmaxHits = Integer.parseInt(maxHitsStr);
                if (clientmaxHits > 0 && clientmaxHits < 500) {
                    maxHits = clientmaxHits;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new SearchResults(workingSets, maxHits, this.locale);
    }

    private WorkingSet[] getWorkingSets(HttpServletRequest request, HttpServletResponse response) {
        String[] scopes = request.getParameterValues("scope");
        if (scopes == null) {
            return null;
        }
        WebappWorkingSetManager wsmgr = new WebappWorkingSetManager(request, response, this.locale);
        ArrayList<WorkingSet> workingSetCol = new ArrayList<WorkingSet>(scopes.length);
        int s = 0;
        while (s < scopes.length) {
            WorkingSet ws = wsmgr.getWorkingSet(scopes[s]);
            if (ws != null) {
                workingSetCol.add(ws);
            }
            ++s;
        }
        if (workingSetCol.size() == 0) {
            return null;
        }
        return workingSetCol.toArray(new WorkingSet[workingSetCol.size()]);
    }

    private WorkingSet[] createTempWorkingSets(HttpServletRequest request, HttpServletResponse response) {
        String[] scopes = request.getParameterValues("scope");
        if (scopes == null) {
            return new WorkingSet[0];
        }
        if (scopes.length == HelpPlugin.getTocManager().getTocs(this.locale).length) {
            return null;
        }
        WebappWorkingSetManager wsmgr = new WebappWorkingSetManager(request, response, this.locale);
        ArrayList<AdaptableToc> tocs = new ArrayList<AdaptableToc>(scopes.length);
        int s = 0;
        while (s < scopes.length) {
            AdaptableToc toc = wsmgr.getAdaptableToc(scopes[s]);
            if (toc != null) {
                tocs.add(toc);
            }
            ++s;
        }
        AdaptableToc[] adaptableTocs = tocs.toArray(new AdaptableToc[tocs.size()]);
        WorkingSet[] workingSets = new WorkingSet[]{wsmgr.createWorkingSet("temp", (AdaptableHelpResource[])adaptableTocs)};
        return workingSets;
    }

    private static class ResultsWriter
    extends XMLGenerator {
        public ResultsWriter(Writer writer) {
            super(writer);
        }

        public void generate(SearchHit[] hits, HttpServletResponse resp) {
            this.println("<hits>");
            ++this.pad;
            int i = 0;
            while (i < hits.length) {
                this.printPad();
                this.print("<topic label=\"" + XMLGenerator.xmlEscape(hits[i].getLabel()) + "\"" + " href=\"" + hits[i].getHref() + "\"" + " score=\"" + Float.toString(hits[i].getScore()) + "\"");
                if (hits[i].getToc() != null) {
                    this.print(" toc=\"" + hits[i].getToc().getHref() + "\"" + " toclabel=\"" + hits[i].getToc().getLabel() + "\"");
                }
                this.print(" />");
                ++i;
            }
            --this.pad;
            this.println("</hits>");
        }
    }
}

