/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.ToolbarButton;

public class ToolbarData
extends RequestData {
    ToolbarButton[] buttons;

    public ToolbarData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.loadButtons();
    }

    private void loadButtons() {
        String[] names = this.request.getParameterValues("name");
        String[] tooltips = this.request.getParameterValues("tooltip");
        String[] images = this.request.getParameterValues("image");
        String[] actions = this.request.getParameterValues("action");
        if (names == null || tooltips == null || images == null || actions == null || names.length != tooltips.length || names.length != images.length || names.length != actions.length) {
            this.buttons = new ToolbarButton[0];
            return;
        }
        this.buttons = new ToolbarButton[names.length];
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i] = "".equals(names[i]) ? new ToolbarButton() : new ToolbarButton(names[i], ServletResources.getString(tooltips[i], this.request), String.valueOf(this.preferences.getImagesDirectory()) + "/" + images[i], actions[i]);
            ++i;
        }
    }

    public ToolbarButton[] getButtons() {
        return this.buttons;
    }

    public String getTitle() {
        if (this.request.getParameter("view") == null) {
            return "";
        }
        return ServletResources.getString(this.request.getParameter("view"), this.request);
    }

    public String getScript() {
        return this.request.getParameter("script");
    }
}

