/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageRegistry {
    private Map table = null;

    public ImageRegistry() {
        this(Display.getCurrent());
    }

    public ImageRegistry(Display display) {
        Assert.isNotNull(display);
        this.hookDisplayDispose(display);
    }

    public Image get(String key) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        if (entry.image == null && entry.descriptor != null) {
            entry.image = entry.descriptor.createImage();
        }
        return entry.image;
    }

    public ImageDescriptor getDescriptor(String key) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.descriptor;
    }

    void handleDisplayDispose() {
        if (this.table == null) {
            return;
        }
        Iterator e = this.table.values().iterator();
        while (e.hasNext()) {
            Entry entry = (Entry)e.next();
            if (entry.image == null) continue;
            entry.image.dispose();
        }
        this.table = null;
    }

    private void hookDisplayDispose(Display display) {
        display.disposeExec(new Runnable(){

            public void run() {
                ImageRegistry.this.handleDisplayDispose();
            }
        });
    }

    public void put(String key, ImageDescriptor descriptor) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            entry = new Entry();
            this.putEntry(key, entry);
        }
        if (entry.image == null) {
            entry.descriptor = descriptor;
            return;
        }
        throw new IllegalArgumentException("ImageRegistry key already in use: " + key);
    }

    public void put(String key, Image image) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            entry = new Entry();
            this.putEntry(key, entry);
        }
        if (entry.image == null && entry.descriptor == null) {
            entry.image = image;
            return;
        }
        throw new IllegalArgumentException("ImageRegistry key already in use: " + key);
    }

    private Entry getEntry(String key) {
        return (Entry)this.getTable().get(key);
    }

    private void putEntry(String key, Entry entry) {
        this.getTable().put(key, entry);
    }

    private Map getTable() {
        if (this.table == null) {
            this.table = new HashMap(10);
        }
        return this.table;
    }

    private static class Entry {
        protected Image image;
        protected ImageDescriptor descriptor;

        Entry() {
        }
    }
}

