/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorRegistry {
    private Display display;
    private ListenerList listeners = new ListenerList();
    private List staleColors = new ArrayList();
    private Map stringToColor = new HashMap(7);
    private Map stringToRGB = new HashMap(7);

    public ColorRegistry() {
        this(Display.getCurrent());
    }

    public ColorRegistry(Display display) {
        Assert.isNotNull(display);
        this.display = display;
        this.hookDisplayDispose(display);
    }

    public void addListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    private Color createColor(String symbolicName, RGB rgb) {
        return new Color((Device)this.display, rgb);
    }

    private void disposeColors(Iterator iterator) {
        while (iterator.hasNext()) {
            Object next = iterator.next();
            ((Color)next).dispose();
        }
    }

    private void fireColorMappingChanged(String name, RGB oldValue, RGB newValue) {
        String finalName = name;
        Object[] listeners = this.listeners.getListeners();
        if (listeners.length > 0) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, finalName, oldValue, newValue);
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                }
                catch (Exception exception) {}
                ++i;
            }
        }
    }

    public Color get(String symbolicName) {
        Assert.isNotNull(symbolicName);
        Object result = this.stringToColor.get(symbolicName);
        if (result != null) {
            return (Color)result;
        }
        result = this.stringToRGB.get(symbolicName);
        if (result == null) {
            return null;
        }
        Color color = this.createColor(symbolicName, (RGB)result);
        if (color != null) {
            this.stringToColor.put(symbolicName, color);
        }
        return color;
    }

    public RGB getRGB(String symbolicName) {
        Assert.isNotNull(symbolicName);
        return (RGB)this.stringToRGB.get(symbolicName);
    }

    private void handleDisplayDispose() {
        this.disposeColors(this.stringToColor.values().iterator());
        this.disposeColors(this.staleColors.iterator());
        this.stringToColor.clear();
        this.staleColors.clear();
        this.listeners.clear();
    }

    public boolean hasValueFor(String colorKey) {
        return this.stringToRGB.containsKey(colorKey);
    }

    private void hookDisplayDispose(Display display) {
        display.disposeExec(new Runnable(){

            public void run() {
                ColorRegistry.this.handleDisplayDispose();
            }
        });
    }

    public void put(String symbolicName, RGB colorData) {
        this.put(symbolicName, colorData, true);
    }

    private void put(String symbolicName, RGB colorData, boolean update) {
        Assert.isNotNull(symbolicName);
        Assert.isNotNull(colorData);
        RGB existing = (RGB)this.stringToRGB.get(symbolicName);
        if (colorData.equals((Object)existing)) {
            return;
        }
        Color oldColor = (Color)this.stringToColor.remove(symbolicName);
        this.stringToRGB.put(symbolicName, colorData);
        if (update) {
            this.fireColorMappingChanged(symbolicName, existing, colorData);
        }
        if (oldColor != null) {
            this.staleColors.add(oldColor);
        }
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }
}

