/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBarContributionItem
extends ContributionItem {
    public static final int SHOW_ALL_ITEMS = -1;
    private ToolBarManager toolBarManager = null;
    private MenuManager chevronMenuManager = null;
    private MenuManager contextMenuManager = null;
    private int minimumItemsToShow = -1;
    private boolean useChevron = true;
    private int currentWidth = -1;
    private int currentHeight = -1;
    private CoolItem coolItem = null;

    public ToolBarContributionItem(IToolBarManager toolBarManager, String id) {
        super(id);
        Assert.isTrue(toolBarManager instanceof ToolBarManager);
        this.toolBarManager = (ToolBarManager)toolBarManager;
    }

    public ToolBarContributionItem(IToolBarManager toolBarManager) {
        this(toolBarManager, null);
    }

    public ToolBarContributionItem() {
        this(new ToolBarManager(), null);
    }

    public IToolBarManager getToolBarManager() {
        return this.toolBarManager;
    }

    private int[] getAdjustedWrapIndices(int[] wraps) {
        int[] adjustedWrapIndices;
        if (wraps.length == 0) {
            adjustedWrapIndices = new int[1];
        } else if (wraps[0] != 0) {
            adjustedWrapIndices = new int[wraps.length + 1];
            adjustedWrapIndices[0] = 0;
            int i = 0;
            while (i < wraps.length) {
                adjustedWrapIndices[i + 1] = wraps[i];
                ++i;
            }
        } else {
            adjustedWrapIndices = wraps;
        }
        return adjustedWrapIndices;
    }

    public void fill(CoolBar coolBar, int index) {
        if (this.coolItem == null && coolBar != null) {
            ToolBar toolBar = this.toolBarManager.createControl((Composite)coolBar);
            if (toolBar.getItemCount() < 1) {
                return;
            }
            int flags = 4;
            this.coolItem = index >= 0 ? new CoolItem(coolBar, flags, index) : new CoolItem(coolBar, flags);
            this.coolItem.setData((Object)this);
            this.coolItem.setControl((Control)toolBar);
            toolBar.addListener(35, new Listener(){

                public void handleEvent(Event event) {
                    if (ToolBarContributionItem.this.toolBarManager.getContextMenuManager() == null) {
                        ToolBarContributionItem.this.handleContextMenu(event);
                    }
                }
            });
            if (this.getUseChevron()) {
                this.coolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (event.detail == 4) {
                            ToolBarContributionItem.this.handleChevron(event);
                        }
                    }
                });
            }
            this.coolItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ToolBarContributionItem.this.handleWidgetDispose(event);
                }
            });
            this.updateSize(true);
        }
    }

    private void handleContextMenu(Event event) {
        ToolBar toolBar = this.toolBarManager.getControl();
        Menu parentMenu = toolBar.getParent().getMenu();
        if (parentMenu != null && !parentMenu.isDisposed()) {
            toolBar.setMenu(parentMenu);
            parentMenu.addListener(23, new Listener(){

                public void handleEvent(Event event) {
                    ToolBar toolBar = ToolBarContributionItem.this.toolBarManager.getControl();
                    if (toolBar != null) {
                        toolBar.setMenu(null);
                        Menu parentMenu = toolBar.getParent().getMenu();
                        if (parentMenu != null) {
                            parentMenu.removeListener(23, (Listener)this);
                        }
                    }
                }
            });
        }
    }

    private void handleWidgetDispose(DisposeEvent event) {
        this.coolItem = null;
    }

    public void saveWidgetState() {
        if (this.coolItem == null) {
            return;
        }
        CoolBar coolBar = this.coolItem.getParent();
        boolean isLastOnRow = false;
        int lastIndex = coolBar.getItemCount() - 1;
        int coolItemIndex = coolBar.indexOf(this.coolItem);
        int[] wrapIndicies = this.getAdjustedWrapIndices(coolBar.getWrapIndices());
        int row = wrapIndicies.length - 1;
        while (row >= 0) {
            if (wrapIndicies[row] <= coolItemIndex) {
                int nextRow = row + 1;
                int rowStartIndex = wrapIndicies[row];
                int nextRowStartIndex = nextRow > wrapIndicies.length - 1 ? lastIndex + 1 : wrapIndicies[nextRow];
                if (coolItemIndex == nextRowStartIndex - 1) {
                    isLastOnRow = true;
                }
                boolean bl = rowStartIndex == coolItemIndex && isLastOnRow;
                break;
            }
            --row;
        }
        int nCurrentWidth = isLastOnRow ? this.coolItem.getPreferredSize().x : this.coolItem.getSize().x;
        this.setCurrentWidth(nCurrentWidth);
        this.setCurrentHeight(this.coolItem.getSize().y);
    }

    public void dispose() {
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
        }
        if (this.coolItem != null && !this.coolItem.isDisposed()) {
            this.coolItem.dispose();
        }
    }

    /*
     * Exception decompiling
     */
    public void updateSize(boolean changeCurrentSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 283->287)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleChevron(SelectionEvent event) {
        CoolItem item = (CoolItem)event.widget;
        Control control = item.getControl();
        if (!(control instanceof ToolBar)) {
            return;
        }
        CoolBar coolBar = item.getParent();
        Point chevronPosition = coolBar.toDisplay(new Point(event.x, event.y));
        ToolBar toolBar = (ToolBar)control;
        ToolItem[] tools = toolBar.getItems();
        int toolCount = tools.length;
        int visibleItemCount = 0;
        while (visibleItemCount < toolCount) {
            Rectangle toolBounds = tools[visibleItemCount].getBounds();
            Point point = toolBar.toDisplay(new Point(toolBounds.x, toolBounds.y));
            toolBounds.x = point.x;
            toolBounds.y = point.y;
            if (chevronPosition.x >= toolBounds.x && chevronPosition.x - toolBounds.x <= toolBounds.width) break;
            ++visibleItemCount;
        }
        if (this.chevronMenuManager != null) {
            this.chevronMenuManager.dispose();
        }
        this.chevronMenuManager = new MenuManager();
        int i = visibleItemCount;
        while (i < toolCount) {
            IContributionItem data = (IContributionItem)tools[i].getData();
            if (data instanceof ActionContributionItem) {
                ActionContributionItem contribution = new ActionContributionItem(((ActionContributionItem)data).getAction());
                this.chevronMenuManager.add(contribution);
            } else if (data instanceof SubContributionItem) {
                IContributionItem innerData = ((SubContributionItem)data).getInnerItem();
                if (innerData instanceof ActionContributionItem) {
                    ActionContributionItem contribution = new ActionContributionItem(((ActionContributionItem)innerData).getAction());
                    this.chevronMenuManager.add(contribution);
                }
            } else if (data.isSeparator()) {
                this.chevronMenuManager.add(new Separator());
            }
            ++i;
        }
        Menu popup = this.chevronMenuManager.createContextMenu((Control)coolBar);
        popup.setLocation(chevronPosition.x, chevronPosition.y);
        popup.setVisible(true);
    }

    public void update(String propertyName) {
        if (this.coolItem != null) {
            boolean sizeChanged;
            boolean bl = sizeChanged = propertyName == null || propertyName.equals("size");
            if (sizeChanged) {
                this.updateSize(true);
            }
        }
        if (propertyName.equals("visibility") && this.toolBarManager != null) {
            IContributionItem[] items = this.toolBarManager.getItems();
            boolean visibleItem = false;
            int i = 0;
            while (i < items.length) {
                if (!items[i].isGroupMarker() && !items[i].isSeparator() && items[i].isVisible()) {
                    visibleItem = true;
                    break;
                }
                ++i;
            }
            if (!visibleItem) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
                if (this.getParent() != null) {
                    this.getParent().markDirty();
                }
            }
        }
    }

    public int getMinimumItemsToShow() {
        return this.minimumItemsToShow;
    }

    public void setMinimumItemsToShow(int minimumItemsToShow) {
        this.minimumItemsToShow = minimumItemsToShow;
    }

    public void setUseChevron(boolean value) {
        this.useChevron = value;
    }

    public boolean getUseChevron() {
        return this.useChevron;
    }

    public int getCurrentWidth() {
        return this.currentWidth;
    }

    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public void setCurrentHeight(int currentHeight) {
        this.currentHeight = currentHeight;
    }

    public void setCurrentWidth(int currentWidth) {
        this.currentWidth = currentWidth;
    }
}

