/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class CoolBarManager
extends ContributionManager
implements ICoolBarManager {
    private int itemStyle = 0;
    public static final String USER_SEPARATOR = "UserSeparator";
    private CoolBar coolBar = null;
    private MenuManager contextMenuManager = null;
    private ArrayList cbItemsCreationOrder = new ArrayList();

    public CoolBarManager() {
    }

    public CoolBarManager(int style) {
        this.itemStyle = style;
    }

    public CoolBarManager(CoolBar coolBar) {
        this();
        Assert.isNotNull(coolBar);
        this.coolBar = coolBar;
        this.itemStyle = coolBar.getStyle();
    }

    public void add(IToolBarManager toolBarManager) {
        Assert.isNotNull(toolBarManager);
        super.add(new ToolBarContributionItem(toolBarManager));
    }

    public CoolBar createControl(Composite parent) {
        Assert.isNotNull(parent);
        if (!this.coolBarExist()) {
            this.coolBar = new CoolBar(parent, this.itemStyle);
            this.coolBar.setMenu(this.getContextMenuControl());
            this.coolBar.setLocked(false);
            this.coolBar.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    CoolBarManager.this.coolBar.getParent().layout();
                }
            });
            this.update(false);
        }
        return this.coolBar;
    }

    protected void itemAdded(IContributionItem item) {
        Assert.isNotNull(item);
        super.itemAdded(item);
        int insertedAt = this.indexOf(item);
        this.cbItemsCreationOrder.add(Math.min(Math.max(insertedAt, 0), this.cbItemsCreationOrder.size()), item);
    }

    public void resetLayout() {
        ListIterator iterator = this.cbItemsCreationOrder.listIterator();
        while (iterator.hasNext()) {
            IContributionItem item = (IContributionItem)iterator.next();
            if (item.getId() == null || !item.getId().equals(USER_SEPARATOR)) continue;
            iterator.remove();
        }
        this.setLayout(this.cbItemsCreationOrder);
    }

    public void dispose() {
        if (this.coolBarExist()) {
            IContributionItem[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
            this.coolBar.dispose();
            this.coolBar = null;
        }
        if (this.contextMenuManager != null) {
            this.contextMenuManager.dispose();
            this.contextMenuManager = null;
        }
    }

    private boolean coolBarExist() {
        return this.coolBar != null && !this.coolBar.isDisposed();
    }

    public CoolBar getControl() {
        return this.coolBar;
    }

    private CoolItem findCoolItem(IContributionItem item) {
        if (this.coolBar == null) {
            return null;
        }
        CoolItem[] items = this.coolBar.getItems();
        int i = 0;
        while (i < items.length) {
            CoolItem coolItem = items[i];
            IContributionItem data = (IContributionItem)coolItem.getData();
            if (data != null && data.equals(item)) {
                return coolItem;
            }
            ++i;
        }
        return null;
    }

    private void dispose(CoolItem item) {
        if (item != null && !item.isDisposed()) {
            item.setData(null);
            Control control = item.getControl();
            if (control != null && !control.isDisposed()) {
                item.setControl(null);
            }
            item.dispose();
        }
    }

    protected void itemRemoved(IContributionItem item) {
        Assert.isNotNull(item);
        super.itemRemoved(item);
        CoolItem coolItem = this.findCoolItem(item);
        if (coolItem != null) {
            coolItem.setData(null);
        }
    }

    void updateTabOrder() {
        CoolItem[] items;
        if (this.coolBar != null && (items = this.coolBar.getItems()) != null) {
            ArrayList<Control> children = new ArrayList<Control>(items.length);
            int i = 0;
            while (i < items.length) {
                if (items[i].getControl() != null && !items[i].getControl().isDisposed()) {
                    children.add(items[i].getControl());
                }
                ++i;
            }
            Control[] childrenArray = new Control[]{};
            if ((childrenArray = children.toArray(childrenArray)) != null) {
                this.coolBar.setTabList(childrenArray);
            }
        }
    }

    public int getStyle() {
        return this.itemStyle;
    }

    private int[] getAdjustedWrapIndices(int[] wraps) {
        int[] adjustedWrapIndices;
        if (wraps.length == 0) {
            adjustedWrapIndices = new int[1];
        } else if (wraps[0] != 0) {
            adjustedWrapIndices = new int[wraps.length + 1];
            adjustedWrapIndices[0] = 0;
            int i = 0;
            while (i < wraps.length) {
                adjustedWrapIndices[i + 1] = wraps[i];
                ++i;
            }
        } else {
            adjustedWrapIndices = wraps;
        }
        return adjustedWrapIndices;
    }

    private ArrayList getItemList() {
        IContributionItem[] cbItems = this.getItems();
        ArrayList<IContributionItem> list = new ArrayList<IContributionItem>(cbItems.length);
        int i = 0;
        while (i < cbItems.length) {
            list.add(cbItems[i]);
            ++i;
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    private void nextRow(ListIterator iterator, boolean ignoreCurrentItem) {
        currentElement = null;
        if (!ignoreCurrentItem && iterator.hasPrevious()) {
            currentElement = (IContributionItem)iterator.previous();
            iterator.next();
        }
        if (currentElement == null || !currentElement.isSeparator()) ** GOTO lbl13
        this.collapseSeparators(iterator);
        return;
lbl-1000:
        // 1 sources

        {
            item = (IContributionItem)iterator.next();
            if (!item.isSeparator()) continue;
            this.collapseSeparators(iterator);
            return;
lbl13:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl14:
        // 1 sources

    }

    private void relocate(IContributionItem cbItem, int index, ArrayList contributionList, HashMap itemLocation) {
        if (!(itemLocation.get(cbItem) instanceof Integer)) {
            return;
        }
        int targetRow = (Integer)itemLocation.get(cbItem);
        int cbInternalIndex = contributionList.indexOf(cbItem);
        int insertAt = contributionList.size();
        ListIterator iterator = contributionList.listIterator();
        this.collapseSeparators(iterator);
        int currentRow = -1;
        while (iterator.hasNext()) {
            if (++currentRow == targetRow) {
                int virtualIndex = 0;
                insertAt = iterator.nextIndex();
                while (iterator.hasNext()) {
                    IContributionItem item = (IContributionItem)iterator.next();
                    Integer itemRow = (Integer)itemLocation.get(item);
                    if (item.isSeparator()) break;
                    if (itemRow != null && itemRow == targetRow) {
                        if (virtualIndex >= index) break;
                        ++virtualIndex;
                    }
                    ++insertAt;
                }
                if (cbInternalIndex != insertAt) break;
                return;
            }
            this.nextRow(iterator, true);
        }
        contributionList.remove(cbItem);
        if (cbInternalIndex < insertAt) {
            --insertAt;
        }
        if (currentRow != targetRow) {
            contributionList.add(new Separator(USER_SEPARATOR));
            insertAt = contributionList.size();
        }
        insertAt = Math.min(insertAt, contributionList.size());
        contributionList.add(insertAt, cbItem);
    }

    private void collapseSeparators(ListIterator iterator) {
        while (iterator.hasNext()) {
            IContributionItem item = (IContributionItem)iterator.next();
            if (item.isSeparator()) continue;
            iterator.previous();
            return;
        }
    }

    private ArrayList adjustContributionList(ArrayList contributionList) {
        if (contributionList.size() != 0) {
            IContributionItem item = (IContributionItem)contributionList.get(0);
            if (item.isSeparator()) {
                contributionList.remove(0);
            }
            ListIterator iterator = contributionList.listIterator();
            block0: while (iterator.hasNext()) {
                item = (IContributionItem)iterator.next();
                if (!item.isSeparator()) continue;
                while (iterator.hasNext()) {
                    item = (IContributionItem)iterator.next();
                    if (!item.isSeparator()) continue block0;
                    iterator.remove();
                }
            }
            item = (IContributionItem)contributionList.get(contributionList.size() - 1);
            if (item.isSeparator()) {
                contributionList.remove(contributionList.size() - 1);
            }
        }
        return contributionList;
    }

    /*
     * Exception decompiling
     */
    public void refresh() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void printContributions(ArrayList contributionList) {
        int index = 0;
        System.out.println("----------------------------------\n");
        Iterator i = contributionList.iterator();
        while (i.hasNext()) {
            IContributionItem item = (IContributionItem)i.next();
            if (item.isSeparator()) {
                System.out.println("Separator");
            } else {
                System.out.println(String.valueOf(index) + ". Item id: " + item.getId() + " - is Visible: " + item.isVisible());
            }
            ++index;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(boolean force) {
        if (!this.isDirty()) {
            if (!force) return;
        }
        if (!this.coolBarExist()) return;
        boolean relock = false;
        boolean changed = false;
        try {
            IContributionItem item;
            this.coolBar.setRedraw(false);
            this.refresh();
            int fillIndex = 0;
            boolean incrementCount = true;
            CoolItem[] coolItems = this.coolBar.getItems();
            IContributionItem[] contributionItems = this.getItems();
            int i = 0;
            while (true) {
                if (i >= contributionItems.length) break;
                contributionItems[i].update("visibility");
                if (contributionItems[i].isVisible() && !contributionItems[i].isGroupMarker() && !contributionItems[i].isSeparator()) {
                    incrementCount = true;
                    CoolItem item2 = this.findCoolItem(contributionItems[i]);
                    if (item2 == null) {
                        int prevItemCount = this.coolBar.getItemCount();
                        if (!changed) {
                            if (this.coolBar.getLocked()) {
                                this.coolBar.setLocked(false);
                                relock = true;
                            }
                            changed = true;
                        }
                        fillIndex = Math.min(fillIndex, this.coolBar.getItemCount());
                        contributionItems[i].fill(this.coolBar, fillIndex);
                        if (prevItemCount >= this.coolBar.getItemCount()) {
                            incrementCount = false;
                        }
                    }
                    if (incrementCount) {
                        ++fillIndex;
                    }
                }
                ++i;
            }
            int coolItemIndex = 0;
            while (true) {
                if (coolItemIndex >= coolItems.length) break;
                CoolItem coolItem = coolItems[coolItemIndex];
                IContributionItem foundItem = (IContributionItem)coolItems[coolItemIndex].getData();
                if (foundItem == null || !foundItem.isVisible()) {
                    this.dispose(coolItem);
                    changed = true;
                }
                ++coolItemIndex;
            }
            int numRows = this.getNumRows(contributionItems) - 1;
            int[] wrapIndicies = new int[numRows];
            int j = 0;
            boolean foundSeparator = false;
            int i2 = 0;
            while (true) {
                if (i2 >= contributionItems.length) break;
                item = contributionItems[i2];
                CoolItem coolItem = this.findCoolItem(item);
                if (item.isSeparator()) {
                    foundSeparator = true;
                }
                if (!item.isSeparator() && !item.isGroupMarker() && item.isVisible() && coolItem != null && foundSeparator) {
                    wrapIndicies[j] = this.coolBar.indexOf(coolItem);
                    ++j;
                    foundSeparator = false;
                }
                ++i2;
            }
            this.coolBar.setWrapIndices(wrapIndicies);
            i2 = 0;
            while (true) {
                block19: {
                    if (i2 < contributionItems.length) break block19;
                    if (relock) {
                        this.coolBar.setLocked(true);
                    }
                    if (changed) {
                        this.updateTabOrder();
                    }
                    this.setDirty(false);
                    break;
                }
                item = contributionItems[i2];
                item.update("size");
                ++i2;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.coolBar.setRedraw(true);
            throw throwable;
        }
        {
            Object var15_18 = null;
        }
        this.coolBar.setRedraw(true);
    }

    private int getNumRows(IContributionItem[] items) {
        int numRows = 1;
        boolean separatorFound = false;
        int i = 0;
        while (i < items.length) {
            if (items[i].isSeparator()) {
                separatorFound = true;
            }
            if (separatorFound && items[i].isVisible() && !items[i].isGroupMarker() && !items[i].isSeparator()) {
                ++numRows;
                separatorFound = false;
            }
            ++i;
        }
        return numRows;
    }

    private Menu getContextMenuControl() {
        if (this.contextMenuManager != null && this.coolBar != null) {
            Menu menuWidget = this.contextMenuManager.getMenu();
            if (menuWidget == null || menuWidget.isDisposed()) {
                menuWidget = this.contextMenuManager.createContextMenu((Control)this.coolBar);
            }
            return menuWidget;
        }
        return null;
    }

    public IMenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public void setContextMenuManager(IMenuManager contextMenuManager) {
        this.contextMenuManager = (MenuManager)contextMenuManager;
        if (this.coolBar != null) {
            this.coolBar.setMenu(this.getContextMenuControl());
        }
    }

    public boolean getLockLayout() {
        if (!this.coolBarExist()) {
            return false;
        }
        return this.coolBar.getLocked();
    }

    public void setLockLayout(boolean value) {
        if (!this.coolBarExist()) {
            return;
        }
        this.coolBar.setLocked(value);
    }

    public void setLayout(ArrayList newLayout) {
        IContributionItem[] newItems = new IContributionItem[]{};
        newItems = newLayout.toArray(newItems);
        if (this.coolBar != null) {
            CoolItem[] coolItems = this.coolBar.getItems();
            int i = 0;
            while (i < coolItems.length) {
                this.dispose(coolItems[i]);
                ++i;
            }
        }
        this.internalSetItems(newItems);
        this.update(true);
    }
}

